/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.gui;

import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.print.PrinterJob;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetViewerTable;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetViewerTablePanel;
import net.sourceforge.squirrel_sql.fw.datasetviewer.IDataSetUpdateableModel;
import net.sourceforge.squirrel_sql.fw.gui.BasePopupMenu;
import net.sourceforge.squirrel_sql.fw.gui.ButtonTableHeader;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.gui.TableCopyAlignedCommand;
import net.sourceforge.squirrel_sql.fw.gui.TableCopyAsMarkdownCommand;
import net.sourceforge.squirrel_sql.fw.gui.TableCopyColumnHeaderCommand;
import net.sourceforge.squirrel_sql.fw.gui.action.BaseAction;
import net.sourceforge.squirrel_sql.fw.gui.action.MakeEditableCommand;
import net.sourceforge.squirrel_sql.fw.gui.action.ShowReferencesCommand;
import net.sourceforge.squirrel_sql.fw.gui.action.ShowRowNumbersCommand;
import net.sourceforge.squirrel_sql.fw.gui.action.TableCopyCommand;
import net.sourceforge.squirrel_sql.fw.gui.action.TableCopyHtmlCommand;
import net.sourceforge.squirrel_sql.fw.gui.action.TableCopyInStatementCommand;
import net.sourceforge.squirrel_sql.fw.gui.action.TableCopyInsertStatementCommand;
import net.sourceforge.squirrel_sql.fw.gui.action.TableCopyUpdateStatementCommand;
import net.sourceforge.squirrel_sql.fw.gui.action.TableCopyWhereStatementCommand;
import net.sourceforge.squirrel_sql.fw.gui.action.TableExportCsvCommand;
import net.sourceforge.squirrel_sql.fw.gui.action.TableSelectAllCellsCommand;
import net.sourceforge.squirrel_sql.fw.gui.action.TableSelectEntireRowsCommand;
import net.sourceforge.squirrel_sql.fw.gui.action.UndoMakeEditableCommand;
import net.sourceforge.squirrel_sql.fw.gui.action.colorrows.ColorSelectedRowsCommand;
import net.sourceforge.squirrel_sql.fw.gui.action.colorrows.GotoColorMenuController;
import net.sourceforge.squirrel_sql.fw.gui.action.exportData.ExportDataException;
import net.sourceforge.squirrel_sql.fw.gui.action.rowselectionwindow.CopySelectedRowsToOwnWindowCommand;
import net.sourceforge.squirrel_sql.fw.gui.action.wikiTable.CopyWikiTableActionFactory;
import net.sourceforge.squirrel_sql.fw.gui.action.wikiTable.ICopyWikiTableActionFactory;
import net.sourceforge.squirrel_sql.fw.gui.action.wikiTable.ITableActionCallback;
import net.sourceforge.squirrel_sql.fw.gui.copyseparatedby.TableCopySeparatedByCommand;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class TablePopupMenu
extends BasePopupMenu {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(TablePopupMenu.class);
    private ISession _session;
    private static final KeyStroke COPY_STROKE = KeyStroke.getKeyStroke(67, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
    private final JMenuItem[] _menuItems = new JMenuItem[23];
    private DataSetViewerTable _table;
    private JCheckBoxMenuItem _alwaysAdjustAllColWidtshActionItem;
    private JCheckBoxMenuItem _showRowNumbersItem;
    private CopyAction _copy = new CopyAction();
    private CopyWithHeadersAction _copyWithHeaders = new CopyWithHeadersAction();
    private CopyHtmlAction _copyHtml = new CopyHtmlAction();
    private CopyAlignedAction _copyAligned = new CopyAlignedAction();
    private CopyAsMarkdownAction _copyAsMarkdown = new CopyAsMarkdownAction();
    private CopySeparatedByAction _copySeparatedBy = new CopySeparatedByAction();
    private CopyInStatementAction _copyInStatement = new CopyInStatementAction();
    private CopyWhereStatementAction _copyWhereStatement = new CopyWhereStatementAction();
    private CopyUpdateStatementAction _copyUpdateStatement = new CopyUpdateStatementAction();
    private CopyInsertStatementAction _copyInsertStatement = new CopyInsertStatementAction();
    private CopyColumnHeaderAction _copyColumnHeader = new CopyColumnHeaderAction();
    private ShowReferencesAction _showReferences = new ShowReferencesAction();
    private CopySelectedRowsToOwnWindowAction _copySelectedRowsToOwnWindow = new CopySelectedRowsToOwnWindowAction();
    private ColorSelectedRowsAction _colorSelectedRows = new ColorSelectedRowsAction();
    private GotoColorMenuController _gotoColorMenuController = new GotoColorMenuController();
    private ExportCsvAction _exportCvs = new ExportCsvAction();
    private AdjustAllColWidthsAction _adjustAllColWidthsAction = new AdjustAllColWidthsAction();
    private AlwaysAdjustAllColWidthsAction _alwaysAdjustAllColWidthsAction = new AlwaysAdjustAllColWidthsAction();
    private ShowRowNumbersAction _showRowNumbersAction = new ShowRowNumbersAction();
    private MakeEditableAction _makeEditable = new MakeEditableAction();
    private UndoMakeEditableAction _undoMakeEditable = new UndoMakeEditableAction();
    private DeleteRowsAction _deleteRows = new DeleteRowsAction();
    private InsertRowAction _insertRow = new InsertRowAction();
    private SelectAllAction _select = new SelectAllAction();
    private SelectRowsAction _selectRows = new SelectRowsAction();
    private PrintAction _print = new PrintAction();
    private IDataSetUpdateableModel _updateableModel = null;
    private DataSetViewerTablePanel _viewer = null;
    private ICopyWikiTableActionFactory copyWikiTableActionFactory = CopyWikiTableActionFactory.getInstance();

    public TablePopupMenu(boolean allowEditing, IDataSetUpdateableModel updateableModel, DataSetViewerTablePanel viewer, ISession session) {
        this._updateableModel = updateableModel;
        this._viewer = viewer;
        this._session = session;
        this._menuItems[0] = this.add(this._copy);
        this._menuItems[0].setAccelerator(COPY_STROKE);
        this._menuItems[1] = this.add(this._copyWithHeaders);
        this._menuItems[2] = this.add(this._copyHtml);
        this._menuItems[3] = this.add(this._copyAligned);
        this._menuItems[4] = this.add(this._copyAsMarkdown);
        this._menuItems[5] = this.add(this._copySeparatedBy);
        this._menuItems[20] = this.add(this.copyWikiTableActionFactory.createMenueItem(new ITableActionCallback(){

            @Override
            public JTable getJTable() {
                return TablePopupMenu.this._table;
            }
        }));
        this._menuItems[6] = this.add(this._copyInStatement);
        this._menuItems[7] = this.add(this._copyWhereStatement);
        this._menuItems[8] = this.add(this._copyUpdateStatement);
        this._menuItems[9] = this.add(this._copyInsertStatement);
        this._menuItems[10] = this.add(this._copyColumnHeader);
        if (null != this._session) {
            this.addSeparator();
            this._menuItems[11] = this.add(this._showReferences);
        }
        this.addSeparator();
        this._menuItems[12] = this.add(this._copySelectedRowsToOwnWindow);
        this.addSeparator();
        this._menuItems[13] = this.add(this._colorSelectedRows);
        this._menuItems[14] = this.add(this._gotoColorMenuController.getParentMenu());
        this.addSeparator();
        this._menuItems[15] = this.add(this._exportCvs);
        this.addSeparator();
        this._menuItems[17] = this.add(this._adjustAllColWidthsAction);
        this._alwaysAdjustAllColWidtshActionItem = new JCheckBoxMenuItem();
        this._alwaysAdjustAllColWidtshActionItem.setSelected(ButtonTableHeader.isAlwaysAdjustAllColWidths());
        this._alwaysAdjustAllColWidtshActionItem.setAction(this._alwaysAdjustAllColWidthsAction);
        this._menuItems[18] = this.add(this._alwaysAdjustAllColWidtshActionItem);
        this.addSeparator();
        this._showRowNumbersItem = new JCheckBoxMenuItem();
        this._showRowNumbersItem.setSelected(false);
        this._showRowNumbersItem.setAction(this._showRowNumbersAction);
        this._menuItems[19] = this.add(this._showRowNumbersItem);
        if (allowEditing) {
            this.addSeparator();
            this.add(this._makeEditable);
        }
        if (updateableModel != null && updateableModel.editModeIsForced()) {
            this.add(this._undoMakeEditable);
        }
        this.addSeparator();
        this._menuItems[16] = this.add(this._select);
        this._menuItems[21] = this.add(this._selectRows);
        if (this._updateableModel != null && !allowEditing) {
            this.addSeparator();
            this.add(this._insertRow);
            this.add(this._deleteRows);
        }
        this.addSeparator();
        this.add(this._print);
    }

    public TablePopupMenu(IDataSetUpdateableModel updateableModel, DataSetViewerTablePanel viewer, DataSetViewerTable table) {
        this._updateableModel = updateableModel;
        this._viewer = viewer;
        this._table = table;
        this.replaceStandardTableCopyAction();
        this.add(this._select);
        this.addSeparator();
        this.add(this._insertRow);
        this.add(this._deleteRows);
        this.addSeparator();
        this.add(this._print);
    }

    public void setTable(DataSetViewerTable value) {
        this._table = value;
        this.replaceStandardTableCopyAction();
    }

    public void reset() {
        this._showRowNumbersItem.setSelected(false);
    }

    private void replaceStandardTableCopyAction() {
        this._table.getInputMap(1).put(COPY_STROKE, "CopyAction");
        this._table.getInputMap(2).put(COPY_STROKE, "CopyAction");
        this._table.getInputMap(0).put(COPY_STROKE, "CopyAction");
        this._table.getActionMap().put("CopyAction", this._copy);
    }

    @Override
    public void show(Component invoker, int x, int y) {
        this._gotoColorMenuController.createSubMenus(this._table);
        super.show(invoker, x, y);
    }

    @Override
    public void show(MouseEvent evt) {
        super.show(evt);
    }

    public void ensureRowNumersMenuItemIsUpToDate(boolean currentState) {
        if (currentState == this._showRowNumbersItem.isSelected()) {
            return;
        }
        this._showRowNumbersItem.setAction(null);
        this._showRowNumbersItem.setSelected(currentState);
        this._showRowNumbersItem.setAction(this._showRowNumbersAction);
    }

    private class PrintAction
    extends BaseAction {
        PrintAction() {
            super(s_stringMgr.getString("TablePopupMenu.print"));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (TablePopupMenu.this._table != null) {
                try {
                    PrinterJob printerJob = PrinterJob.getPrinterJob();
                    printerJob.setPrintable(TablePopupMenu.this._viewer);
                    if (printerJob.printDialog()) {
                        printerJob.print();
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private class SelectRowsAction
    extends BaseAction {
        SelectRowsAction() {
            super(s_stringMgr.getString("TablePopupMenu.selectEntireRows"));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (TablePopupMenu.this._table != null) {
                new TableSelectEntireRowsCommand(TablePopupMenu.this._table).execute();
            }
        }
    }

    private class SelectAllAction
    extends BaseAction {
        SelectAllAction() {
            super(s_stringMgr.getString("TablePopupMenu.selectall"));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (TablePopupMenu.this._table != null) {
                new TableSelectAllCellsCommand(TablePopupMenu.this._table).execute();
            }
        }
    }

    private class InsertRowAction
    extends BaseAction {
        InsertRowAction() {
            super(s_stringMgr.getString("TablePopupMenu.insertrow"));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            TablePopupMenu.this._viewer.insertRow();
        }
    }

    private class DeleteRowsAction
    extends BaseAction {
        DeleteRowsAction() {
            super(s_stringMgr.getString("TablePopupMenu.deleterows"));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (TablePopupMenu.this._table != null) {
                int[] selectedRows = TablePopupMenu.this._table.getSelectedRows();
                TablePopupMenu.this._viewer.deleteRows(selectedRows);
            }
        }
    }

    private class UndoMakeEditableAction
    extends BaseAction {
        UndoMakeEditableAction() {
            super(s_stringMgr.getString("TablePopupMenu.undomakeeditable"));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (TablePopupMenu.this._updateableModel != null) {
                new UndoMakeEditableCommand(TablePopupMenu.this._updateableModel).execute();
            }
        }
    }

    private class MakeEditableAction
    extends BaseAction {
        MakeEditableAction() {
            super(s_stringMgr.getString("TablePopupMenu.makeeditable"));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (TablePopupMenu.this._updateableModel != null) {
                new MakeEditableCommand(TablePopupMenu.this._updateableModel).execute();
            }
        }
    }

    private class ShowRowNumbersAction
    extends BaseAction {
        ShowRowNumbersAction() {
            super(s_stringMgr.getString("TablePopupMenu.showRowNumbers"));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (TablePopupMenu.this._table != null) {
                JCheckBoxMenuItem mnu = (JCheckBoxMenuItem)evt.getSource();
                new ShowRowNumbersCommand(TablePopupMenu.this._viewer, mnu.isSelected()).execute();
            }
        }
    }

    private class AlwaysAdjustAllColWidthsAction
    extends BaseAction {
        AlwaysAdjustAllColWidthsAction() {
            super(s_stringMgr.getString("TablePopupMenu.alwaysAdoptAllColWiths"));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            ButtonTableHeader.setAlwaysAdjustAllColWidths(TablePopupMenu.this._alwaysAdjustAllColWidtshActionItem.isSelected());
            if (TablePopupMenu.this._table != null && TablePopupMenu.this._alwaysAdjustAllColWidtshActionItem.isSelected()) {
                ((ButtonTableHeader)TablePopupMenu.this._table.getTableHeader()).adjustAllColWidths(true);
            }
        }
    }

    private class AdjustAllColWidthsAction
    extends BaseAction {
        AdjustAllColWidthsAction() {
            super(s_stringMgr.getString("TablePopupMenu.adoptAllColWidthsAction"));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (TablePopupMenu.this._table != null && TablePopupMenu.this._table.getTableHeader() instanceof ButtonTableHeader) {
                ((ButtonTableHeader)TablePopupMenu.this._table.getTableHeader()).adjustAllColWidths(true);
            }
        }
    }

    private class ColorSelectedRowsAction
    extends BaseAction {
        ColorSelectedRowsAction() {
            super(s_stringMgr.getString("TablePopupMenu.ColorSelectedRows"));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (TablePopupMenu.this._table != null) {
                new ColorSelectedRowsCommand(TablePopupMenu.this._table).execute();
            }
        }
    }

    private class CopySelectedRowsToOwnWindowAction
    extends BaseAction {
        CopySelectedRowsToOwnWindowAction() {
            super(s_stringMgr.getString("TablePopupMenu.CopySelectedRowsToOwnWindow"));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (TablePopupMenu.this._table != null) {
                new CopySelectedRowsToOwnWindowCommand(TablePopupMenu.this._table, TablePopupMenu.this._session).execute();
            }
        }
    }

    private class ShowReferencesAction
    extends BaseAction {
        ShowReferencesAction() {
            super(s_stringMgr.getString("TablePopupMenu.showRefernces"));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (TablePopupMenu.this._table != null) {
                new ShowReferencesCommand(TablePopupMenu.this._table, TablePopupMenu.this._updateableModel, (JFrame)GUIUtils.getOwningFrame(TablePopupMenu.this._table), TablePopupMenu.this._session).execute();
            }
        }
    }

    private class ExportCsvAction
    extends BaseAction {
        ExportCsvAction() {
            super(s_stringMgr.getString("TablePopupMenu.export"));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (TablePopupMenu.this._table != null) {
                try {
                    new TableExportCsvCommand(TablePopupMenu.this._table).execute((JFrame)GUIUtils.getOwningFrame(TablePopupMenu.this._table));
                }
                catch (ExportDataException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private class CopyColumnHeaderAction
    extends BaseAction {
        CopyColumnHeaderAction() {
            super(s_stringMgr.getString("TablePopupMenu.copycolumnheader"));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (TablePopupMenu.this._table != null) {
                new TableCopyColumnHeaderCommand(TablePopupMenu.this._table).execute();
            }
        }
    }

    private class CopyInsertStatementAction
    extends BaseAction {
        CopyInsertStatementAction() {
            super(s_stringMgr.getString("TablePopupMenu.copyasinsertstatement"));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (TablePopupMenu.this._table != null) {
                new TableCopyInsertStatementCommand(TablePopupMenu.this._table, TablePopupMenu.this._viewer.getDataModelImplementationDetails()).execute();
            }
        }
    }

    private class CopyUpdateStatementAction
    extends BaseAction {
        CopyUpdateStatementAction() {
            super(s_stringMgr.getString("TablePopupMenu.copyasupdatestatement"));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (TablePopupMenu.this._table != null) {
                new TableCopyUpdateStatementCommand(TablePopupMenu.this._table, TablePopupMenu.this._viewer.getDataModelImplementationDetails()).execute();
            }
        }
    }

    private class CopyWhereStatementAction
    extends BaseAction {
        CopyWhereStatementAction() {
            super(s_stringMgr.getString("TablePopupMenu.copyaswherestatement"));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (TablePopupMenu.this._table != null) {
                new TableCopyWhereStatementCommand(TablePopupMenu.this._table).execute();
            }
        }
    }

    private class CopyInStatementAction
    extends BaseAction {
        CopyInStatementAction() {
            super(s_stringMgr.getString("TablePopupMenu.copyasinstatement"));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (TablePopupMenu.this._table != null) {
                new TableCopyInStatementCommand(TablePopupMenu.this._table).execute();
            }
        }
    }

    private class CopySeparatedByAction
    extends BaseAction {
        CopySeparatedByAction() {
            super(s_stringMgr.getString("TablePopupMenu.copyseparatedby"));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (TablePopupMenu.this._table != null) {
                new TableCopySeparatedByCommand(TablePopupMenu.this._table).execute();
            }
        }
    }

    private class CopyAsMarkdownAction
    extends BaseAction {
        CopyAsMarkdownAction() {
            super(s_stringMgr.getString("TablePopupMenu.copyasmarkdown"));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (TablePopupMenu.this._table != null) {
                new TableCopyAsMarkdownCommand(TablePopupMenu.this._table, TablePopupMenu.this._session).execute();
            }
        }
    }

    private class CopyAlignedAction
    extends BaseAction {
        CopyAlignedAction() {
            super(s_stringMgr.getString("TablePopupMenu.copyaligned"));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (TablePopupMenu.this._table != null) {
                new TableCopyAlignedCommand(TablePopupMenu.this._table, TablePopupMenu.this._session).execute();
            }
        }
    }

    private class CopyHtmlAction
    extends BaseAction {
        CopyHtmlAction() {
            super(s_stringMgr.getString("TablePopupMenu.copyashtml"));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (TablePopupMenu.this._table != null) {
                new TableCopyHtmlCommand(TablePopupMenu.this._table).execute();
            }
        }
    }

    private class CopyWithHeadersAction
    extends BaseAction {
        CopyWithHeadersAction() {
            super(s_stringMgr.getString("TablePopupMenu.copyWithHeaders"));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (TablePopupMenu.this._table != null) {
                new TableCopyCommand(TablePopupMenu.this._table, true).execute();
            }
        }
    }

    private class CopyAction
    extends BaseAction {
        CopyAction() {
            super(s_stringMgr.getString("TablePopupMenu.copy"));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (TablePopupMenu.this._table != null) {
                new TableCopyCommand(TablePopupMenu.this._table, false).execute();
            }
        }
    }

    public static interface IOptionTypes {
        public static final int COPY = 0;
        public static final int COPY_WITH_HEADERS = 1;
        public static final int COPY_HTML = 2;
        public static final int COPY_ALIGNED = 3;
        public static final int COPY_MARKDOWN = 4;
        public static final int COPY_SEPARATED_BY = 5;
        public static final int COPY_IN_STATEMENT = 6;
        public static final int COPY_WHERE_STATEMENT = 7;
        public static final int COPY_UPDATE_STATEMENT = 8;
        public static final int COPY_INSERT_STATEMENT = 9;
        public static final int COPY_COLUMN_HEADER = 10;
        public static final int SHOW_REFERENCES = 11;
        public static final int COPY_SELECTED_ROWS_TO_OWN_WINDOW = 12;
        public static final int COLOR_SELECTED_ROWS = 13;
        public static final int GOTO_COLOR = 14;
        public static final int EXPORT_CSV = 15;
        public static final int SELECT_ALL = 16;
        public static final int ADJUST_ALL_COL_WIDTHS_ACTION = 17;
        public static final int ALWAYS_ADJUST_ALL_COL_WIDTHS_ACTION = 18;
        public static final int SHOW_ROW_NUMBERS = 19;
        public static final int COPY_WIKI = 20;
        public static final int SELECT_ROWS = 21;
        public static final int LAST_ENTRY = 22;
    }
}

