/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.gui.action;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import javax.swing.JTable;
import net.sourceforge.squirrel_sql.fw.gui.action.wikiTable.IWikiTableConfiguration;
import net.sourceforge.squirrel_sql.fw.gui.action.wikiTable.WikiTableSelection;
import net.sourceforge.squirrel_sql.fw.util.ICommand;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class TableCopyWikiCommand
implements ICommand {
    private static ILogger s_log = LoggerController.createLogger(TableCopyWikiCommand.class);
    private IWikiTableConfiguration config = null;
    private JTable table = null;
    private WikiTableSelection selection = null;
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(TableCopyWikiCommand.class);

    public TableCopyWikiCommand(JTable aTable, IWikiTableConfiguration wikiConfig) {
        if (aTable == null) {
            throw new IllegalArgumentException("JTable == null");
        }
        if (wikiConfig == null) {
            throw new IllegalArgumentException("wikiConfig == null");
        }
        this.table = aTable;
        this.config = wikiConfig;
        try {
            this.selection = new WikiTableSelection();
        }
        catch (ClassNotFoundException e) {
            String msg = s_stringMgr.getString("TableCopyWikiCommand.error.flavors");
            s_log.error(msg, e);
        }
    }

    @Override
    public void execute() {
        String result = this.config.createTransformer().transform(this.table);
        if (result != null) {
            this.selection.setData(result);
            Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
            cb.setContents(this.selection, null);
        }
    }
}

