/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.gui.action;

import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.gui.action.LineSeparator;
import net.sourceforge.squirrel_sql.fw.gui.action.TableExportCsvDlg;
import net.sourceforge.squirrel_sql.fw.gui.action.TableExportPreferences;
import net.sourceforge.squirrel_sql.fw.gui.action.TableExportPreferencesDAO;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class TableExportCsvController {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(TableExportCsvController.class);
    private TableExportCsvDlg _dlg;
    private boolean _ok = false;
    private JFrame _owner;

    TableExportCsvController(JFrame owner) {
        this._owner = owner;
        this._dlg = this.createDialog(owner);
        this.initDlg();
        this.initListeners();
        this._dlg.txtSeparatorChar.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                TableExportCsvController.this.onSeparatorCharChanged(e);
            }
        });
        this._dlg.getRootPane().setDefaultButton(this._dlg.btnOk);
        this.installEscapeClose();
        this._dlg.pack();
        GUIUtils.centerWithinParent(this._dlg);
        this._dlg.setVisible(true);
    }

    protected TableExportCsvDlg createDialog(JFrame owner) {
        return new TableExportCsvDlg(owner);
    }

    private void onSeparatorCharChanged(KeyEvent e) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                String text = ((TableExportCsvController)TableExportCsvController.this)._dlg.txtSeparatorChar.getText();
                if (null != text && 1 < text.length()) {
                    ((TableExportCsvController)TableExportCsvController.this)._dlg.txtSeparatorChar.setText(text.substring(0, 1));
                    Toolkit.getDefaultToolkit().beep();
                }
            }
        });
    }

    private void initListeners() {
        this._dlg.btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableExportCsvController.this.onOK();
            }
        });
        this._dlg.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableExportCsvController.this.closeDlg();
            }
        });
        this._dlg.radFormatCSV.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableExportCsvController.this.onFormat(true);
            }
        });
        this._dlg.radFormatXLSX.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableExportCsvController.this.onFormat(true);
            }
        });
        this._dlg.radFormatXLS.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableExportCsvController.this.onFormat(true);
            }
        });
        this._dlg.radFormatXML.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableExportCsvController.this.onFormat(true);
            }
        });
        this._dlg.radFormatJSON.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableExportCsvController.this.onFormat(true);
            }
        });
        this._dlg.chkSeparatorTab.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableExportCsvController.this.onFormat(false);
            }
        });
        this._dlg.chkExecCommand.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableExportCsvController.this.onChkExecCommand();
            }
        });
        this._dlg.btnFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableExportCsvController.this.onFile();
            }
        });
        this._dlg.btnCommandFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableExportCsvController.this.onCommandFile();
            }
        });
    }

    private void onFormat(boolean replaceEnding) {
        if (this._dlg.radFormatCSV.isSelected()) {
            this._dlg.lblSeparator.setEnabled(true);
            this._dlg.chkSeparatorTab.setEnabled(true);
            this._dlg.txtSeparatorChar.setEnabled(true);
            this._dlg.lblCharset.setEnabled(true);
            this._dlg.charsets.setEnabled(true);
            this._dlg.lblLineSeparator.setEnabled(true);
            this._dlg._lineSeparators.setEnabled(true);
            if (this._dlg.chkSeparatorTab.isSelected()) {
                this._dlg.txtSeparatorChar.setText(null);
                this._dlg.txtSeparatorChar.setEnabled(false);
                this._dlg.lblSeparator.setEnabled(false);
            } else {
                this._dlg.txtSeparatorChar.setEnabled(true);
                this._dlg.lblSeparator.setEnabled(true);
            }
            if (replaceEnding) {
                this.replaceFileEnding();
            }
        } else if (this._dlg.radFormatXLSX.isSelected() || this._dlg.radFormatXLS.isSelected()) {
            this._dlg.lblSeparator.setEnabled(false);
            this._dlg.lblCharset.setEnabled(false);
            this._dlg.chkSeparatorTab.setEnabled(false);
            this._dlg.txtSeparatorChar.setEnabled(false);
            this._dlg.charsets.setEnabled(false);
            this._dlg.lblLineSeparator.setEnabled(false);
            this._dlg._lineSeparators.setEnabled(false);
            if (replaceEnding) {
                this.replaceFileEnding();
            }
        } else if (this._dlg.radFormatXML.isSelected() || this._dlg.radFormatJSON.isSelected()) {
            this._dlg.lblSeparator.setEnabled(false);
            this._dlg.lblCharset.setEnabled(false);
            this._dlg.chkSeparatorTab.setEnabled(false);
            this._dlg.txtSeparatorChar.setEnabled(false);
            this._dlg.charsets.setEnabled(false);
            this._dlg.lblLineSeparator.setEnabled(false);
            this._dlg._lineSeparators.setEnabled(false);
            if (replaceEnding) {
                this.replaceFileEnding();
            }
        } else {
            throw new IllegalStateException("No valid output format");
        }
    }

    private void replaceFileEnding() {
        String newEnding;
        if (this._dlg.radFormatCSV.isSelected()) {
            newEnding = "csv";
        } else if (this._dlg.radFormatXLSX.isSelected()) {
            newEnding = "xlsx";
        } else if (this._dlg.radFormatXLS.isSelected()) {
            newEnding = "xls";
        } else if (this._dlg.radFormatXML.isSelected()) {
            newEnding = "xml";
        } else if (this._dlg.radFormatJSON.isSelected()) {
            newEnding = "json";
        } else {
            throw new IllegalStateException("No valid output format");
        }
        String file = this._dlg.txtFile.getText();
        if (null == file || 0 == file.trim().length() || file.toUpperCase().endsWith("." + newEnding.toUpperCase())) {
            return;
        }
        String newFile = -1 == (file = file.trim()).lastIndexOf(".") || file.lastIndexOf(".") < file.lastIndexOf(File.separator) ? file + "." + newEnding : (file.lastIndexOf(".") > file.lastIndexOf(File.separator) ? file.substring(0, file.lastIndexOf(".")) + "." + newEnding : file);
        this._dlg.txtFile.setText(newFile);
    }

    private void onCommandFile() {
        JFileChooser chooser = new JFileChooser(System.getProperties().getProperty("user.home"));
        chooser.setFileSelectionMode(2);
        chooser.setDialogTitle(s_stringMgr.getString("TableExportCsvController.commandChooserTitel"));
        if (0 != chooser.showDialog(this._dlg, s_stringMgr.getString("TableExportCsvController.commandChooserButton"))) {
            return;
        }
        if (null != chooser.getSelectedFile()) {
            this._dlg.txtCommand.setText(chooser.getSelectedFile().getPath() + " %file");
        }
    }

    private void onFile() {
        File csvFile;
        File parentFile;
        JFileChooser chooser = null;
        String csvFileName = this._dlg.txtFile.getText();
        if (null != csvFileName && 0 < csvFileName.trim().length() && null != (parentFile = (csvFile = new File(csvFileName)).getParentFile()) && parentFile.exists()) {
            chooser = new JFileChooser(parentFile);
        }
        if (null == chooser) {
            chooser = new JFileChooser(System.getProperties().getProperty("user.home"));
        }
        chooser.setFileSelectionMode(0);
        chooser.setDialogTitle(s_stringMgr.getString("TableExportCsvController.fileChooserTitel"));
        if (0 != chooser.showDialog(this._dlg, s_stringMgr.getString("TableExportCsvController.fileChooserButton"))) {
            return;
        }
        if (null != chooser.getSelectedFile()) {
            this._dlg.txtFile.setText(chooser.getSelectedFile().getPath());
        }
    }

    private void onOK() {
        String msg;
        String command;
        String sepChar;
        if (!this.warnIfExcel()) {
            return;
        }
        String csvFileName = this._dlg.txtFile.getText();
        if (null == csvFileName || 0 == csvFileName.trim().length()) {
            String msg2 = s_stringMgr.getString("TableExportCsvController.noFile");
            JOptionPane.showMessageDialog(this._dlg, msg2);
            return;
        }
        if (!(this._dlg.chkSeparatorTab.isSelected() || null != (sepChar = this._dlg.txtSeparatorChar.getText()) && 1 == sepChar.trim().length())) {
            String msg3 = s_stringMgr.getString("TableExportCsvController.invalidSeparator");
            JOptionPane.showMessageDialog(this._dlg, msg3);
            return;
        }
        if (this._dlg.chkExecCommand.isSelected() && (null == (command = this._dlg.txtCommand.getText()) || 0 == command.trim().length())) {
            String msg4 = s_stringMgr.getString("TableExportCsvController.noCommand");
            JOptionPane.showMessageDialog(this._dlg, msg4);
            return;
        }
        if (new File(csvFileName).exists() && 0 != JOptionPane.showConfirmDialog(this._dlg, msg = s_stringMgr.getString("TableExportCsvController.replaceFile"))) {
            return;
        }
        this.writePrefs();
        this._ok = true;
        this.closeDlg();
    }

    private boolean warnIfExcel() {
        String msg;
        int option;
        return !this._dlg.radFormatXLS.isSelected() || !this.shouldWarnIfExcel() || (option = JOptionPane.showConfirmDialog(this._dlg, msg = s_stringMgr.getString("TableExportCsvController.warnIfExcel"), null, 2)) == 0;
    }

    protected boolean shouldWarnIfExcel() {
        return false;
    }

    protected void writePrefs() {
        TableExportPreferences tableExportPreferences = new TableExportPreferences();
        this.writeControlsToPrefs(tableExportPreferences);
        TableExportPreferencesDAO.savePreferences(tableExportPreferences);
    }

    protected void writeControlsToPrefs(TableExportPreferences prefs) {
        prefs.setCsvFile(this._dlg.txtFile.getText());
        prefs.setCsvEncoding(this._dlg.charsets.getSelectedItem().toString());
        prefs.setWithHeaders(this._dlg.chkWithHeaders.isSelected());
        prefs.setFormatCSV(this._dlg.radFormatCSV.isSelected());
        prefs.setFormatXLS(this._dlg.radFormatXLSX.isSelected());
        prefs.setFormatXLSOld(this._dlg.radFormatXLS.isSelected());
        prefs.setFormatXML(this._dlg.radFormatXML.isSelected());
        prefs.setFormatJSON(this._dlg.radFormatJSON.isSelected());
        prefs.setSeperatorTab(this._dlg.chkSeparatorTab.isSelected());
        prefs.setSeperatorChar(this._dlg.txtSeparatorChar.getText());
        prefs.setLineSeperator(((LineSeparator)((Object)this._dlg._lineSeparators.getSelectedItem())).name());
        prefs.setExportComplete(this._dlg.radComplete.isSelected());
        prefs.setUseGlobalPrefsFormating(this._dlg.radUseGlobalPrefsFormating.isSelected());
        prefs.setExecuteCommand(this._dlg.chkExecCommand.isSelected());
        prefs.setCommand(this._dlg.txtCommand.getText());
    }

    private void initDlg() {
        TableExportPreferences prefs = TableExportPreferencesDAO.loadPreferences();
        if (this.formatIsNewXlsx(prefs)) {
            this._dlg.txtFile.setText(this.replaceXlsByXlsx(prefs.getCsvFile()));
        } else {
            this._dlg.txtFile.setText(prefs.getCsvFile());
        }
        this._dlg.charsets.setSelectedItem(prefs.getCsvEncoding());
        this._dlg.chkWithHeaders.setSelected(prefs.isWithHeaders());
        this._dlg.chkSeparatorTab.setSelected(prefs.isSeperatorTab());
        if (!this._dlg.chkSeparatorTab.isSelected()) {
            this._dlg.txtSeparatorChar.setText(prefs.getSeperatorChar());
        }
        if (prefs.isFormatCSV()) {
            this._dlg.radFormatCSV.setSelected(true);
        } else if (this.formatIsNewXlsx(prefs)) {
            this._dlg.radFormatXLSX.setSelected(true);
        } else if (prefs.isFormatXLSOld()) {
            this._dlg.radFormatXLS.setSelected(true);
        } else if (prefs.isFormatXML()) {
            this._dlg.radFormatXML.setSelected(true);
        } else if (prefs.isFormatJSON()) {
            this._dlg.radFormatJSON.setSelected(true);
        } else {
            this._dlg.radFormatCSV.setSelected(true);
        }
        this.onFormat(false);
        this.initSelectionPanel(prefs);
        if (prefs.isUseGlobalPrefsFormating()) {
            this._dlg.radUseGlobalPrefsFormating.setSelected(true);
        } else {
            this._dlg.radUseDefaultFormating.setSelected(true);
        }
        this._dlg.chkExecCommand.setSelected(prefs.isExecuteCommand());
        this.onChkExecCommand();
        this._dlg.txtCommand.setText(prefs.getCommand());
        LineSeparator preferredLineSeparator = LineSeparator.valueOf(prefs.getLineSeperator());
        this._dlg._lineSeparators.setSelectedItem((Object)preferredLineSeparator);
    }

    private boolean formatIsNewXlsx(TableExportPreferences preferences) {
        return preferences.isFormatXLS();
    }

    private String replaceXlsByXlsx(String fileName) {
        String oldXlsSuffix = ".xls";
        if (null != fileName && fileName.toLowerCase().endsWith(oldXlsSuffix)) {
            fileName = fileName.substring(0, fileName.length() - oldXlsSuffix.length()) + ".xlsx";
        }
        return fileName;
    }

    protected void initSelectionPanel(TableExportPreferences userRoot) {
        if (userRoot.isExportComplete()) {
            this._dlg.radComplete.setSelected(true);
        } else {
            this._dlg.radSelection.setSelected(true);
        }
    }

    private void onChkExecCommand() {
        this._dlg.txtCommand.setEnabled(this._dlg.chkExecCommand.isSelected());
        this._dlg.btnCommandFile.setEnabled(this._dlg.chkExecCommand.isSelected());
    }

    private void installEscapeClose() {
        AbstractAction closeAction = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TableExportCsvController.this.closeDlg();
            }
        };
        KeyStroke escapeStroke = KeyStroke.getKeyStroke(27, 0);
        this._dlg.getRootPane().getInputMap(1).put(escapeStroke, "CloseAction");
        this._dlg.getRootPane().getInputMap(2).put(escapeStroke, "CloseAction");
        this._dlg.getRootPane().getInputMap(0).put(escapeStroke, "CloseAction");
        this._dlg.getRootPane().getActionMap().put("CloseAction", closeAction);
    }

    private void closeDlg() {
        this._dlg.setVisible(false);
        this._dlg.dispose();
    }

    boolean isOK() {
        return this._ok;
    }

    File getFile() {
        return new File(this._dlg.txtFile.getText());
    }

    public String getSeparatorChar() {
        if (this._dlg.chkSeparatorTab.isSelected()) {
            return "\t";
        }
        return this._dlg.txtSeparatorChar.getText();
    }

    boolean exportComplete() {
        return this._dlg.radComplete.isSelected();
    }

    String getCommand() {
        if (this._dlg.chkExecCommand.isSelected()) {
            return this._dlg.txtCommand.getText().replaceAll("%file", this._dlg.txtFile.getText().replaceAll("\\\\", "\\\\\\\\"));
        }
        return null;
    }

    protected TableExportCsvDlg getDialog() {
        return this._dlg;
    }

    public Frame getOwningFrame() {
        return this._owner;
    }
}

