/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.gui.action.rowselectionwindow;

import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.table.TableColumnModel;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ColumnDisplayDefinition;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ExtTableColumn;
import net.sourceforge.squirrel_sql.fw.datasetviewer.RowNumberTableColumn;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.gui.action.rowselectionwindow.RowSelectionTableUtil;
import net.sourceforge.squirrel_sql.fw.gui.action.rowselectionwindow.RowsWindowFrame;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class CopySelectedRowsToOwnWindowCommand {
    private static ILogger s_log = LoggerController.createLogger(CopySelectedRowsToOwnWindowCommand.class);
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(CopySelectedRowsToOwnWindowCommand.class);
    private final JTable _table;
    private final ISession _session;

    public CopySelectedRowsToOwnWindowCommand(JTable table, ISession session) {
        this._table = table;
        this._session = session;
    }

    public void execute() {
        ArrayList<ColumnDisplayDefinition> columnDisplayDefinitionsSortedByModelIndex = this.getColumnDisplayDefinitionsSortedByModelIndex();
        if (columnDisplayDefinitionsSortedByModelIndex == null) {
            return;
        }
        ArrayList<Object[]> rows = RowSelectionTableUtil.getSelectedRows(this._table);
        final ArrayList<RowsWindowFrame> rowsWindowFrames = Main.getApplication().getRowsWindowFrameRegistry().getMatchingWindows(columnDisplayDefinitionsSortedByModelIndex);
        if (0 == rowsWindowFrames.size()) {
            RowsWindowFrame rowsWindowFrame = this.openWindowForTable(rows, columnDisplayDefinitionsSortedByModelIndex);
            Main.getApplication().getRowsWindowFrameRegistry().add(rowsWindowFrame);
        } else {
            JPopupMenu popupRowsWindows = new JPopupMenu();
            for (final RowsWindowFrame rowsWindowFrame : rowsWindowFrames) {
                JMenuItem mi = new JMenuItem(rowsWindowFrame.getTitle());
                mi.addActionListener(e -> this.onMenuItemSelected(rowsWindowFrame, rows, columnDisplayDefinitionsSortedByModelIndex));
                mi.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseEntered(MouseEvent e) {
                        rowsWindowFrame.markWindow(true);
                    }

                    @Override
                    public void mouseExited(MouseEvent e) {
                        rowsWindowFrame.markWindow(false);
                    }
                });
                popupRowsWindows.add(mi);
            }
            JMenuItem mi = new JMenuItem(s_stringMgr.getString("CopySelectedRowsToOwnWindowCommand.new.window"));
            mi.addActionListener(e -> this.onMenuItemSelected(null, rows, columnDisplayDefinitionsSortedByModelIndex));
            popupRowsWindows.add(mi);
            popupRowsWindows.addPopupMenuListener(new PopupMenuListener(){

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                    rowsWindowFrames.forEach(w -> w.markWindow(false));
                }

                @Override
                public void popupMenuCanceled(PopupMenuEvent e) {
                    rowsWindowFrames.forEach(w -> w.markWindow(false));
                }
            });
            Point mouseLocationOnScreen = MouseInfo.getPointerInfo().getLocation();
            popupRowsWindows.show(this._table, mouseLocationOnScreen.x - this._table.getLocationOnScreen().x - 5, mouseLocationOnScreen.y - this._table.getLocationOnScreen().y - 5);
        }
    }

    private ArrayList<ColumnDisplayDefinition> getColumnDisplayDefinitionsSortedByModelIndex() {
        TreeMap<Integer, ColumnDisplayDefinition> sortedMap = new TreeMap<Integer, ColumnDisplayDefinition>();
        TableColumnModel columnModel = this._table.getColumnModel();
        for (int i = 0; i < columnModel.getColumnCount(); ++i) {
            if (columnModel.getColumn(i) instanceof ExtTableColumn) {
                ExtTableColumn col = (ExtTableColumn)columnModel.getColumn(i);
                sortedMap.put(col.getModelIndex(), col.getColumnDisplayDefinition());
                continue;
            }
            if (columnModel.getColumn(i) instanceof RowNumberTableColumn) continue;
            s_log.error("Failed to copy selected rows to own table. Expected column " + columnModel.getColumn(i).getHeaderValue() + " to be of type ExtTableColumn but was of type " + columnModel.getColumn(i).getClass().getName());
            return null;
        }
        ArrayList<ColumnDisplayDefinition> columnDisplayDefinitions = new ArrayList<ColumnDisplayDefinition>(sortedMap.values());
        return columnDisplayDefinitions;
    }

    private void onMenuItemSelected(RowsWindowFrame rowsWindowFrame, List<Object[]> rows, ArrayList<ColumnDisplayDefinition> columnDisplayDefinitions) {
        if (null == rowsWindowFrame) {
            RowsWindowFrame newRowsWindowFrame = this.openWindowForTable(rows, columnDisplayDefinitions);
            Main.getApplication().getRowsWindowFrameRegistry().add(newRowsWindowFrame);
        } else {
            rowsWindowFrame.appendSelectedRows(rows, columnDisplayDefinitions);
        }
    }

    private RowsWindowFrame openWindowForTable(List<Object[]> rows, ArrayList<ColumnDisplayDefinition> columnDisplayDefinitions) {
        Window parent = SwingUtilities.windowForComponent(this._table);
        RowsWindowFrame rowsWindowFrame = new RowsWindowFrame(rows, parent, columnDisplayDefinitions, this._session);
        GUIUtils.centerWithinParent(rowsWindowFrame);
        return rowsWindowFrame;
    }
}

