/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.gui.action.rowselectionwindow;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.session.DataModelImplementationDetails;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ColumnDisplayDefinition;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetException;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetViewerTable;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetViewerTablePanel;
import net.sourceforge.squirrel_sql.fw.datasetviewer.SimpleDataSet;
import net.sourceforge.squirrel_sql.fw.gui.action.rowselectionwindow.RowSelectionTableUtil;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.Utilities;

public class RowsWindowFrame
extends JDialog {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(RowsWindowFrame.class);
    private static final String PREF_KEY_ROWS_WINDOW_FRAME_WIDTH = "Squirrel.rowselectionwindow.FrameWidth";
    private static final String PREF_KEY_ROWS_WINDOW_FRAME_HIGHT = "Squirrel.rowselectionwindow.FrameHight";
    private final JPanel _contentPanel;
    private ArrayList<ColumnDisplayDefinition> _columnDisplayDefinitions;
    private ISession _session;
    private int _myCounterId;
    private final DataSetViewerTablePanel _dataSetViewerTablePanel;

    public RowsWindowFrame(List<Object[]> rows, Window parent, ArrayList<ColumnDisplayDefinition> columnDisplayDefinitions, ISession session) {
        super(parent);
        this._columnDisplayDefinitions = columnDisplayDefinitions;
        this._session = session;
        this.getContentPane().setLayout(new GridLayout(1, 1));
        this._contentPanel = new JPanel(new GridLayout(1, 1));
        this.getContentPane().add(this._contentPanel);
        this._dataSetViewerTablePanel = this.createDataSetViewerTablePanel(rows, this._columnDisplayDefinitions);
        this._contentPanel.add(new JScrollPane(this._dataSetViewerTablePanel.getComponent()));
        int width = Preferences.userRoot().getInt(PREF_KEY_ROWS_WINDOW_FRAME_WIDTH, 300);
        int height = Preferences.userRoot().getInt(PREF_KEY_ROWS_WINDOW_FRAME_HIGHT, 300);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                RowsWindowFrame.this.onWindowClosing();
            }
        });
        this.setSize(new Dimension(width, height));
        this.setVisible(true);
    }

    private void onWindowClosing() {
        Dimension size = this.getSize();
        Preferences.userRoot().putInt(PREF_KEY_ROWS_WINDOW_FRAME_WIDTH, size.width);
        Preferences.userRoot().putInt(PREF_KEY_ROWS_WINDOW_FRAME_HIGHT, size.height);
        Main.getApplication().getRowsWindowFrameRegistry().remove(this);
    }

    public void appendSelectedRows(List<Object[]> rows, ArrayList<ColumnDisplayDefinition> columnDisplayDefinitions) {
        HashMap<Integer, Integer> myIndexByOtherIndexMap = this.getMyIndexByOtherIndexMap(columnDisplayDefinitions);
        if (null == myIndexByOtherIndexMap) {
            throw new IllegalStateException("appendSelectedRows() should be called after columnsMatch() was called to check.");
        }
        for (Object[] row : rows) {
            Object[] myRow = new Object[row.length];
            for (int i = 0; i < row.length; ++i) {
                myRow[myIndexByOtherIndexMap.get((Object)Integer.valueOf((int)i)).intValue()] = row[i];
            }
            RowSelectionTableUtil.getActualTableModel(this._dataSetViewerTablePanel).addRow(myRow);
        }
        RowSelectionTableUtil.getActualTableModel(this._dataSetViewerTablePanel).allRowsAdded();
        DataSetViewerTable table = this._dataSetViewerTablePanel.getTable();
        table.invalidate();
        SwingUtilities.invokeLater(() -> this.scrollTableToBottom(table));
    }

    private void scrollTableToBottom(JTable table) {
        int rowCount = RowSelectionTableUtil.getActualTableModel(table).getRowCount();
        Rectangle cellRect = table.getCellRect(rowCount, 0, true);
        Rectangle visibleRect = table.getVisibleRect();
        cellRect.x = visibleRect.x;
        cellRect.height = 1;
        cellRect.width = 1;
        cellRect.y = 1000000;
        table.scrollRectToVisible(cellRect);
    }

    public void close() {
        this.onWindowClosing();
        this.setVisible(false);
        this.dispose();
    }

    public boolean columnsMatch(ArrayList<ColumnDisplayDefinition> otherCols) {
        return null != this.getMyIndexByOtherIndexMap(otherCols);
    }

    private HashMap<Integer, Integer> getMyIndexByOtherIndexMap(ArrayList<ColumnDisplayDefinition> otherCols) {
        if (this._columnDisplayDefinitions.size() != otherCols.size()) {
            return null;
        }
        HashMap<Integer, Integer> myIndexByOthersIndex = new HashMap<Integer, Integer>();
        ArrayList<ColumnDisplayDefinition> myColsBuf = new ArrayList<ColumnDisplayDefinition>(this._columnDisplayDefinitions);
        HashSet<Integer> usedIncicesOfMine = new HashSet<Integer>();
        for (int i = 0; i < otherCols.size(); ++i) {
            ColumnDisplayDefinition otherCol = otherCols.get(i);
            boolean found = false;
            for (int j = 0; j < myColsBuf.size(); ++j) {
                ColumnDisplayDefinition myCol = myColsBuf.get(j);
                if (!this.match(otherCol, myCol) || usedIncicesOfMine.contains(j)) continue;
                myIndexByOthersIndex.put(i, j);
                usedIncicesOfMine.add(j);
                found = true;
                break;
            }
            if (found) continue;
            myIndexByOthersIndex = null;
            break;
        }
        return myIndexByOthersIndex;
    }

    private boolean match(ColumnDisplayDefinition col1, ColumnDisplayDefinition col2) {
        return Utilities.equalsRespectNull(col1.getColumnName(), col2.getColumnName()) && col1.getSqlType() == col2.getSqlType();
    }

    public void setMyCounterId(int myCounterId) {
        this._myCounterId = myCounterId;
        this.setTitle(s_stringMgr.getString("RowsWindowFrame.title") + " / " + this._session.getTitle() + " / (" + this._myCounterId + ")");
    }

    private DataSetViewerTablePanel createDataSetViewerTablePanel(List<Object[]> allRows, List<ColumnDisplayDefinition> columnDisplayDefinitions) {
        try {
            SimpleDataSet ods = new SimpleDataSet(allRows, columnDisplayDefinitions.toArray(new ColumnDisplayDefinition[columnDisplayDefinitions.size()]));
            DataSetViewerTablePanel dsv = new DataSetViewerTablePanel();
            dsv.init(null, new DataModelImplementationDetails(this._session), this._session);
            dsv.show(ods);
            return dsv;
        }
        catch (DataSetException e) {
            throw new RuntimeException(e);
        }
    }

    public void markWindow(boolean b) {
        if (b) {
            this._contentPanel.setBorder(BorderFactory.createLineBorder(Color.red, 3));
        } else {
            this._contentPanel.setBorder(BorderFactory.createEmptyBorder());
        }
    }
}

