/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.sql;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import net.sourceforge.squirrel_sql.fw.datasetviewer.BlockMode;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetException;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DatabaseTypesDataSet;
import net.sourceforge.squirrel_sql.fw.datasetviewer.IDataSet;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ResultSetDataSet;
import net.sourceforge.squirrel_sql.fw.dialects.DialectFactory;
import net.sourceforge.squirrel_sql.fw.dialects.DialectType;
import net.sourceforge.squirrel_sql.fw.sql.DataTypeInfo;
import net.sourceforge.squirrel_sql.fw.sql.ForeignKeyColumnInfo;
import net.sourceforge.squirrel_sql.fw.sql.ForeignKeyInfo;
import net.sourceforge.squirrel_sql.fw.sql.IProcedureInfo;
import net.sourceforge.squirrel_sql.fw.sql.ISQLConnection;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.sql.ITableInfo;
import net.sourceforge.squirrel_sql.fw.sql.IUDTInfo;
import net.sourceforge.squirrel_sql.fw.sql.IndexInfo;
import net.sourceforge.squirrel_sql.fw.sql.JDBCTypeMapper;
import net.sourceforge.squirrel_sql.fw.sql.MetaDataDataSet;
import net.sourceforge.squirrel_sql.fw.sql.NetezzaSpecifics;
import net.sourceforge.squirrel_sql.fw.sql.NetezzaSynonym;
import net.sourceforge.squirrel_sql.fw.sql.PrimaryKeyInfo;
import net.sourceforge.squirrel_sql.fw.sql.ProcedureInfo;
import net.sourceforge.squirrel_sql.fw.sql.ProgressCallBack;
import net.sourceforge.squirrel_sql.fw.sql.ResultSetColumnReader;
import net.sourceforge.squirrel_sql.fw.sql.ResultSetReader;
import net.sourceforge.squirrel_sql.fw.sql.SQLUtilities;
import net.sourceforge.squirrel_sql.fw.sql.TableColumnInfo;
import net.sourceforge.squirrel_sql.fw.sql.TableInfo;
import net.sourceforge.squirrel_sql.fw.sql.UDTInfo;
import net.sourceforge.squirrel_sql.fw.sql.dbobj.BestRowIdentifier;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class SQLDatabaseMetaData
implements ISQLDatabaseMetaData {
    private static final ILogger s_log = LoggerController.createLogger(SQLDatabaseMetaData.class);
    private ISQLConnection _conn;
    private NetezzaSpecifics _netezzaSpecifics = null;
    private Map<String, Object> _cache = Collections.synchronizedMap(new HashMap());
    private boolean supportsSuperTables = true;

    protected SQLDatabaseMetaData(ISQLConnection conn) {
        if (conn == null) {
            throw new IllegalArgumentException("SQLDatabaseMetaData == null");
        }
        this._conn = conn;
    }

    @Override
    public synchronized String getUserName() throws SQLException {
        String key = "getUserName";
        String value = (String)this._cache.get("getUserName");
        if (value == null) {
            value = this.privateGetJDBCMetaData().getUserName();
            this._cache.put("getUserName", value);
        }
        return value;
    }

    @Override
    public synchronized String getDatabaseProductName() throws SQLException {
        String key = "getDatabaseProductName";
        String value = (String)this._cache.get("getDatabaseProductName");
        if (value == null) {
            value = this.privateGetJDBCMetaData().getDatabaseProductName();
            this._cache.put("getDatabaseProductName", value);
        }
        return value;
    }

    @Override
    public synchronized String getDatabaseProductVersion() throws SQLException {
        String key = "getDatabaseProductVersion";
        String value = (String)this._cache.get("getDatabaseProductVersion");
        if (value == null) {
            value = this.privateGetJDBCMetaData().getDatabaseProductVersion();
            this._cache.put("getDatabaseProductVersion", value);
        }
        return value;
    }

    @Override
    public synchronized int getDatabaseMajorVersion() throws SQLException {
        String key = "getDatabaseMajorVersion";
        Integer value = (Integer)this._cache.get("getDatabaseMajorVersion");
        if (value == null) {
            value = this.privateGetJDBCMetaData().getDatabaseMajorVersion();
            this._cache.put("getDatabaseMajorVersion", value);
        }
        return value;
    }

    @Override
    public synchronized String getDriverName() throws SQLException {
        String key = "getDriverName";
        String value = (String)this._cache.get("getDriverName");
        if (value == null) {
            value = this.privateGetJDBCMetaData().getDriverName();
            this._cache.put("getDriverName", value);
        }
        return value;
    }

    @Override
    public int getJDBCVersion() throws SQLException {
        String key = "getJDBCVersion";
        Integer value = (Integer)this._cache.get("getJDBCVersion");
        if (value == null) {
            DatabaseMetaData md = this.privateGetJDBCMetaData();
            int major = md.getJDBCMajorVersion();
            int minor = md.getJDBCMinorVersion();
            int vers = major * 100 + minor;
            value = vers;
            this._cache.put("getJDBCVersion", value);
        }
        return value;
    }

    @Override
    public synchronized String getIdentifierQuoteString() throws SQLException {
        String key = "getIdentifierQuoteString";
        String value = (String)this._cache.get("getIdentifierQuoteString");
        if (value == null) {
            value = this.privateGetJDBCMetaData().getIdentifierQuoteString();
            if (value == null) {
                value = "";
            }
            this._cache.put("getIdentifierQuoteString", value);
        }
        return value;
    }

    @Override
    public synchronized String getCascadeClause() throws SQLException {
        String key = "getCascadeClause";
        String value = (String)this._cache.get("getCascadeClause");
        if (value == null) {
            value = DialectFactory.isDB2(this) || DialectFactory.isOracle(this) ? "CASCADE" : "";
            this._cache.put("getCascadeClause", value);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized String[] getSchemas() throws SQLException {
        boolean hasGuest = false;
        boolean hasSysFun = false;
        boolean isMSSQLorSYBASE = DialectFactory.isSyBase(this) || DialectFactory.isMSSQLServer(this);
        boolean isDB2 = DialectFactory.isDB2(this);
        ArrayList<String> list = new ArrayList<String>();
        ResultSet rs = this.privateGetJDBCMetaData().getSchemas();
        try {
            if (rs != null) {
                DialectType dialectType = DialectFactory.getDialectType(this);
                ResultSetReader rdr = new ResultSetReader(rs, dialectType);
                Object[] row = null;
                while ((row = rdr.readRow(BlockMode.INDIFFERENT)) != null) {
                    if (isMSSQLorSYBASE && row[0].equals("guest")) {
                        hasGuest = true;
                    }
                    if (isDB2 && row[0].equals("SYSFUN")) {
                        hasSysFun = true;
                    }
                    list.add((String)row[0]);
                }
            }
        }
        finally {
            SQLUtilities.closeResultSet(rs);
        }
        if (isMSSQLorSYBASE && !hasGuest) {
            list.add("guest");
        }
        if (isDB2 && !hasSysFun) {
            list.add("SYSFUN");
        }
        return list.toArray(new String[list.size()]);
    }

    @Override
    public boolean supportsSchemas() throws SQLException {
        return this.supportsSchemasInDataManipulation() || this.supportsSchemasInTableDefinitions();
    }

    @Override
    public synchronized boolean supportsSchemasInDataManipulation() throws SQLException {
        String key = "supportsSchemasInDataManipulation";
        Boolean value = (Boolean)this._cache.get("supportsSchemasInDataManipulation");
        if (value != null) {
            return value;
        }
        try {
            value = this.privateGetJDBCMetaData().supportsSchemasInDataManipulation();
        }
        catch (SQLException ex) {
            boolean isSQLServer;
            boolean bl = isSQLServer = DialectFactory.isSyBase(this) || DialectFactory.isMSSQLServer(this);
            if (isSQLServer) {
                value = Boolean.TRUE;
                this._cache.put("supportsSchemasInDataManipulation", value);
            }
            throw ex;
        }
        this._cache.put("supportsSchemasInDataManipulation", value);
        return value;
    }

    @Override
    public synchronized boolean supportsSchemasInTableDefinitions() throws SQLException {
        String key = "supportsSchemasInTableDefinitions";
        Boolean value = (Boolean)this._cache.get("supportsSchemasInTableDefinitions");
        if (value != null) {
            return value;
        }
        try {
            value = this.privateGetJDBCMetaData().supportsSchemasInTableDefinitions();
        }
        catch (SQLException ex) {
            boolean isSQLServer;
            boolean bl = isSQLServer = DialectFactory.isSyBase(this) || DialectFactory.isMSSQLServer(this);
            if (isSQLServer) {
                value = Boolean.TRUE;
                this._cache.put("supportsSchemasInTableDefinitions", value);
            }
            throw ex;
        }
        this._cache.put("supportsSchemasInTableDefinitions", value);
        return value;
    }

    @Override
    public synchronized boolean supportsStoredProcedures() throws SQLException {
        String key = "supportsStoredProcedures";
        Boolean value = (Boolean)this._cache.get("supportsStoredProcedures");
        if (value != null) {
            return value;
        }
        value = DialectFactory.isPostgreSQL(this) ? Boolean.TRUE : (DialectFactory.isNetezza(this) ? Boolean.TRUE : Boolean.valueOf(this.privateGetJDBCMetaData().supportsStoredProcedures()));
        this._cache.put("supportsStoredProcedures", value);
        return value;
    }

    @Override
    public synchronized boolean supportsSavepoints() throws SQLException {
        String key = "supportsSavepoints";
        Boolean value = (Boolean)this._cache.get("supportsSavepoints");
        if (value != null) {
            return value;
        }
        value = this.privateGetJDBCMetaData().supportsSavepoints();
        this._cache.put("supportsSavepoints", value);
        return value;
    }

    @Override
    public synchronized boolean supportsResultSetType(int type) throws SQLException {
        String key = "supportsResultSetType";
        Boolean value = (Boolean)this._cache.get("supportsResultSetType");
        if (value != null) {
            return value;
        }
        value = this.privateGetJDBCMetaData().supportsResultSetType(type);
        this._cache.put("supportsResultSetType", value);
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized String[] getCatalogs() throws SQLException {
        ArrayList<String> list = new ArrayList<String>();
        ResultSet rs = this.privateGetJDBCMetaData().getCatalogs();
        try {
            if (rs != null) {
                DialectType dialectType = DialectFactory.getDialectType(this);
                ResultSetReader rdr = new ResultSetReader(rs, dialectType);
                Object[] row = null;
                while ((row = rdr.readRow(BlockMode.INDIFFERENT)) != null) {
                    if (row == null || row[0] == null) continue;
                    list.add(row[0].toString());
                }
            }
        }
        finally {
            SQLUtilities.closeResultSet(rs);
        }
        return list.toArray(new String[list.size()]);
    }

    @Override
    public synchronized String getURL() throws SQLException {
        String key = "getURL";
        String value = (String)this._cache.get("getURL");
        if (value != null) {
            return value;
        }
        value = this.privateGetJDBCMetaData().getURL();
        this._cache.put("getURL", value);
        return value;
    }

    @Override
    public synchronized String getCatalogTerm() throws SQLException {
        String key = "getCatalogTerm";
        String value = (String)this._cache.get("getCatalogTerm");
        if (value != null) {
            return value;
        }
        value = this.privateGetJDBCMetaData().getCatalogTerm();
        this._cache.put("getCatalogTerm", value);
        return value;
    }

    @Override
    public synchronized String getSchemaTerm() throws SQLException {
        String key = "getSchemaTerm";
        String value = (String)this._cache.get("getSchemaTerm");
        if (value != null) {
            return value;
        }
        value = this.privateGetJDBCMetaData().getSchemaTerm();
        this._cache.put("getSchemaTerm", value);
        return value;
    }

    @Override
    public synchronized String getProcedureTerm() throws SQLException {
        String key = "getProcedureTerm";
        String value = (String)this._cache.get("getProcedureTerm");
        if (value != null) {
            return value;
        }
        value = this.privateGetJDBCMetaData().getProcedureTerm();
        this._cache.put("getProcedureTerm", value);
        return value;
    }

    @Override
    public synchronized String getCatalogSeparator() throws SQLException {
        String key = "getCatalogSeparator";
        String value = (String)this._cache.get("getCatalogSeparator");
        if (value != null) {
            return value;
        }
        value = this.privateGetJDBCMetaData().getCatalogSeparator();
        this._cache.put("getCatalogSeparator", value);
        return value;
    }

    @Override
    public boolean supportsCatalogs() throws SQLException {
        return this.supportsCatalogsInTableDefinitions() || this.supportsCatalogsInDataManipulation() || this.supportsCatalogsInProcedureCalls();
    }

    @Override
    public synchronized boolean supportsCatalogsInTableDefinitions() throws SQLException {
        String key = "supportsCatalogsInTableDefinitions";
        Boolean value = (Boolean)this._cache.get("supportsCatalogsInTableDefinitions");
        if (value != null) {
            return value;
        }
        try {
            value = this.privateGetJDBCMetaData().supportsCatalogsInTableDefinitions();
        }
        catch (SQLException ex) {
            boolean isSQLServer;
            boolean bl = isSQLServer = DialectFactory.isSyBase(this) || DialectFactory.isMSSQLServer(this);
            if (isSQLServer) {
                value = Boolean.TRUE;
                this._cache.put("supportsCatalogsInTableDefinitions", value);
            }
            throw ex;
        }
        this._cache.put("supportsCatalogsInTableDefinitions", value);
        return value;
    }

    @Override
    public synchronized boolean supportsCatalogsInDataManipulation() throws SQLException {
        String key = "supportsCatalogsInDataManipulation";
        Boolean value = (Boolean)this._cache.get("supportsCatalogsInDataManipulation");
        if (value != null) {
            return value;
        }
        try {
            value = this.privateGetJDBCMetaData().supportsCatalogsInDataManipulation();
        }
        catch (SQLException ex) {
            boolean isSQLServer;
            boolean bl = isSQLServer = DialectFactory.isSyBase(this) || DialectFactory.isMSSQLServer(this);
            if (isSQLServer) {
                value = Boolean.TRUE;
                this._cache.put("supportsCatalogsInDataManipulation", value);
            }
            throw ex;
        }
        if (DialectFactory.isNetezza(this)) {
            value = true;
        }
        this._cache.put("supportsCatalogsInDataManipulation", value);
        return value;
    }

    @Override
    public synchronized boolean supportsCatalogsInProcedureCalls() throws SQLException {
        String key = "supportsCatalogsInProcedureCalls";
        Boolean value = (Boolean)this._cache.get("supportsCatalogsInProcedureCalls");
        if (value != null) {
            return value;
        }
        try {
            value = this.privateGetJDBCMetaData().supportsCatalogsInProcedureCalls();
        }
        catch (SQLException ex) {
            boolean isSQLServer;
            boolean bl = isSQLServer = DialectFactory.isSyBase(this) || DialectFactory.isMSSQLServer(this);
            if (isSQLServer) {
                value = Boolean.TRUE;
                this._cache.put("supportsCatalogsInProcedureCalls", value);
            }
            throw ex;
        }
        this._cache.put("supportsCatalogsInProcedureCalls", value);
        return value;
    }

    @Override
    public synchronized DatabaseMetaData getJDBCMetaData() throws SQLException {
        return this.privateGetJDBCMetaData();
    }

    @Override
    public synchronized IDataSet getMetaDataSet() throws SQLException {
        return new MetaDataDataSet(this.privateGetJDBCMetaData());
    }

    public ResultSet getTypeInfo() throws SQLException {
        return this.privateGetJDBCMetaData().getTypeInfo();
    }

    @Override
    public synchronized IDataSet getTypesDataSet() throws DataSetException {
        ResultSet rs = null;
        try {
            rs = this.privateGetJDBCMetaData().getTypeInfo();
            DatabaseTypesDataSet databaseTypesDataSet = new DatabaseTypesDataSet(rs);
            return databaseTypesDataSet;
        }
        catch (SQLException e) {
            throw new DataSetException(e);
        }
        finally {
            SQLUtilities.closeResultSet(rs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized DataTypeInfo[] getDataTypes() throws SQLException {
        DatabaseMetaData md = this.privateGetJDBCMetaData();
        ArrayList<DataTypeInfo> list = new ArrayList<DataTypeInfo>();
        ResultSet rs = md.getTypeInfo();
        try {
            ResultSetColumnReader rdr = new ResultSetColumnReader(rs);
            while (rdr.next()) {
                String typeName = rdr.getString(1);
                int dataType = rdr.getLong(2).intValue();
                int precis = rdr.getLong(3).intValue();
                String literalPrefix = rdr.getString(4);
                String literalSuffix = rdr.getString(5);
                String createParams = rdr.getString(6);
                int nullable = rdr.getLong(7).intValue();
                boolean caseSens = rdr.getBoolean(8);
                int searchable = rdr.getLong(9).intValue();
                boolean unsigned = rdr.getBoolean(10);
                boolean canBeMoney = rdr.getBoolean(11);
                boolean canBeAutoInc = rdr.getBoolean(12);
                String localTypeName = rdr.getString(13);
                int min = rdr.getLong(14).intValue();
                int max = rdr.getLong(15).intValue();
                int radix = rdr.getLong(18).intValue();
                list.add(new DataTypeInfo(typeName, dataType, precis, literalPrefix, literalSuffix, createParams, nullable, caseSens, searchable, unsigned, canBeMoney, canBeAutoInc, localTypeName, min, max, radix, this));
            }
        }
        finally {
            SQLUtilities.closeResultSet(rs);
        }
        return list.toArray(new DataTypeInfo[list.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized IProcedureInfo[] getProcedures(String catalog, String schemaPattern, String procedureNamePattern, ProgressCallBack progressCallBack) throws SQLException {
        DatabaseMetaData md = this.privateGetJDBCMetaData();
        ArrayList<ProcedureInfo> list = new ArrayList<ProcedureInfo>();
        ResultSet rs = md.getProcedures(catalog, schemaPattern, procedureNamePattern);
        if (rs != null) {
            int count = 0;
            try {
                int[] cols = new int[]{1, 2, 3, 7, 8};
                DialectType dialectType = DialectFactory.getDialectType(this);
                ResultSetReader rdr = new ResultSetReader(rs, cols, dialectType);
                Object[] row = null;
                while ((row = rdr.readRow(BlockMode.INDIFFERENT)) != null) {
                    if (row[4] == null || !(row[4] instanceof Number)) {
                        if (row[4] != null) {
                            s_log.warn("Error reading procedure meta data for column 8 (PROCEDURE_TYPE): According to the API of java.sql.DatabaseMetaData.getProcedures(...) the type should be int but is " + row[4].getClass().getName() + " with value " + row[4]);
                        }
                        row[4] = 0;
                    }
                    int type = ((Number)row[4]).intValue();
                    ProcedureInfo pi = new ProcedureInfo(this.getAsString(row[0]), this.getAsString(row[1]), this.getAsString(row[2]), this.getAsString(row[3]), type, this);
                    list.add(pi);
                    if (null == progressCallBack || 0 != count++ % 200) continue;
                    progressCallBack.currentlyLoading(pi.getSimpleName());
                }
            }
            finally {
                SQLUtilities.closeResultSet(rs);
            }
        }
        return list.toArray(new IProcedureInfo[list.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized String[] getTableTypes() throws SQLException {
        String key = "getTableTypes";
        String[] value = (String[])this._cache.get("getTableTypes");
        if (value != null) {
            return value;
        }
        DatabaseMetaData md = this.privateGetJDBCMetaData();
        TreeSet<String> tableTypes = new TreeSet<String>();
        ResultSet rs = md.getTableTypes();
        if (rs != null) {
            try {
                while (rs.next()) {
                    tableTypes.add(rs.getString(1).trim());
                }
            }
            finally {
                SQLUtilities.closeResultSet(rs);
            }
        }
        String dbProductName = this.getDatabaseProductName();
        int nbrTableTypes = tableTypes.size();
        if (nbrTableTypes == 1 && dbProductName.equals("InstantDB")) {
            tableTypes.clear();
            tableTypes.add("TABLE");
            tableTypes.add("SYSTEM TABLE");
        } else if (dbProductName.equals("PostgreSQL")) {
            if (nbrTableTypes == 0 || nbrTableTypes == 1) {
                if (s_log.isDebugEnabled()) {
                    s_log.debug("Detected PostgreSQL and " + nbrTableTypes + " table types - overriding to 4 table types");
                }
                tableTypes.clear();
                tableTypes.add("TABLE");
                tableTypes.add("SYSTEM TABLE");
                tableTypes.add("VIEW");
                tableTypes.add("SYSTEM VIEW");
            }
            if (tableTypes.contains("INDEX")) {
                tableTypes.remove("INDEX");
            }
            if (tableTypes.contains("SEQUENCE")) {
                tableTypes.remove("SEQUENCE");
            }
            if (tableTypes.contains("SYSTEM INDEX")) {
                tableTypes.remove("SYSTEM INDEX");
            }
        } else if (DialectFactory.getDialectType(this) == DialectType.INFORMIX) {
            if (nbrTableTypes == 0) {
                if (s_log.isDebugEnabled()) {
                    s_log.debug("Detected Informix with no table types returned.  Defaulting to TABLE | SYSTEM TABLE | VIEW");
                }
                tableTypes.add("TABLE");
                tableTypes.add("SYSTEM TABLE");
                tableTypes.add("VIEW");
            }
        } else if (DialectFactory.getDialectType(this) == DialectType.NETEZZA) {
            tableTypes.clear();
            tableTypes.add("SYSTEM TABLE");
            tableTypes.add("TABLE");
            tableTypes.add("VIEW");
            tableTypes.add("SYNONYM");
        }
        value = tableTypes.toArray(new String[tableTypes.size()]);
        this._cache.put("getTableTypes", value);
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized ITableInfo[] getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types, ProgressCallBack progressCallBack) throws SQLException {
        String[] catalogs;
        DatabaseMetaData md = this.privateGetJDBCMetaData();
        String dbDriverName = this.getDriverName();
        TreeSet<ITableInfo> list = new TreeSet<ITableInfo>();
        if (dbDriverName.equals("InternetCDS Type 4 JDBC driver for MS SQLServer") && schemaPattern == null) {
            schemaPattern = "dbo";
        }
        if (dbDriverName.equals("AS/400 Toolbox for Java JDBC Driver") && schemaPattern == null) {
            schemaPattern = "*ALLUSR";
        }
        if (catalog == null && DriverMatch.isComHttxDriver(this._conn) && (catalogs = this.getCatalogs()) != null) {
            for (int i = 0; i < catalogs.length; ++i) {
                ITableInfo[] tables = this.getTables(catalogs[i], schemaPattern, tableNamePattern, types, progressCallBack);
                for (int j = 0; j < tables.length; ++j) {
                    list.add(tables[j]);
                }
            }
            return list.toArray(new ITableInfo[list.size()]);
        }
        HashMap<String, TableInfo> nameMap = null;
        ResultSet superTabResult = null;
        ResultSet tabResult = null;
        try {
            TableInfo tabInfo;
            if (this.supportsSuperTables) {
                try {
                    superTabResult = md.getSuperTables(catalog, schemaPattern, tableNamePattern);
                    if (superTabResult != null && superTabResult.next()) {
                        nameMap = new HashMap<String, TableInfo>();
                    }
                }
                catch (Throwable th) {
                    s_log.debug("DBMS/Driver doesn't support getSupertables(): " + th.getMessage());
                    this.supportsSuperTables = false;
                }
            }
            try {
                tabResult = md.getTables(catalog, schemaPattern, tableNamePattern, types);
            }
            catch (SQLException e) {
                if (null != tableNamePattern) {
                    throw e;
                }
                s_log.warn("DatabaseMetaData.getTables(...) threw an error when called with tableNamePattern = null. Trying tableNamePattern %. The error was: " + e);
                tabResult = md.getTables(catalog, schemaPattern, "%", types);
            }
            int count = 0;
            while (tabResult != null && tabResult.next()) {
                String tblRemark;
                try {
                    tblRemark = tabResult.getString(5);
                }
                catch (Throwable th) {
                    s_log.debug("Failed to retrieve REMARKS of a table: " + th.getMessage());
                    tblRemark = th.toString();
                }
                tabInfo = new TableInfo(tabResult.getString(1), tabResult.getString(2), tabResult.getString(3), tabResult.getString(4), tblRemark, this);
                if (nameMap != null) {
                    nameMap.put(tabInfo.getSimpleName(), tabInfo);
                }
                list.add(tabInfo);
                if (null == progressCallBack || 0 != count++ % 100) continue;
                progressCallBack.currentlyLoading(tabInfo.getSimpleName());
            }
            if (nameMap != null) {
                do {
                    TableInfo superInfo;
                    String superTabName;
                    String tabName;
                    if ((tabInfo = (TableInfo)nameMap.get(tabName = superTabResult.getString(3))) == null || (superTabName = superTabResult.getString(4)) == null || (superInfo = (TableInfo)nameMap.get(superTabName)) == null) continue;
                    superInfo.addChild(tabInfo);
                    list.remove(tabInfo);
                    if (null == progressCallBack || 0 != count++ % 20) continue;
                    progressCallBack.currentlyLoading(tabInfo.getSimpleName());
                } while (superTabResult.next());
            }
        }
        catch (Throwable throwable) {
            SQLUtilities.closeResultSet(tabResult);
            SQLUtilities.closeResultSet(superTabResult);
            throw throwable;
        }
        SQLUtilities.closeResultSet(tabResult);
        SQLUtilities.closeResultSet(superTabResult);
        return list.toArray(new ITableInfo[list.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized IUDTInfo[] getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types, ProgressCallBack progressCallBack) throws SQLException {
        DatabaseMetaData md = this.privateGetJDBCMetaData();
        ArrayList<UDTInfo> list = new ArrayList<UDTInfo>();
        this.checkForInformix(catalog);
        ResultSet rs = md.getUDTs(catalog, schemaPattern, typeNamePattern, types);
        try {
            int[] cols = new int[]{1, 2, 3, 4, 5, 6};
            DialectType dialectType = DialectFactory.getDialectType(this);
            ResultSetReader rdr = new ResultSetReader(rs, cols, dialectType);
            Object[] row = null;
            int count = 0;
            while ((row = rdr.readRow(BlockMode.INDIFFERENT)) != null) {
                UDTInfo udtInfo = new UDTInfo(this.getAsString(row[0]), this.getAsString(row[1]), this.getAsString(row[2]), this.getAsString(row[3]), this.getAsString(row[4]), this.getAsString(row[5]), this);
                list.add(udtInfo);
                if (null == progressCallBack || 0 != count++ % 200) continue;
                progressCallBack.currentlyLoading(udtInfo.getSimpleName());
            }
        }
        finally {
            SQLUtilities.closeResultSet(rs);
        }
        return list.toArray(new IUDTInfo[list.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkForInformix(String catalogName) {
        if (DialectFactory.getDialectType(this) != DialectType.INFORMIX) {
            return;
        }
        Statement stmt = null;
        try {
            stmt = this._conn.createStatement();
            stmt.execute("Drop procedure mode_decode");
        }
        catch (SQLException e) {
            s_log.info("setInformixCatalog: unable to drop procedure mode_decode: " + e.getMessage(), e);
        }
        finally {
            SQLUtilities.closeStatement(stmt);
        }
    }

    private String getAsString(Object val) {
        if (null == val) {
            return null;
        }
        if (val instanceof String) {
            return (String)val;
        }
        return "" + val;
    }

    @Override
    public synchronized String[] getNumericFunctions() throws SQLException {
        String key = "getNumericFunctions";
        String[] value = (String[])this._cache.get("getNumericFunctions");
        if (value != null) {
            return value;
        }
        value = SQLDatabaseMetaData.makeArray(this.privateGetJDBCMetaData().getNumericFunctions());
        this._cache.put("getNumericFunctions", value);
        return value;
    }

    @Override
    public synchronized String[] getStringFunctions() throws SQLException {
        String key = "getStringFunctions";
        String[] value = (String[])this._cache.get("getStringFunctions");
        if (value != null) {
            return value;
        }
        value = SQLDatabaseMetaData.makeArray(this.privateGetJDBCMetaData().getStringFunctions());
        this._cache.put("getStringFunctions", value);
        return value;
    }

    @Override
    public synchronized String[] getSystemFunctions() throws SQLException {
        String key = "getSystemFunctions";
        String[] value = (String[])this._cache.get("getSystemFunctions");
        if (value != null) {
            return value;
        }
        value = SQLDatabaseMetaData.makeArray(this.privateGetJDBCMetaData().getSystemFunctions());
        this._cache.put("getSystemFunctions", value);
        return value;
    }

    @Override
    public synchronized String[] getTimeDateFunctions() throws SQLException {
        String key = "getTimeDateFunctions";
        String[] value = (String[])this._cache.get("getTimeDateFunctions");
        if (value != null) {
            return value;
        }
        value = SQLDatabaseMetaData.makeArray(this.privateGetJDBCMetaData().getTimeDateFunctions());
        this._cache.put("getTimeDateFunctions", value);
        return value;
    }

    @Override
    public synchronized String[] getSQLKeywords() throws SQLException {
        String key = "getSQLKeywords";
        String[] value = (String[])this._cache.get("getSQLKeywords");
        if (value != null) {
            return value;
        }
        value = SQLDatabaseMetaData.makeArray(this.privateGetJDBCMetaData().getSQLKeywords());
        this._cache.put("getSQLKeywords", value);
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized BestRowIdentifier[] getBestRowIdentifier(ITableInfo ti) throws SQLException {
        ArrayList<BestRowIdentifier> results = new ArrayList<BestRowIdentifier>();
        ResultSet rs = null;
        try {
            boolean columnsCanBeNullable = true;
            rs = this.privateGetJDBCMetaData().getBestRowIdentifier(ti.getCatalogName(), ti.getSchemaName(), ti.getSimpleName(), 1, columnsCanBeNullable);
            String catalog = ti.getCatalogName();
            String schema = ti.getSchemaName();
            String table = ti.getSimpleName();
            ResultSetColumnReader rdr = new ResultSetColumnReader(rs);
            while (rdr.next()) {
                BestRowIdentifier rid = new BestRowIdentifier(catalog, schema, table, rdr.getLong(1).intValue(), rdr.getString(2), rdr.getLong(3).shortValue(), rdr.getString(4), rdr.getLong(5).intValue(), rdr.getLong(7).shortValue(), rdr.getLong(8).shortValue(), this);
                results.add(rid);
            }
        }
        catch (Throwable throwable) {
            SQLUtilities.closeResultSet(rs);
            throw throwable;
        }
        SQLUtilities.closeResultSet(rs);
        BestRowIdentifier[] ar = new BestRowIdentifier[results.size()];
        return results.toArray(ar);
    }

    public ResultSet getColumnPrivileges(ITableInfo ti) throws SQLException {
        String columns = DialectFactory.isMySQL(this) ? "%" : null;
        return this.privateGetJDBCMetaData().getColumnPrivileges(ti.getCatalogName(), ti.getSchemaName(), ti.getSimpleName(), columns);
    }

    @Override
    public synchronized IDataSet getColumnPrivilegesDataSet(ITableInfo ti, int[] columnIndices, boolean computeWidths) throws DataSetException {
        ResultSetDataSet resultSetDataSet;
        ResultSet rs = null;
        try {
            DatabaseMetaData md = this.privateGetJDBCMetaData();
            String columns = DialectFactory.isMySQL(this) ? "%" : null;
            rs = md.getColumnPrivileges(ti.getCatalogName(), ti.getSchemaName(), ti.getSimpleName(), columns);
            ResultSetDataSet rsds = new ResultSetDataSet();
            rsds.setResultSet(rs, columnIndices, computeWidths, DialectFactory.getDialectType(this));
            resultSetDataSet = rsds;
        }
        catch (SQLException e) {
            try {
                throw new DataSetException(e);
            }
            catch (Throwable throwable) {
                SQLUtilities.closeResultSet(rs);
                throw throwable;
            }
        }
        SQLUtilities.closeResultSet(rs);
        return resultSetDataSet;
    }

    public ResultSet getExportedKeys(ITableInfo ti) throws SQLException {
        return this.privateGetJDBCMetaData().getExportedKeys(ti.getCatalogName(), ti.getSchemaName(), ti.getSimpleName());
    }

    @Override
    public synchronized IDataSet getExportedKeysDataSet(ITableInfo ti) throws DataSetException {
        ResultSetDataSet resultSetDataSet;
        ResultSet rs = null;
        try {
            rs = this.privateGetJDBCMetaData().getExportedKeys(ti.getCatalogName(), ti.getSchemaName(), ti.getSimpleName());
            ResultSetDataSet rsds = new ResultSetDataSet();
            rsds.setResultSet(rs, null, true, DialectFactory.getDialectType(this));
            resultSetDataSet = rsds;
        }
        catch (SQLException e) {
            try {
                throw new DataSetException(e);
            }
            catch (Throwable throwable) {
                SQLUtilities.closeResultSet(rs);
                throw throwable;
            }
        }
        SQLUtilities.closeResultSet(rs);
        return resultSetDataSet;
    }

    public ResultSet getImportedKeys(ITableInfo ti) throws SQLException {
        return this.privateGetJDBCMetaData().getImportedKeys(ti.getCatalogName(), ti.getSchemaName(), ti.getSimpleName());
    }

    @Override
    public synchronized ForeignKeyInfo[] getImportedKeysInfo(String catalog, String schema, String tableName) throws SQLException {
        ResultSet rs = this.privateGetJDBCMetaData().getImportedKeys(catalog, schema, tableName);
        return this.getForeignKeyInfo(rs);
    }

    @Override
    public synchronized ForeignKeyInfo[] getImportedKeysInfo(ITableInfo ti) throws SQLException {
        return this.getForeignKeyInfo(this.privateGetJDBCMetaData().getImportedKeys(ti.getCatalogName(), ti.getSchemaName(), ti.getSimpleName()));
    }

    @Override
    public synchronized IDataSet getImportedKeysDataSet(ITableInfo ti) throws DataSetException {
        ResultSetDataSet resultSetDataSet;
        ResultSet rs = null;
        try {
            rs = this.privateGetJDBCMetaData().getImportedKeys(ti.getCatalogName(), ti.getSchemaName(), ti.getSimpleName());
            ResultSetDataSet rsds = new ResultSetDataSet();
            rsds.setResultSet(rs, null, true, DialectFactory.getDialectType(this));
            resultSetDataSet = rsds;
        }
        catch (SQLException e) {
            try {
                throw new DataSetException(e);
            }
            catch (Throwable throwable) {
                SQLUtilities.closeResultSet(rs);
                throw throwable;
            }
        }
        SQLUtilities.closeResultSet(rs);
        return resultSetDataSet;
    }

    @Override
    public synchronized ForeignKeyInfo[] getExportedKeysInfo(String catalog, String schema, String tableName) throws SQLException {
        ResultSet rs = this.privateGetJDBCMetaData().getExportedKeys(catalog, schema, tableName);
        return this.getForeignKeyInfo(rs);
    }

    @Override
    public synchronized ForeignKeyInfo[] getExportedKeysInfo(ITableInfo ti) throws SQLException {
        return this.getForeignKeyInfo(this.privateGetJDBCMetaData().getExportedKeys(ti.getCatalogName(), ti.getSchemaName(), ti.getSimpleName()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ForeignKeyInfo[] getForeignKeyInfo(ResultSet rs) throws SQLException {
        HashMap<String, ForeignKeyInfo> keys = new HashMap<String, ForeignKeyInfo>();
        HashMap columns = new HashMap();
        try {
            ResultSetColumnReader rdr = new ResultSetColumnReader(rs);
            while (rdr.next()) {
                ForeignKeyInfo fki = new ForeignKeyInfo(rdr.getString(1), rdr.getString(2), rdr.getString(3), rdr.getString(4), rdr.getString(5), rdr.getString(6), rdr.getString(7), rdr.getString(8), rdr.getLong(10).intValue(), rdr.getLong(11).intValue(), rdr.getString(12), rdr.getString(13), rdr.getLong(14).intValue(), null, this);
                String key = this.createForeignKeyInfoKey(fki);
                if (!keys.containsKey(key)) {
                    keys.put(key, fki);
                    columns.put(key, new ArrayList());
                }
                ForeignKeyColumnInfo fkiCol = new ForeignKeyColumnInfo(rdr.getString(8), rdr.getString(4), rdr.getLong(9).intValue());
                ((ArrayList)columns.get(key)).add(fkiCol);
            }
        }
        finally {
            SQLUtilities.closeResultSet(rs);
        }
        ForeignKeyInfo[] results = new ForeignKeyInfo[keys.size()];
        Iterator it = keys.values().iterator();
        int idx = 0;
        while (it.hasNext()) {
            ForeignKeyInfo fki = (ForeignKeyInfo)it.next();
            String key = this.createForeignKeyInfoKey(fki);
            List colsList = (List)columns.get(key);
            ForeignKeyColumnInfo[] fkiCol = colsList.toArray(new ForeignKeyColumnInfo[colsList.size()]);
            fki.setForeignKeyColumnInfo(fkiCol);
            results[idx++] = fki;
        }
        return results;
    }

    @Override
    public synchronized ResultSetDataSet getIndexInfo(ITableInfo ti, int[] columnIndices, boolean computeWidths) throws DataSetException {
        ResultSetDataSet resultSetDataSet;
        ResultSet rs = null;
        try {
            rs = this.privateGetJDBCMetaData().getIndexInfo(ti.getCatalogName(), ti.getSchemaName(), ti.getSimpleName(), false, true);
            ResultSetDataSet rsds = new ResultSetDataSet();
            rsds.setResultSet(rs, columnIndices, computeWidths, DialectFactory.getDialectType(this));
            resultSetDataSet = rsds;
        }
        catch (SQLException e) {
            try {
                throw new DataSetException(e);
            }
            catch (Throwable throwable) {
                SQLUtilities.closeResultSet(rs);
                throw throwable;
            }
        }
        SQLUtilities.closeResultSet(rs);
        return resultSetDataSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public List<IndexInfo> getIndexInfo(ITableInfo ti) throws SQLException {
        ArrayList<IndexInfo> result = new ArrayList<IndexInfo>();
        ResultSet rs = null;
        try {
            rs = this.privateGetJDBCMetaData().getIndexInfo(ti.getCatalogName(), ti.getSchemaName(), ti.getSimpleName(), false, true);
            while (rs.next()) {
                String catalog = rs.getString(1);
                String schema = rs.getString(2);
                String table = rs.getString(3);
                boolean nonunique = rs.getBoolean(4);
                String indexQualifier = rs.getString(5);
                String indexName = rs.getString(6);
                IndexInfo.IndexType indexType = JDBCTypeMapper.getIndexType(rs.getShort(7));
                short ordinalPosition = rs.getShort(8);
                String column = rs.getString(9);
                IndexInfo.SortOrder sortOrder = JDBCTypeMapper.getIndexSortOrder(rs.getString(10));
                int cardinality = rs.getInt(11);
                int pages = rs.getInt(12);
                String filterCondition = rs.getString(13);
                IndexInfo indexInfo = new IndexInfo(catalog, schema, indexName, table, column, nonunique, indexQualifier, indexType, ordinalPosition, sortOrder, cardinality, pages, filterCondition, this);
                result.add(indexInfo);
            }
        }
        catch (SQLException sQLException) {
            SQLUtilities.closeResultSet(rs);
            catch (Throwable throwable) {
                SQLUtilities.closeResultSet(rs);
                throw throwable;
            }
        }
        SQLUtilities.closeResultSet(rs);
        return result;
    }

    public ResultSet getPrimaryKeys(ITableInfo ti) throws SQLException {
        return this.privateGetJDBCMetaData().getPrimaryKeys(ti.getCatalogName(), ti.getSchemaName(), ti.getSimpleName());
    }

    @Override
    public synchronized IDataSet getPrimaryKey(ITableInfo ti, int[] columnIndices, boolean computeWidths) throws DataSetException {
        ResultSetDataSet resultSetDataSet;
        ResultSet rs = null;
        try {
            rs = this.privateGetJDBCMetaData().getPrimaryKeys(ti.getCatalogName(), ti.getSchemaName(), ti.getSimpleName());
            ResultSetDataSet rsds = new ResultSetDataSet();
            rsds.setResultSet(rs, columnIndices, computeWidths, DialectFactory.getDialectType(this));
            resultSetDataSet = rsds;
        }
        catch (SQLException e) {
            try {
                throw new DataSetException(e);
            }
            catch (Throwable throwable) {
                SQLUtilities.closeResultSet(rs);
                throw throwable;
            }
        }
        SQLUtilities.closeResultSet(rs);
        return resultSetDataSet;
    }

    @Override
    public synchronized PrimaryKeyInfo[] getPrimaryKey(ITableInfo ti) throws SQLException {
        return this.getPrimaryKey(ti.getCatalogName(), ti.getSchemaName(), ti.getSimpleName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized PrimaryKeyInfo[] getPrimaryKey(String catalog, String schema, String table) throws SQLException {
        ArrayList<PrimaryKeyInfo> results = new ArrayList<PrimaryKeyInfo>();
        ResultSet rs = null;
        try {
            rs = this.privateGetJDBCMetaData().getPrimaryKeys(catalog, schema, table);
            while (rs.next()) {
                PrimaryKeyInfo pkInfo = new PrimaryKeyInfo(rs.getString(1), rs.getString(2), rs.getString(3), rs.getString(4), rs.getShort(5), rs.getString(6), this);
                results.add(pkInfo);
            }
        }
        catch (Throwable throwable) {
            SQLUtilities.closeResultSet(rs);
            throw throwable;
        }
        SQLUtilities.closeResultSet(rs);
        PrimaryKeyInfo[] ar = new PrimaryKeyInfo[results.size()];
        return results.toArray(ar);
    }

    public ResultSet getProcedureColumns(IProcedureInfo ti) throws SQLException {
        return this.privateGetJDBCMetaData().getProcedureColumns(ti.getCatalogName(), ti.getSchemaName(), ti.getSimpleName(), "%");
    }

    @Override
    public synchronized IDataSet getProcedureColumnsDataSet(IProcedureInfo ti) throws DataSetException {
        ResultSetDataSet resultSetDataSet;
        ResultSet rs = null;
        try {
            DatabaseMetaData md = this.privateGetJDBCMetaData();
            rs = md.getProcedureColumns(ti.getCatalogName(), ti.getSchemaName(), ti.getSimpleName(), "%");
            ResultSetDataSet rsds = new ResultSetDataSet();
            rsds.setResultSet(rs, DialectFactory.getDialectType(this));
            resultSetDataSet = rsds;
        }
        catch (SQLException e) {
            try {
                throw new DataSetException(e);
            }
            catch (Throwable throwable) {
                SQLUtilities.closeResultSet(rs);
                throw throwable;
            }
        }
        SQLUtilities.closeResultSet(rs);
        return resultSetDataSet;
    }

    public ResultSet getTablePrivileges(ITableInfo ti) throws SQLException {
        return this.privateGetJDBCMetaData().getTablePrivileges(ti.getCatalogName(), ti.getSchemaName(), ti.getSimpleName());
    }

    @Override
    public synchronized IDataSet getTablePrivilegesDataSet(ITableInfo ti, int[] columnIndices, boolean computeWidths) throws DataSetException {
        ResultSetDataSet resultSetDataSet;
        ResultSet rs = null;
        try {
            DatabaseMetaData md = this.privateGetJDBCMetaData();
            rs = md.getTablePrivileges(ti.getCatalogName(), ti.getSchemaName(), ti.getSimpleName());
            ResultSetDataSet rsds = new ResultSetDataSet();
            rsds.setResultSet(rs, columnIndices, computeWidths, DialectFactory.getDialectType(this));
            resultSetDataSet = rsds;
        }
        catch (SQLException e) {
            try {
                throw new DataSetException(e);
            }
            catch (Throwable throwable) {
                SQLUtilities.closeResultSet(rs);
                throw throwable;
            }
        }
        SQLUtilities.closeResultSet(rs);
        return resultSetDataSet;
    }

    public ResultSet getVersionColumns(ITableInfo ti) throws SQLException {
        return this.privateGetJDBCMetaData().getVersionColumns(ti.getCatalogName(), ti.getSchemaName(), ti.getSimpleName());
    }

    @Override
    public synchronized IDataSet getVersionColumnsDataSet(ITableInfo ti) throws DataSetException {
        ResultSetDataSet resultSetDataSet;
        ResultSet rs = null;
        try {
            DatabaseMetaData md = this.privateGetJDBCMetaData();
            rs = md.getVersionColumns(ti.getCatalogName(), ti.getSchemaName(), ti.getSimpleName());
            ResultSetDataSet rsds = new ResultSetDataSet();
            rsds.setResultSet(rs, DialectFactory.getDialectType(this));
            resultSetDataSet = rsds;
        }
        catch (SQLException e) {
            try {
                throw new DataSetException(e);
            }
            catch (Throwable throwable) {
                SQLUtilities.closeResultSet(rs);
                throw throwable;
            }
        }
        SQLUtilities.closeResultSet(rs);
        return resultSetDataSet;
    }

    private ResultSet getColumns(ITableInfo ti) throws SQLException {
        String catalog = ti.getCatalogName();
        String schema = ti.getSchemaName();
        String table = this.escapeTableNames(ti.getSimpleName());
        if (DialectFactory.isNetezza(this)) {
            NetezzaSynonym synonym;
            if (this._netezzaSpecifics == null) {
                this._netezzaSpecifics = new NetezzaSpecifics(this);
            }
            if ((synonym = this._netezzaSpecifics.returnSynonym(catalog, schema, table)) != null) {
                catalog = synonym.getCatalog();
                schema = synonym.getSchema();
                table = synonym.getTable();
            }
        }
        return this.privateGetJDBCMetaData().getColumns(catalog, schema, table, "%");
    }

    @Override
    public synchronized IDataSet getColumns(ITableInfo ti, int[] columnIndices, boolean computeWidths) throws DataSetException {
        ResultSetDataSet result = null;
        ResultSet rs = null;
        try {
            rs = this.getColumns(ti);
            ResultSetDataSet rsds = new ResultSetDataSet();
            rsds.setResultSet(rs, columnIndices, computeWidths, DialectFactory.getDialectType(this));
            result = rsds;
        }
        catch (SQLException e) {
            throw new DataSetException(e);
        }
        finally {
            SQLUtilities.closeResultSet(rs);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized TableColumnInfo[] getColumnInfo(String catalog, String schema, String table) throws SQLException {
        TableColumnInfo[] tableColumnInfoArray;
        ResultSet rs = null;
        table = this.escapeTableNames(table);
        try {
            TreeMap<Integer, TableColumnInfo> columns = new TreeMap<Integer, TableColumnInfo>();
            DatabaseMetaData md = this.privateGetJDBCMetaData();
            if (DialectFactory.isNetezza(this)) {
                NetezzaSynonym synonym;
                if (this._netezzaSpecifics == null) {
                    this._netezzaSpecifics = new NetezzaSpecifics(this);
                }
                if ((synonym = this._netezzaSpecifics.returnSynonym(catalog, schema, table)) != null) {
                    catalog = synonym.getCatalog();
                    schema = synonym.getSchema();
                    table = synonym.getTable();
                }
            }
            rs = md.getColumns(catalog, schema, table, "%");
            ResultSetColumnReader rdr = new ResultSetColumnReader(rs);
            int isNullAllowed = 2;
            int index = 0;
            while (rdr.next()) {
                isNullAllowed = DialectFactory.isPointbase(this) ? (rdr.getBoolean(11).booleanValue() ? 1 : 0) : rdr.getLong(11).intValue();
                TableColumnInfo tci = new TableColumnInfo(rdr.getString(1), rdr.getString(2), rdr.getString(3), rdr.getString(4), rdr.getLong(5).intValue(), rdr.getString(6), rdr.getLong(7).intValue(), rdr.getLong(9).intValue(), rdr.getLong(10).intValue(), isNullAllowed, rdr.getString(12), rdr.getString(13), rdr.getLong(16).intValue(), rdr.getLong(17).intValue(), rdr.getString(18), this);
                columns.put(10000 * tci.getOrdinalPosition() + ++index, tci);
            }
            tableColumnInfoArray = columns.values().toArray(new TableColumnInfo[columns.size()]);
        }
        catch (Throwable throwable) {
            SQLUtilities.closeResultSet(rs);
            throw throwable;
        }
        SQLUtilities.closeResultSet(rs);
        return tableColumnInfoArray;
    }

    private String escapeTableNames(String table) {
        if (DialectFactory.isOracle(this) && table != null && table.startsWith("BIN$")) {
            table = table.replaceAll("/", "//");
        }
        return table;
    }

    @Override
    public synchronized TableColumnInfo[] getColumnInfo(ITableInfo ti) throws SQLException {
        return this.getColumnInfo(ti.getCatalogName(), ti.getSchemaName(), ti.getSimpleName());
    }

    @Override
    public boolean correctlySupportsSetMaxRows() throws SQLException {
        return !"i-net OPTA 2000".equals(this.getDriverName());
    }

    @Override
    public synchronized boolean supportsMultipleResultSets() throws SQLException {
        String key = "supportsMultipleResultSets";
        Boolean value = (Boolean)this._cache.get("supportsMultipleResultSets");
        if (value != null) {
            return value;
        }
        value = this.privateGetJDBCMetaData().supportsMultipleResultSets();
        this._cache.put("supportsMultipleResultSets", value);
        return value;
    }

    @Override
    public synchronized boolean storesUpperCaseIdentifiers() throws SQLException {
        String key = "storesUpperCaseIdentifiers";
        Boolean value = (Boolean)this._cache.get("storesUpperCaseIdentifiers");
        if (value != null) {
            return value;
        }
        value = this.privateGetJDBCMetaData().storesUpperCaseIdentifiers();
        this._cache.put("storesUpperCaseIdentifiers", value);
        return value;
    }

    @Override
    public void clearCache() {
        this._cache.clear();
    }

    @Override
    public String getOptionalPseudoColumnForDataSelection(ITableInfo ti) {
        return null;
    }

    private static String[] makeArray(String data) {
        if (data == null) {
            data = "";
        }
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(data, ",");
        while (st.hasMoreTokens()) {
            list.add(st.nextToken());
        }
        Collections.sort(list);
        return list.toArray(new String[list.size()]);
    }

    private DatabaseMetaData privateGetJDBCMetaData() throws SQLException {
        this.checkThread();
        return this._conn.getConnection().getMetaData();
    }

    private String createForeignKeyInfoKey(ForeignKeyInfo fki) {
        StringBuffer buf = new StringBuffer();
        buf.append(fki.getForeignKeyCatalogName()).append(fki.getForeignKeySchemaName()).append(fki.getForeignKeyTableName()).append(fki.getForeignKeyName()).append(fki.getPrimaryKeyCatalogName()).append(fki.getPrimaryKeySchemaName()).append(fki.getPrimaryKeyTableName()).append(fki.getPrimaryKeyName());
        return buf.toString();
    }

    private void checkThread() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String[] getDataTypesSimpleNames() throws SQLException {
        DatabaseMetaData md = this.privateGetJDBCMetaData();
        ArrayList<String> list = new ArrayList<String>();
        ResultSet rs = md.getTypeInfo();
        try {
            ResultSetColumnReader rdr = new ResultSetColumnReader(rs);
            while (rdr.next()) {
                String typeName = rdr.getString(1);
                list.add(typeName);
            }
        }
        finally {
            SQLUtilities.closeResultSet(rs);
        }
        return list.toArray(new String[list.size()]);
    }

    public static class DriverMatch {
        private static final String COM_HTTX_DRIVER_PREFIX = "com.hxtt.sql.";

        public static boolean isComHttxDriver(ISQLConnection con) {
            if (null == con) {
                return false;
            }
            return con.getSQLDriver().getDriverClassName().startsWith(COM_HTTX_DRIVER_PREFIX);
        }
    }

    private static interface IDriverNames {
        public static final String AS400 = "AS/400 Toolbox for Java JDBC Driver";
        public static final String FREE_TDS = "InternetCDS Type 4 JDBC driver for MS SQLServer";
        public static final String OPTA2000 = "i-net OPTA 2000";
    }
}

