/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.record;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.poi.hslf.record.RecordAtom;
import org.apache.poi.hslf.record.RecordTypes;
import org.apache.poi.util.HexDump;
import org.apache.poi.util.LittleEndian;
import org.apache.poi.util.StringUtil;

public final class TextBytesAtom
extends RecordAtom {
    public static final long _type = RecordTypes.TextBytesAtom.typeID;
    private byte[] _header;
    private byte[] _text;

    public String getText() {
        return StringUtil.getFromCompressedUnicode((byte[])this._text, (int)0, (int)this._text.length);
    }

    public void setText(byte[] b) {
        this._text = (byte[])b.clone();
        LittleEndian.putInt((byte[])this._header, (int)4, (int)this._text.length);
    }

    protected TextBytesAtom(byte[] source, int start, int len) {
        if (len < 8) {
            len = 8;
        }
        this._header = new byte[8];
        System.arraycopy(source, start, this._header, 0, 8);
        this._text = new byte[len - 8];
        System.arraycopy(source, start + 8, this._text, 0, len - 8);
    }

    public TextBytesAtom() {
        this._header = new byte[8];
        LittleEndian.putUShort((byte[])this._header, (int)0, (int)0);
        LittleEndian.putUShort((byte[])this._header, (int)2, (int)((int)_type));
        LittleEndian.putInt((byte[])this._header, (int)4, (int)0);
        this._text = new byte[0];
    }

    @Override
    public long getRecordType() {
        return _type;
    }

    @Override
    public void writeOut(OutputStream out) throws IOException {
        out.write(this._header);
        out.write(this._text);
    }

    public String toString() {
        StringBuffer out = new StringBuffer();
        out.append("TextBytesAtom:\n");
        out.append(HexDump.dump((byte[])this._text, (long)0L, (int)0));
        return out.toString();
    }
}

