/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqlbuilder.views.graph.editparts;

import java.util.Iterator;
import java.util.List;
import org.eclipse.datatools.modelbase.sql.query.Predicate;
import org.eclipse.datatools.modelbase.sql.query.PredicateBasic;
import org.eclipse.datatools.modelbase.sql.query.QuerySearchCondition;
import org.eclipse.datatools.modelbase.sql.query.QuerySelect;
import org.eclipse.datatools.modelbase.sql.query.QuerySelectStatement;
import org.eclipse.datatools.modelbase.sql.query.QueryValueExpression;
import org.eclipse.datatools.modelbase.sql.query.SQLQueryObject;
import org.eclipse.datatools.modelbase.sql.query.TableExpression;
import org.eclipse.datatools.modelbase.sql.query.TableJoined;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionColumn;
import org.eclipse.datatools.modelbase.sql.query.helper.JoinHelper;
import org.eclipse.datatools.sqltools.sqlbuilder.model.ExpressionHelper;
import org.eclipse.datatools.sqltools.sqlbuilder.model.SearchConditionHelper;
import org.eclipse.datatools.sqltools.sqlbuilder.model.SelectHelper;
import org.eclipse.datatools.sqltools.sqlbuilder.views.graph.editparts.ColumnEditPart;
import org.eclipse.datatools.sqltools.sqlbuilder.views.graph.editparts.ISQLEditPart;
import org.eclipse.datatools.sqltools.sqlbuilder.views.graph.editparts.SQLRootEditPart;
import org.eclipse.datatools.sqltools.sqlbuilder.views.graph.figures.FlatEndConnectionRouter;
import org.eclipse.datatools.sqltools.sqlbuilder.views.graph.figures.TableConnection;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.common.util.EList;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.editparts.AbstractConnectionEditPart;
import org.eclipse.gef.editpolicies.ConnectionEndpointEditPolicy;
import org.eclipse.gef.requests.ReconnectRequest;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Display;

public class JoinEditPart
extends AbstractConnectionEditPart
implements ISQLEditPart {
    SQLQueryObject joinSource;
    PredicateBasic sqlPredicate;
    static final Font tooltipFont = Display.getCurrent().getSystemFont();

    public JoinEditPart(PredicateBasic predicate, SQLQueryObject sqlJoinsource) {
        this.setModel(predicate);
        this.sqlPredicate = predicate;
        this.joinSource = sqlJoinsource;
    }

    public PredicateBasic getSQLPredicate() {
        return this.sqlPredicate;
    }

    public TableExpression getSourceTable() {
        TableExpression tableExpr = null;
        QueryValueExpression expr = this.sqlPredicate.getLeftValueExpr();
        if (expr instanceof ValueExpressionColumn) {
            tableExpr = ExpressionHelper.getTableExprForValueExpressionColumn((ValueExpressionColumn)expr);
        }
        return tableExpr;
    }

    public TableExpression getTargetTable() {
        TableExpression tableExpr = null;
        QueryValueExpression expr = this.sqlPredicate.getRightValueExpr();
        if (expr instanceof ValueExpressionColumn) {
            tableExpr = ExpressionHelper.getTableExprForValueExpressionColumn((ValueExpressionColumn)expr);
        }
        return tableExpr;
    }

    public ValueExpressionColumn getSourceColumn() {
        ValueExpressionColumn col = null;
        QueryValueExpression expr = this.sqlPredicate.getLeftValueExpr();
        if (expr instanceof ValueExpressionColumn) {
            col = (ValueExpressionColumn)expr;
        }
        return col;
    }

    public ValueExpressionColumn getTargetColumn() {
        ValueExpressionColumn col = null;
        QueryValueExpression expr = this.sqlPredicate.getRightValueExpr();
        if (expr instanceof ValueExpressionColumn) {
            col = (ValueExpressionColumn)expr;
        }
        return col;
    }

    protected IFigure createFigure() {
        return new TableConnection();
    }

    protected void refreshVisuals() {
        TableConnection connection = (TableConnection)this.getFigure();
        if (this.joinSource instanceof TableJoined) {
            connection.setJoinType(((TableJoined)this.joinSource).getJoinOperator().getValue());
        } else {
            connection.setJoinType(0);
        }
    }

    protected void createEditPolicies() {
        this.installEditPolicy("reconnect", (EditPolicy)new ConnectionEndpointEditPolicy(){
            protected IFigure fTargetFeedback;

            protected Connection createDummyConnection(ReconnectRequest request) {
                ColumnEditPart columnPart;
                String toolTip;
                TableConnection conn = new TableConnection();
                conn.setConnectionRouter(new FlatEndConnectionRouter());
                ConnectionEditPart connEditPart = request.getConnectionEditPart();
                EditPart stationaryPart = null;
                if (request.getType() == "connection start") {
                    stationaryPart = connEditPart.getTarget();
                } else if (request.getType() == "connection end") {
                    stationaryPart = connEditPart.getSource();
                }
                if (stationaryPart instanceof ColumnEditPart && !(toolTip = (columnPart = (ColumnEditPart)stationaryPart).getToolTip()).equals("")) {
                    this.fTargetFeedback = this.createToolTip(columnPart.getLabel().getBounds().getExpanded(0, 0).getBottomLeft().translate(0, 2), toolTip);
                }
                return conn;
            }

            protected void eraseConnectionMoveFeedback(ReconnectRequest request) {
                if (this.fTargetFeedback != null) {
                    this.removeFeedback(this.fTargetFeedback);
                    this.fTargetFeedback = null;
                }
                super.eraseConnectionMoveFeedback(request);
            }

            private Figure createToolTip(Point location, String toolTipText) {
                Label toolTipFigure = new Label(toolTipText);
                toolTipFigure.setFont(tooltipFont);
                toolTipFigure.setBorder((Border)new LineBorder());
                toolTipFigure.setSize(toolTipFigure.getPreferredSize().getExpanded(2, 2));
                toolTipFigure.setLocation(location);
                toolTipFigure.setForegroundColor(ColorConstants.tooltipForeground);
                toolTipFigure.setBackgroundColor(ColorConstants.tooltipBackground);
                toolTipFigure.setOpaque(true);
                this.addFeedback((IFigure)toolTipFigure);
                return toolTipFigure;
            }
        });
    }

    public SQLQueryObject getSQLJoin() {
        return this.joinSource;
    }

    @Override
    public SQLQueryObject getStatement() {
        return (SQLQueryObject)this.getMyRoot().getModel();
    }

    public EditPart getMyRoot() {
        RootEditPart root = this.getRoot();
        Iterator iter = root.getChildren().iterator();
        EditPart part = null;
        while (iter.hasNext() && !(part instanceof SQLRootEditPart)) {
            part = (EditPart)iter.next();
        }
        return part;
    }

    public void removeJoin() {
        SQLQueryObject obj = this.getStatement();
        QuerySelect querySelect = null;
        EList fromClauseList = null;
        if (obj instanceof QuerySelectStatement) {
            QuerySelectStatement selectStmt = (QuerySelectStatement)obj;
            querySelect = SelectHelper.getQuerySelect(selectStmt);
            fromClauseList = querySelect.getFromClause();
        } else if (obj instanceof QuerySelect) {
            querySelect = (QuerySelect)obj;
            fromClauseList = ((QuerySelect)obj).getFromClause();
        }
        if (this.joinSource instanceof TableJoined) {
            JoinHelper.removeJoinCondition((List)fromClauseList, (TableJoined)((TableJoined)this.joinSource), (PredicateBasic)this.sqlPredicate);
        } else if (this.joinSource instanceof QuerySearchCondition) {
            QuerySearchCondition newCondition = SearchConditionHelper.removePredicateFromCondition((Predicate)this.sqlPredicate, (QuerySearchCondition)this.joinSource);
            if (querySelect != null) {
                querySelect.setWhereClause(newCondition);
            }
        }
        SelectHelper.refresh(obj);
    }
}

