/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.ui.common;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jst.ws.internal.common.J2EEUtils;
import org.eclipse.jst.ws.internal.common.ResourceUtils;
import org.eclipse.jst.ws.internal.consumption.ui.common.IWebServiceOSGISupportExtension;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public class DefaultingUtils {
    private static final Map<String, IWebServiceOSGISupportExtension> osgiExtensions;
    private static final String EXTENSION_POINT_WS_OSGI_SUPPORT = "webServiceOSGISupport";
    private static final String OSGI_SUPPORT_ELEMENT = "webServiceOSGISupport";
    private static final String OSGI_SUPPORT_CLASS_ATTR = "class";
    private static final String OSGI_SUPPORT_TEMPLATES_ATTR = "applicableTemplates";

    static {
        HashMap<String, IWebServiceOSGISupportExtension> result = new HashMap<String, IWebServiceOSGISupportExtension>();
        try {
            IExtensionRegistry reg = Platform.getExtensionRegistry();
            IConfigurationElement[] wsImplExts = reg.getConfigurationElementsFor("org.eclipse.jst.ws.consumption.ui", "webServiceOSGISupport");
            int idx = 0;
            while (idx < wsImplExts.length) {
                IConfigurationElement elem = wsImplExts[idx];
                if (elem.getName().equals("webServiceOSGISupport")) {
                    try {
                        IWebServiceOSGISupportExtension provider;
                        String applicableTemplatesStr = elem.getAttribute(OSGI_SUPPORT_TEMPLATES_ATTR);
                        if (applicableTemplatesStr != null && (provider = (IWebServiceOSGISupportExtension)elem.createExecutableExtension(OSGI_SUPPORT_CLASS_ATTR)) != null) {
                            String[] templates;
                            String[] stringArray = templates = applicableTemplatesStr.split("\\s+");
                            int n = templates.length;
                            int n2 = 0;
                            while (n2 < n) {
                                String template = stringArray[n2];
                                result.put(template.toLowerCase(), provider);
                                ++n2;
                            }
                        }
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                }
                ++idx;
            }
        }
        finally {
            osgiExtensions = Collections.unmodifiableMap(result);
        }
    }

    public static String getDefaultEARProjectName(String projectName) {
        if (projectName != null && projectName.length() > 0) {
            String baseEARName;
            if (DefaultingUtils.isOSGIProject(projectName)) {
                return DefaultingUtils.getDefaultOSGIAppProjectName(projectName);
            }
            IProject proj = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            if (proj.exists()) {
                IVirtualComponent[] ears = J2EEUtils.getReferencingEARComponents((IProject)proj);
                if (ears != null && ears.length > 0) {
                    return ears[0].getName();
                }
                IVirtualComponent[] allEarComps = J2EEUtils.getAllEARComponents();
                if (allEarComps.length > 0) {
                    int i = 0;
                    while (i < allEarComps.length) {
                        IProject earProject = allEarComps[i].getProject();
                        boolean canAssociate = J2EEUtils.canAssociateProjectToEARWithoutWarning((IProject)proj, (IProject)earProject);
                        if (canAssociate) {
                            return allEarComps[i].getName();
                        }
                        ++i;
                    }
                }
            }
            String earName = baseEARName = String.valueOf(projectName) + ResourceUtils.getDefaultEARExtension();
            boolean foundEAR = false;
            int i = 1;
            while (!foundEAR) {
                IStatus canCreateEARStatus = J2EEUtils.canCreateEAR((IProject)ProjectUtilities.getProject((String)earName));
                if (canCreateEARStatus.isOK()) {
                    foundEAR = true;
                    continue;
                }
                earName = String.valueOf(baseEARName) + i;
                ++i;
            }
            return earName;
        }
        return ResourceUtils.getDefaultServiceEARProjectName();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isOSGITemplate(String name) {
        if (name == null) {
            return false;
        }
        try {
            String template;
            if (osgiExtensions == null) {
                return false;
            }
            Iterator<String> iterator = osgiExtensions.keySet().iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while (!name.equalsIgnoreCase((template = iterator.next()).trim()));
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    private static IProject utilFindProjectWithName(String proj) {
        if (proj == null) {
            return null;
        }
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject(proj);
        return project;
    }

    public static boolean isOSGIProject(String proj) {
        IProject project;
        block3: {
            try {
                project = DefaultingUtils.utilFindProjectWithName(proj);
                if (project != null) break block3;
                return false;
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
        return DefaultingUtils.isSupportedOSGIProject(project);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isSupportedOSGIProject(IProject project) {
        try {
            Map.Entry<String, IWebServiceOSGISupportExtension> entry;
            if (osgiExtensions == null || project == null) {
                return false;
            }
            Iterator<Map.Entry<String, IWebServiceOSGISupportExtension>> iterator = osgiExtensions.entrySet().iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while (!(entry = iterator.next()).getValue().isSupportedOSGIProject(project));
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private static IWebServiceOSGISupportExtension getFirstSupportedExtension(String projectName) {
        IProject proj = DefaultingUtils.utilFindProjectWithName(projectName);
        if (proj == null) {
            return null;
        }
        for (Map.Entry<String, IWebServiceOSGISupportExtension> entry : osgiExtensions.entrySet()) {
            if (!entry.getValue().isSupportedOSGIProject(proj)) continue;
            return entry.getValue();
        }
        return null;
    }

    public static String getDefaultOSGIAppProjectName(String projectName) {
        block4: {
            if (osgiExtensions != null && projectName != null) break block4;
            return null;
        }
        try {
            IWebServiceOSGISupportExtension ext = DefaultingUtils.getFirstSupportedExtension(projectName);
            if (ext != null) {
                return ext.getDefaultOSGIAppProjectName(projectName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return String.valueOf(projectName) + ".app";
    }
}

