/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.search;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.api.tools.internal.builder.Reference;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IComponentDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IElementDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IMemberDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IReferenceTypeDescriptor;
import org.eclipse.pde.api.tools.internal.search.IReferenceDescriptor;
import org.eclipse.pde.api.tools.internal.search.SearchMessages;
import org.eclipse.pde.api.tools.internal.search.UseReportConverter;
import org.eclipse.pde.api.tools.internal.search.UseScanParser;
import org.eclipse.pde.api.tools.internal.search.UseScanVisitor;
import org.eclipse.pde.api.tools.internal.util.Signatures;

public class ConsumerReportConvertor
extends UseReportConverter {
    public ConsumerReportConvertor(String htmlroot, String xmlroot, String[] topatterns, String[] frompatterns) {
        super(htmlroot, xmlroot, topatterns, frompatterns);
    }

    @Override
    protected List<?> parse(IProgressMonitor monitor) throws Exception {
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)20);
        ListConsumersVisitor listVisitor = new ListConsumersVisitor();
        UseScanParser lparser = new UseScanParser();
        lparser.parse(this.getXmlLocation(), (IProgressMonitor)subMon.split(5), listVisitor);
        ArrayList<Consumer> consumerReports = new ArrayList<Consumer>();
        ConsumerReportVisitor visitor = null;
        for (IComponentDescriptor consumer : listVisitor.consumers) {
            visitor = new ConsumerReportVisitor(consumer);
            lparser.parse(this.getXmlLocation(), null, visitor);
            if (visitor.consumer.counts.getTotalRefCount() <= 0) continue;
            consumerReports.add(visitor.consumer);
        }
        return consumerReports;
    }

    protected String getConsumerTitle(String bundle) {
        return NLS.bind((String)SearchMessages.ConsumerReportConvertor_ConsumerTitle, (Object)bundle);
    }

    protected String getProducerTitle(String consumer, String producer) {
        return NLS.bind((String)SearchMessages.ConsumerReportConvertor_ProducerTitle, (Object)consumer, (Object)producer);
    }

    @Override
    protected String getIndexTitle() {
        return SearchMessages.ConsumerReportConvertor_IndexTitle;
    }

    @Override
    protected void writeIndexPage(List<?> scanResult) throws Exception {
        Collections.sort(scanResult, (o1, o2) -> ((Consumer)o1).name.compareTo(((Consumer)o2).name));
        try (PrintWriter writer = null;){
            try {
                File reportIndex = new File(this.getHtmlLocation(), "index.html");
                if (!reportIndex.exists()) {
                    reportIndex.createNewFile();
                }
                this.setReportIndex(reportIndex);
                StringBuffer buffer = new StringBuffer();
                buffer.append("<!doctype HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">\n");
                buffer.append(OPEN_HTML).append("<head>\n").append("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\">\n");
                this.writeMetadataHeaders(buffer);
                buffer.append("<title>").append(this.getIndexTitle()).append("</title>\n");
                buffer.append("</head>\n");
                buffer.append("<body>\n");
                buffer.append("<h3>").append(this.getIndexTitle()).append("</h3>\n");
                try {
                    this.getMetadata();
                    this.writeMetadataSummary(buffer);
                    this.getFilteredCount();
                    this.writeFilterCount(buffer);
                }
                catch (Exception exception) {}
                buffer.append("<h4>").append(SearchMessages.UseReportConvertor_additional_infos_section).append("</h4>\n");
                if (this.hasMissing()) {
                    buffer.append("<p>");
                    buffer.append(NLS.bind((String)SearchMessages.UseReportConverter_missing_bundles_prevented_scan, (Object[])new String[]{" <a href=\"./missing.html\">", "</a>"}));
                    buffer.append("</p>\n");
                }
                buffer.append("<p>");
                buffer.append(NLS.bind((String)SearchMessages.UseReportConverter_bundles_that_were_not_searched, (Object[])new String[]{"<a href=\"./not_searched.html\">", "</a></p>\n"}));
                String additional = this.getAdditionalIndexInfo(scanResult.size() > 0);
                if (additional != null) {
                    buffer.append(additional);
                }
                if (scanResult.size() > 0) {
                    buffer.append("<p>").append(SearchMessages.UseReportConverter_inlined_description).append("</p>\n");
                    buffer.append(this.getColourLegend());
                    buffer.append(this.getReferencesTableHeader(SearchMessages.ConsumerReportConvertor_ProducerListHeader, SearchMessages.UseReportConverter_bundle, true));
                    if (scanResult.size() > 0) {
                        File refereehtml = null;
                        String link = null;
                        for (Object obj : scanResult) {
                            if (!(obj instanceof Consumer)) continue;
                            Consumer consumer = (Consumer)obj;
                            refereehtml = new File(this.getReportsRoot(), String.valueOf(consumer.name) + File.separator + "index.html");
                            link = this.extractLinkFrom(this.getReportsRoot(), refereehtml.getAbsolutePath());
                            buffer.append(this.getReferenceTableEntry(consumer.counts, link, consumer.name, true));
                        }
                        buffer.append("</table>\n");
                    }
                } else {
                    buffer.append(this.getNoReportsInformation());
                }
                buffer.append("<p>\n\t<a href=\"http://validator.w3.org/check?uri=referer\">\n<img src=\"http://www.w3.org/Icons/valid-html401-blue\" alt=\"Valid HTML 4.01 Transitional\" height=\"31\" width=\"88\"></a>\n</p>\n");
                buffer.append("</body>\n").append("</html>\n");
                writer = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(reportIndex), "UTF-8"));
                writer.print(buffer.toString());
                writer.flush();
            }
            catch (IOException iOException) {
                throw new Exception(NLS.bind((String)SearchMessages.ioexception_writing_html_file, (Object)this.getReportIndex().getAbsolutePath()));
            }
        }
    }

    protected void writeConsumerReport(Consumer consumer, Map<String, Producer> producers) throws Exception {
        File originhtml = null;
        try (PrintWriter writer = null;){
            try {
                File htmlroot = new File(this.getHtmlLocation(), consumer.name);
                if (!htmlroot.exists()) {
                    htmlroot.mkdirs();
                }
                if (!(originhtml = new File(htmlroot, "index.html")).exists()) {
                    originhtml.createNewFile();
                }
                StringBuffer buffer = new StringBuffer();
                buffer.append("<!doctype HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">\n");
                buffer.append(OPEN_HTML).append("<head>\n").append("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\">\n");
                buffer.append(REF_STYLE);
                buffer.append(REF_SCRIPT);
                buffer.append("<title>").append(this.getConsumerTitle(consumer.name)).append("</title>\n");
                buffer.append("</head>\n");
                buffer.append("<body>\n");
                buffer.append("<h3>").append(this.getConsumerTitle(consumer.name)).append("</h3>\n");
                ArrayList<String> producerNames = new ArrayList<String>();
                producerNames.addAll(producers.keySet());
                Collections.sort(producerNames, compare);
                buffer.append(this.getReferencesTableHeader(SearchMessages.ConsumerReportConvertor_ConsumerListHeader, SearchMessages.UseReportConverter_bundle, true));
                Producer producer = null;
                File refereehtml = null;
                String link = null;
                for (String string : producerNames) {
                    producer = producers.get(string);
                    if (producer == null) continue;
                    refereehtml = new File(this.getReportsRoot(), String.valueOf(producer.name) + File.separator + "index.html");
                    link = this.extractLinkFrom(this.getReportsRoot(), refereehtml.getAbsolutePath());
                    buffer.append(this.getReferenceTableEntry(producer.counts, link, producer.name, true));
                }
                buffer.append("</table>\n");
                buffer.append("<br>");
                buffer.append("<p>").append("<a href=\"../index.html\">").append(SearchMessages.UseReportConverter_back_to_bundle_index).append("</a>\n").append("</p>\n");
                buffer.append("<p>\n\t<a href=\"http://validator.w3.org/check?uri=referer\">\n<img src=\"http://www.w3.org/Icons/valid-html401-blue\" alt=\"Valid HTML 4.01 Transitional\" height=\"31\" width=\"88\"></a>\n</p>\n");
                writer = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(originhtml), "UTF-8"));
                writer.println(buffer.toString());
                writer.flush();
            }
            catch (IOException ioe) {
                throw new Exception(NLS.bind((String)SearchMessages.ioexception_writing_html_file, (Object)originhtml.getAbsolutePath()), ioe);
            }
        }
    }

    protected void writeProducerReport(Consumer parentConsumer, Producer producer) throws Exception {
        File originhtml = null;
        try (PrintWriter writer = null;){
            try {
                File htmlroot = new Path(this.getHtmlLocation()).append(parentConsumer.name).append(producer.name).toFile();
                if (!htmlroot.exists()) {
                    htmlroot.mkdirs();
                }
                if (!(originhtml = new File(htmlroot, "index.html")).exists()) {
                    originhtml.createNewFile();
                }
                StringBuffer buffer = new StringBuffer();
                buffer.append("<!doctype HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">\n");
                buffer.append(OPEN_HTML).append("<head>\n").append("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\">\n");
                buffer.append(REF_STYLE);
                buffer.append(REF_SCRIPT);
                buffer.append("<title>").append(this.getProducerTitle(parentConsumer.name, producer.name)).append("</title>\n");
                buffer.append("</head>\n");
                buffer.append("<body>\n");
                buffer.append("<h3>").append(this.getProducerTitle(parentConsumer.name, producer.name)).append("</h3>\n");
                String additional = this.getAdditionalReferencedTypeInformation();
                if (additional != null) {
                    buffer.append(additional);
                }
                buffer.append(this.getReferencesTableHeader(SearchMessages.ConsumerReportConvertor_TypeListHeader, SearchMessages.UseReportConverter_referenced_type, false));
                ArrayList<IReferenceTypeDescriptor> producerTypes = new ArrayList<IReferenceTypeDescriptor>();
                producerTypes.addAll(producer.types.keySet());
                Collections.sort(producerTypes, compare);
                UseReportConverter.CountGroup counts = null;
                String link = null;
                File typefile = null;
                Type2 type = null;
                for (IReferenceTypeDescriptor iReferenceTypeDescriptor : producerTypes) {
                    type = producer.types.get(iReferenceTypeDescriptor);
                    counts = type.counts;
                    String fqname = Signatures.getQualifiedTypeSignature((IReferenceTypeDescriptor)type.desc);
                    typefile = new File(htmlroot, String.valueOf(fqname) + ".html");
                    if (!typefile.exists()) {
                        typefile.createNewFile();
                    }
                    link = this.extractLinkFrom(htmlroot, typefile.getAbsolutePath());
                    buffer.append(this.getReferenceTableEntry(counts, link, fqname, false));
                    this.writeTypePage(type.referencingMembers, type, typefile, fqname);
                }
                buffer.append("</table>\n");
                buffer.append("<br>");
                buffer.append("<p>").append("<a href=\"../index.html\">").append(NLS.bind((String)SearchMessages.ConsumerReportConvertor_BackLinkToConsumer, (Object)parentConsumer.name)).append("</a>\n").append("</p>\n");
                buffer.append("<p>\n\t<a href=\"http://validator.w3.org/check?uri=referer\">\n<img src=\"http://www.w3.org/Icons/valid-html401-blue\" alt=\"Valid HTML 4.01 Transitional\" height=\"31\" width=\"88\"></a>\n</p>\n");
                writer = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(originhtml), "UTF-8"));
                writer.println(buffer.toString());
                writer.flush();
            }
            catch (IOException iOException) {
                throw new Exception(NLS.bind((String)SearchMessages.ioexception_writing_html_file, (Object)originhtml.getAbsolutePath()));
            }
        }
    }

    class Consumer {
        String name;
        UseReportConverter.CountGroup counts = new UseReportConverter.CountGroup();

        Consumer() {
        }
    }

    class ConsumerReportVisitor
    extends UseScanVisitor {
        Consumer consumer;
        Map<String, Producer> producers = new HashMap<String, Producer>();
        private IComponentDescriptor consumerDescriptor;
        private Producer currentProducer;
        private Type2 currenttype = null;
        private UseReportConverter.Member currentmember = null;
        HashMap<IReferenceTypeDescriptor, Type2> keys = new HashMap();

        public ConsumerReportVisitor(IComponentDescriptor consumerDescriptor) {
            this.consumerDescriptor = consumerDescriptor;
            this.consumer = new Consumer();
            this.consumer.name = ConsumerReportConvertor.this.composeName(consumerDescriptor.getId(), consumerDescriptor.getVersion());
        }

        @Override
        public void endVisitScan() {
            try {
                long start = 0L;
                if (ApiPlugin.DEBUG_USE_REPORT_CONVERTER) {
                    System.out.println("Writing consumer report for bundle: " + this.consumer.name);
                    start = System.currentTimeMillis();
                }
                if (this.consumer.counts.getTotalRefCount() > 0) {
                    ConsumerReportConvertor.this.writeConsumerReport(this.consumer, this.producers);
                    this.producers.clear();
                }
                if (ApiPlugin.DEBUG_USE_REPORT_CONVERTER) {
                    System.out.println("Done in: " + (System.currentTimeMillis() - start) + " ms");
                }
            }
            catch (Exception e) {
                ApiPlugin.log(e);
            }
        }

        @Override
        public boolean visitComponent(IComponentDescriptor target) {
            this.currentProducer = new Producer();
            this.currentProducer.name = ConsumerReportConvertor.this.composeName(target.getId(), target.getVersion());
            return true;
        }

        @Override
        public void endVisitComponent(IComponentDescriptor target) {
            if (this.currentProducer.counts.getTotalRefCount() > 0) {
                try {
                    if (!this.producers.containsKey(this.currentProducer.name)) {
                        this.producers.put(this.currentProducer.name, this.currentProducer);
                    }
                    long start = 0L;
                    if (ApiPlugin.DEBUG_USE_REPORT_CONVERTER) {
                        System.out.println("Writing producer report for bundle: " + this.currentProducer.name);
                        start = System.currentTimeMillis();
                    }
                    if (this.consumer.counts.getTotalRefCount() > 0) {
                        ConsumerReportConvertor.this.writeProducerReport(this.consumer, this.currentProducer);
                    }
                    if (ApiPlugin.DEBUG_USE_REPORT_CONVERTER) {
                        System.out.println("Done in: " + (System.currentTimeMillis() - start) + " ms");
                    }
                }
                catch (Exception e) {
                    ApiPlugin.log(e);
                }
            }
        }

        @Override
        public boolean visitReferencingComponent(IComponentDescriptor component) {
            return component.equals(this.consumerDescriptor);
        }

        @Override
        public void endVisitReferencingComponent(IComponentDescriptor component) {
        }

        @Override
        public boolean visitMember(IMemberDescriptor referencedMember) {
            IReferenceTypeDescriptor desc = this.getEnclosingDescriptor(referencedMember);
            if (desc == null) {
                return false;
            }
            this.currenttype = this.keys.get(desc);
            if (this.currenttype == null) {
                this.currenttype = new Type2(desc);
                this.keys.put(desc, this.currenttype);
            }
            this.currentProducer.types.put(desc, this.currenttype);
            this.currentmember = new UseReportConverter.Member(referencedMember);
            this.currenttype.referencingMembers.put(referencedMember, this.currentmember);
            return true;
        }

        @Override
        public void endVisitMember(IMemberDescriptor referencedMember) {
            IReferenceTypeDescriptor desc;
            if (this.currenttype.counts.getTotalRefCount() == 0 && (desc = this.getEnclosingDescriptor(referencedMember)) != null) {
                this.keys.remove(desc);
                this.currentProducer.types.remove(desc);
            }
        }

        @Override
        public void visitReference(IReferenceDescriptor reference) {
            IMemberDescriptor fromMember = reference.getMember();
            if (!this.acceptReference(reference.getReferencedMember(), ConsumerReportConvertor.this.topatterns) || !this.acceptReference(fromMember, ConsumerReportConvertor.this.frompatterns)) {
                return;
            }
            int lineNumber = reference.getLineNumber();
            int refKind = reference.getReferenceKind();
            int visibility = reference.getVisibility();
            String refname = Reference.getReferenceText(refKind);
            List<UseReportConverter.Reference> refs = this.currentmember.children.get(refname);
            if (refs == null) {
                refs = new ArrayList<UseReportConverter.Reference>();
                this.currentmember.children.put(refname, refs);
            }
            refs.add(new UseReportConverter.Reference(fromMember, lineNumber, visibility, this.formatMessages(reference.getProblemMessages())));
            block0 : switch (fromMember.getElementType()) {
                case 2: {
                    switch (visibility) {
                        case 1: {
                            ++this.consumer.counts.total_api_type_count;
                            ++this.currentProducer.counts.total_api_type_count;
                            ++this.currentmember.counts.total_api_type_count;
                            ++this.currenttype.counts.total_api_type_count;
                            break block0;
                        }
                        case 2: {
                            ++this.consumer.counts.total_private_type_count;
                            ++this.currentProducer.counts.total_private_type_count;
                            ++this.currentmember.counts.total_private_type_count;
                            ++this.currenttype.counts.total_private_type_count;
                            break block0;
                        }
                        case 8: {
                            ++this.consumer.counts.total_permissable_type_count;
                            ++this.currentProducer.counts.total_permissable_type_count;
                            ++this.currentmember.counts.total_permissable_type_count;
                            ++this.currenttype.counts.total_permissable_type_count;
                            break block0;
                        }
                        case 5: {
                            ++this.consumer.counts.total_fragment_permissible_type_count;
                            ++this.currentProducer.counts.total_fragment_permissible_type_count;
                            ++this.currentmember.counts.total_fragment_permissible_type_count;
                            ++this.currenttype.counts.total_fragment_permissible_type_count;
                            break block0;
                        }
                        case 22: {
                            ++this.consumer.counts.total_illegal_type_count;
                            ++this.currentProducer.counts.total_illegal_type_count;
                            ++this.currentmember.counts.total_illegal_type_count;
                            ++this.currenttype.counts.total_illegal_type_count;
                            break block0;
                        }
                    }
                    break;
                }
                case 6: {
                    switch (visibility) {
                        case 1: {
                            ++this.consumer.counts.total_api_method_count;
                            ++this.currentProducer.counts.total_api_method_count;
                            ++this.currentmember.counts.total_api_method_count;
                            ++this.currenttype.counts.total_api_method_count;
                            break block0;
                        }
                        case 2: {
                            ++this.consumer.counts.total_private_method_count;
                            ++this.currentProducer.counts.total_private_method_count;
                            ++this.currentmember.counts.total_private_method_count;
                            ++this.currenttype.counts.total_private_method_count;
                            break block0;
                        }
                        case 8: {
                            ++this.consumer.counts.total_permissable_method_count;
                            ++this.currentProducer.counts.total_permissable_method_count;
                            ++this.currentmember.counts.total_permissable_method_count;
                            ++this.currenttype.counts.total_permissable_method_count;
                            break block0;
                        }
                        case 5: {
                            ++this.consumer.counts.total_fragment_permissible_method_count;
                            ++this.currentProducer.counts.total_fragment_permissible_method_count;
                            ++this.currentmember.counts.total_fragment_permissible_method_count;
                            ++this.currenttype.counts.total_fragment_permissible_method_count;
                            break block0;
                        }
                        case 22: {
                            ++this.consumer.counts.total_illegal_method_count;
                            ++this.currentProducer.counts.total_illegal_method_count;
                            ++this.currentmember.counts.total_illegal_method_count;
                            ++this.currenttype.counts.total_illegal_method_count;
                            break block0;
                        }
                    }
                    break;
                }
                case 5: {
                    switch (visibility) {
                        case 1: {
                            ++this.consumer.counts.total_api_field_count;
                            ++this.currentProducer.counts.total_api_field_count;
                            ++this.currentmember.counts.total_api_field_count;
                            ++this.currenttype.counts.total_api_field_count;
                            break block0;
                        }
                        case 2: {
                            ++this.consumer.counts.total_private_field_count;
                            ++this.currentProducer.counts.total_private_field_count;
                            ++this.currentmember.counts.total_private_field_count;
                            ++this.currenttype.counts.total_private_field_count;
                            break block0;
                        }
                        case 8: {
                            ++this.consumer.counts.total_permissable_field_count;
                            ++this.currentProducer.counts.total_permissable_field_count;
                            ++this.currentmember.counts.total_permissable_field_count;
                            ++this.currenttype.counts.total_permissable_field_count;
                            break block0;
                        }
                        case 5: {
                            ++this.consumer.counts.total_fragment_permissible_field_count;
                            ++this.currentProducer.counts.total_fragment_permissible_field_count;
                            ++this.currentmember.counts.total_fragment_permissible_field_count;
                            ++this.currenttype.counts.total_fragment_permissible_field_count;
                            break block0;
                        }
                        case 22: {
                            ++this.consumer.counts.total_illegal_field_count;
                            ++this.currentProducer.counts.total_illegal_field_count;
                            ++this.currentmember.counts.total_illegal_field_count;
                            ++this.currenttype.counts.total_illegal_field_count;
                            break block0;
                        }
                    }
                    break;
                }
            }
        }

        private boolean acceptReference(IMemberDescriptor desc, Pattern[] patterns) {
            if (patterns != null) {
                Pattern[] patternArray = patterns;
                int n = patterns.length;
                int n2 = 0;
                while (n2 < n) {
                    Pattern pattern = patternArray[n2];
                    if (pattern.matcher(desc.getPackage().getName()).find()) {
                        return false;
                    }
                    ++n2;
                }
            }
            return true;
        }

        private IReferenceTypeDescriptor getEnclosingDescriptor(IMemberDescriptor member) {
            switch (member.getElementType()) {
                case 2: {
                    return (IReferenceTypeDescriptor)member;
                }
                case 5: 
                case 6: {
                    return member.getEnclosingType();
                }
            }
            return null;
        }

        private String formatMessages(String[] messages) {
            if (messages != null) {
                StringBuffer buffer = new StringBuffer();
                int i = 0;
                while (i < messages.length) {
                    buffer.append(messages[i]);
                    if (i < messages.length - 1) {
                        buffer.append("\n");
                    }
                    ++i;
                }
                return buffer.toString();
            }
            return null;
        }
    }

    class ListConsumersVisitor
    extends UseScanVisitor {
        Set<IComponentDescriptor> consumers = new HashSet<IComponentDescriptor>();

        ListConsumersVisitor() {
        }

        @Override
        public boolean visitComponent(IComponentDescriptor target) {
            return true;
        }

        @Override
        public boolean visitReferencingComponent(IComponentDescriptor component) {
            this.consumers.add(component);
            return false;
        }

        @Override
        public boolean visitMember(IMemberDescriptor referencedMember) {
            return false;
        }

        @Override
        public void visitReference(IReferenceDescriptor reference) {
        }
    }

    class Producer {
        String name;
        Map<IReferenceTypeDescriptor, Type2> types = new HashMap<IReferenceTypeDescriptor, Type2>();
        UseReportConverter.CountGroup counts = new UseReportConverter.CountGroup();

        Producer() {
        }
    }

    class Type2
    extends UseReportConverter.Type {
        Map<IMemberDescriptor, UseReportConverter.Member> referencingMembers;

        public Type2(IElementDescriptor desc) {
            super(desc);
            this.referencingMembers = new HashMap<IMemberDescriptor, UseReportConverter.Member>();
        }
    }
}

