/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.imports;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.WorkspaceModelManager;
import org.eclipse.pde.internal.core.plugin.AbstractPluginModelBase;
import org.eclipse.pde.internal.core.util.PatternConstructor;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.SWTFactory;
import org.eclipse.pde.internal.ui.util.SWTUtil;
import org.eclipse.pde.internal.ui.util.SourcePluginFilter;
import org.eclipse.pde.internal.ui.wizards.ListUtil;
import org.eclipse.pde.internal.ui.wizards.imports.BaseImportWizardSecondPage;
import org.eclipse.pde.internal.ui.wizards.imports.PluginImportLabelProvider;
import org.eclipse.pde.internal.ui.wizards.imports.PluginImportWizardFirstPage;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.WorkbenchJob;
import org.osgi.framework.Version;

public class PluginImportWizardDetailedPage
extends BaseImportWizardSecondPage {
    private Label fCountLabel;
    private int fCountTotal;
    private TableViewer fAvailableListViewer;
    private Text fFilterText;
    private VersionFilter fVersionFilter;
    private AvailableFilter fAvailableFilter;
    private SourcePluginFilter fSourceFilter;
    private ViewerFilter fRepositoryFilter;
    private Set<Object> fSelected;
    private WorkbenchJob fFilterJob;
    private Button fAddButton;
    private Button fAddAllButton;
    private Button fRemoveButton;
    private Button fRemoveAllButton;
    private Button fAddRequiredButton;
    private Button fFilterOldVersionButton;
    private static final String SETTINGS_SHOW_LATEST = "showLatestPluginsOnly";

    public PluginImportWizardDetailedPage(String pageName, PluginImportWizardFirstPage firstPage) {
        super(pageName, firstPage);
        this.setTitle(PDEUIMessages.ImportWizard_DetailedPage_title);
        this.setMessage(PDEUIMessages.ImportWizard_DetailedPage_desc);
        this.fSelected = new HashSet<Object>();
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.makeColumnsEqualWidth = false;
        layout.horizontalSpacing = 5;
        layout.verticalSpacing = 10;
        container.setLayout((Layout)layout);
        this.createScrollArea(container);
        this.createAvailableList(container).setLayoutData((Object)new GridData(1808));
        this.createButtonArea(container);
        this.createImportList(container).setLayoutData((Object)new GridData(1808));
        this.updateCount();
        Composite optionComp = SWTFactory.createComposite(container, 1, 3, 768, 5, 0);
        this.createComputationsOption(optionComp);
        this.createFilterOptions(optionComp);
        this.addViewerListeners();
        this.initialize();
        this.addFilters();
        this.setControl((Control)container);
        Dialog.applyDialogFont((Control)container);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)container, "org.eclipse.pde.doc.user.plugin_import_second_page");
    }

    private void createFilterOptions(Composite container) {
        this.fFilterOldVersionButton = SWTFactory.createCheckButton(container, PDEUIMessages.ImportWizard_DetailedPage_filterDesc, null, true, 1);
        if (this.getDialogSettings().get(SETTINGS_SHOW_LATEST) != null) {
            this.fFilterOldVersionButton.setSelection(this.getDialogSettings().getBoolean(SETTINGS_SHOW_LATEST));
        } else {
            this.fFilterOldVersionButton.setSelection(true);
        }
        this.fFilterOldVersionButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            if (this.fFilterOldVersionButton.getSelection()) {
                this.fAvailableListViewer.addFilter((ViewerFilter)this.fVersionFilter);
            } else {
                this.fAvailableListViewer.removeFilter((ViewerFilter)this.fVersionFilter);
            }
            this.updateCount();
        }));
    }

    private void addFilters() {
        this.fVersionFilter = new VersionFilter();
        this.fVersionFilter.setModel(this.fModels);
        this.fSourceFilter = new SourcePluginFilter(this.fPage1.getState());
        this.fAvailableFilter = new AvailableFilter();
        this.fAvailableListViewer.addFilter((ViewerFilter)this.fAvailableFilter);
        if (this.fFilterOldVersionButton.getSelection()) {
            this.fAvailableListViewer.addFilter((ViewerFilter)this.fVersionFilter);
        }
        this.fAvailableListViewer.addFilter((ViewerFilter)this.fSourceFilter);
        this.fRepositoryFilter = new RepositoryFilter();
        this.fAvailableListViewer.addFilter(this.fRepositoryFilter);
        this.fFilterJob = new WorkbenchJob("FilterJob"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                PluginImportWizardDetailedPage.this.handleFilter();
                return Status.OK_STATUS;
            }
        };
        this.fFilterJob.setSystem(true);
    }

    private void initialize() {
        this.updateButtonEnablement(true, true);
        this.setPageComplete(false);
    }

    private void addViewerListeners() {
        this.fAvailableListViewer.addDoubleClickListener(event -> this.handleAdd());
        this.fImportListViewer.addDoubleClickListener(event -> this.handleRemove());
        this.fAvailableListViewer.addSelectionChangedListener(event -> this.updateSelectionBasedEnablement(event.getSelection(), true));
        this.fImportListViewer.addSelectionChangedListener(event -> this.updateSelectionBasedEnablement(event.getSelection(), false));
        this.fFilterText.addModifyListener(e -> {
            this.fFilterJob.cancel();
            this.fFilterJob.schedule(200L);
        });
    }

    private Composite createAvailableList(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)new GridData());
        Label label = new Label(container, 0);
        label.setText(PDEUIMessages.ImportWizard_DetailedPage_availableList);
        Table table = new Table(container, 2562);
        GridData gd = new GridData(1808);
        gd.heightHint = 200;
        gd.widthHint = 225;
        table.setLayoutData((Object)gd);
        this.fAvailableListViewer = new TableViewer(table);
        this.fAvailableListViewer.setLabelProvider((IBaseLabelProvider)new PluginImportLabelProvider());
        this.fAvailableListViewer.setContentProvider((IContentProvider)new ContentProvider());
        this.fAvailableListViewer.setInput((Object)PDECore.getDefault().getModelManager());
        this.fAvailableListViewer.setComparator(ListUtil.PLUGIN_COMPARATOR);
        return container;
    }

    private Composite createButtonArea(Composite parent) {
        ScrolledComposite comp = new ScrolledComposite(parent, 768);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        comp.setLayoutData((Object)new GridData(1040));
        Composite container = new Composite((Composite)comp, 0);
        layout = new GridLayout();
        layout.marginWidth = 0;
        container.setLayout((Layout)layout);
        GridData gd = new GridData(1040);
        gd.verticalIndent = 15;
        container.setLayoutData((Object)gd);
        Button button = new Button(container, 8);
        button.setText(PDEUIMessages.ImportWizard_DetailedPage_existing);
        button.setLayoutData((Object)new GridData(768));
        button.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.handleExistingProjects()));
        SWTUtil.setButtonDimensionHint(button);
        button = new Button(container, 8);
        button.setText(PDEUIMessages.ImportWizard_DetailedPage_existingUnshared);
        button.setLayoutData((Object)new GridData(768));
        button.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.handleExistingUnshared()));
        SWTUtil.setButtonDimensionHint(button);
        this.fAddButton = new Button(container, 8);
        this.fAddButton.setText(PDEUIMessages.ImportWizard_DetailedPage_add);
        this.fAddButton.setLayoutData((Object)new GridData(768));
        this.fAddButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.handleAdd()));
        SWTUtil.setButtonDimensionHint(this.fAddButton);
        this.fAddAllButton = new Button(container, 8);
        this.fAddAllButton.setText(PDEUIMessages.ImportWizard_DetailedPage_addAll);
        this.fAddAllButton.setLayoutData((Object)new GridData(768));
        this.fAddAllButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.handleAddAll()));
        SWTUtil.setButtonDimensionHint(this.fAddAllButton);
        this.fRemoveButton = new Button(container, 8);
        this.fRemoveButton.setText(PDEUIMessages.ImportWizard_DetailedPage_remove);
        this.fRemoveButton.setLayoutData((Object)new GridData(768));
        this.fRemoveButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.handleRemove()));
        SWTUtil.setButtonDimensionHint(this.fRemoveButton);
        this.fRemoveAllButton = new Button(container, 8);
        this.fRemoveAllButton.setText(PDEUIMessages.ImportWizard_DetailedPage_removeAll);
        this.fRemoveAllButton.setLayoutData((Object)new GridData(768));
        this.fRemoveAllButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.handleRemoveAll()));
        SWTUtil.setButtonDimensionHint(this.fRemoveAllButton);
        button = new Button(container, 8);
        button.setText(PDEUIMessages.ImportWizard_DetailedPage_swap);
        button.setLayoutData((Object)new GridData(768));
        button.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.handleSwap()));
        SWTUtil.setButtonDimensionHint(button);
        this.fAddRequiredButton = new Button(container, 8);
        this.fAddRequiredButton.setText(PDEUIMessages.ImportWizard_DetailedPage_addRequired);
        this.fAddRequiredButton.setLayoutData((Object)new GridData(768));
        this.fAddRequiredButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.handleAddRequiredPlugins()));
        SWTUtil.setButtonDimensionHint(this.fAddRequiredButton);
        this.fCountLabel = new Label(container, 0);
        this.fCountLabel.setLayoutData((Object)new GridData(64));
        comp.setContent((Control)container);
        comp.setMinHeight(250);
        comp.setExpandHorizontal(true);
        comp.setExpandVertical(true);
        return container;
    }

    private Composite createScrollArea(Composite parent) {
        Group container = new Group(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 6;
        layout.marginWidth = 6;
        container.setLayout((Layout)layout);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 3;
        container.setLayoutData((Object)gd);
        container.setText(PDEUIMessages.ImportWizard_DetailedPage_filter);
        Label filterLabel = new Label((Composite)container, 0);
        filterLabel.setText(PDEUIMessages.ImportWizard_DetailedPage_search);
        this.fFilterText = new Text((Composite)container, 2048);
        this.fFilterText.setText("");
        gd = new GridData(768);
        this.fFilterText.setLayoutData((Object)gd);
        return container;
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.fFilterText.setFocus();
            this.setPageComplete(this.fImportListViewer.getTable().getItemCount() > 0);
        }
    }

    @Override
    protected void refreshPage() {
        this.fAvailableListViewer.addFilter((ViewerFilter)this.fSourceFilter);
        this.fImportListViewer.getTable().removeAll();
        this.fSelected.clear();
        this.fAvailableFilter.setPattern("*");
        this.fSourceFilter.setState(this.fPage1.getState());
        this.fVersionFilter.setModel(this.fModels);
        this.fAvailableListViewer.refresh();
        this.pageChanged();
    }

    protected void pageChanged() {
        this.pageChanged(false, false);
    }

    protected void pageChanged(boolean doAddEnablement, boolean doRemoveEnablement) {
        this.updateButtonEnablement(doAddEnablement, doRemoveEnablement);
        this.setPageComplete(this.fImportListViewer.getTable().getItemCount() > 0);
        this.setMessage(PDEUIMessages.ImportWizard_DetailedPage_desc);
    }

    private void updateCount() {
        if (this.fCountTotal <= 0) {
            this.fCountTotal = this.fAvailableListViewer.getTable().getItemCount();
        }
        this.fCountLabel.setText(NLS.bind((String)PDEUIMessages.ImportWizard_DetailedPage_count, (Object[])new String[]{Integer.toString(this.fImportListViewer.getTable().getItemCount()), Integer.toString(this.fCountTotal)}));
        this.fCountLabel.getParent().layout();
    }

    private void updateButtonEnablement(boolean doAddEnablement, boolean doRemoveEnablement) {
        this.updateCount();
        int availableCount = this.fAvailableListViewer.getTable().getItemCount();
        int importCount = this.fImportListViewer.getTable().getItemCount();
        if (doAddEnablement) {
            this.updateSelectionBasedEnablement(this.fAvailableListViewer.getSelection(), true);
        }
        if (doRemoveEnablement) {
            this.updateSelectionBasedEnablement(this.fImportListViewer.getSelection(), false);
        }
        this.fAddAllButton.setEnabled(availableCount > 0);
        this.fRemoveAllButton.setEnabled(importCount > 0);
        this.fAddRequiredButton.setEnabled(importCount > 0);
    }

    private void updateSelectionBasedEnablement(ISelection theSelection, boolean available) {
        if (available) {
            this.fAddButton.setEnabled(!theSelection.isEmpty());
        } else {
            this.fRemoveButton.setEnabled(!theSelection.isEmpty());
        }
    }

    private void handleAdd() {
        IStructuredSelection ssel = (IStructuredSelection)this.fAvailableListViewer.getSelection();
        if (ssel.size() > 0) {
            Table table = this.fAvailableListViewer.getTable();
            int index = table.getSelectionIndices()[0];
            this.doAdd(ssel.toList());
            table.setSelection(index < table.getItemCount() ? index : table.getItemCount() - 1);
            this.pageChanged(true, false);
        }
    }

    private void handleAddAll() {
        TableItem[] items = this.fAvailableListViewer.getTable().getItems();
        ArrayList<Object> data = new ArrayList<Object>();
        TableItem[] tableItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            data.add(item.getData());
            ++n2;
        }
        if (data.size() > 0) {
            this.doAdd(data);
            this.pageChanged(true, false);
        }
    }

    private void handleFilter() {
        String newFilter;
        boolean changed = false;
        if (this.fFilterText == null || (newFilter = this.fFilterText.getText().trim()).length() == 0) {
            newFilter = "*";
        }
        if (changed = this.fAvailableFilter.setPattern(newFilter)) {
            this.fAvailableListViewer.refresh();
            this.updateButtonEnablement(false, false);
        }
    }

    private void handleRemove() {
        IStructuredSelection ssel = (IStructuredSelection)this.fImportListViewer.getSelection();
        if (ssel.size() > 0) {
            Table table = this.fImportListViewer.getTable();
            int index = table.getSelectionIndices()[0];
            this.doRemove(ssel.toList());
            table.setSelection(index < table.getItemCount() ? index : table.getItemCount() - 1);
            this.pageChanged(false, true);
        }
    }

    private void doAdd(List<Object> items) {
        this.fImportListViewer.add(items.toArray());
        this.fAvailableListViewer.remove(items.toArray());
        this.fSelected.addAll(items);
    }

    private void doRemove(List<Object> items) {
        this.fSelected.removeAll(items);
        this.fImportListViewer.remove(items.toArray());
        this.fAvailableListViewer.add(items.toArray());
    }

    private void handleRemoveAll() {
        TableItem[] items = this.fImportListViewer.getTable().getItems();
        ArrayList<Object> data = new ArrayList<Object>();
        TableItem[] tableItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            data.add(item.getData());
            ++n2;
        }
        if (data.size() > 0) {
            this.doRemove(data);
            this.pageChanged(false, true);
        }
    }

    private void handleSetImportSelection(ArrayList<Object> newSelectionList) {
        if (newSelectionList.size() == 0) {
            this.handleRemoveAll();
            this.pageChanged();
            return;
        }
        TableItem[] items = this.fImportListViewer.getTable().getItems();
        Object[] oldSelection = new Object[items.length];
        int i = 0;
        while (i < items.length) {
            oldSelection[i] = items[i].getData();
            ++i;
        }
        ArrayList<Object> itemsToRemove = new ArrayList<Object>();
        Object[] objectArray = oldSelection;
        int n = oldSelection.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (newSelectionList.contains(element)) {
                newSelectionList.remove(element);
            } else {
                itemsToRemove.add(element);
            }
            ++n2;
        }
        this.doRemove(itemsToRemove);
        this.doAdd(newSelectionList);
        this.pageChanged();
    }

    private void handleSwap() {
        TableItem item;
        TableItem[] aItems = this.fAvailableListViewer.getTable().getItems();
        TableItem[] iItems = this.fImportListViewer.getTable().getItems();
        ArrayList<Object> data = new ArrayList<Object>();
        TableItem[] tableItemArray = iItems;
        int n = iItems.length;
        int n2 = 0;
        while (n2 < n) {
            item = tableItemArray[n2];
            data.add(item.getData());
            ++n2;
        }
        if (data.size() > 0) {
            this.doRemove(data);
        }
        data.clear();
        tableItemArray = aItems;
        n = aItems.length;
        n2 = 0;
        while (n2 < n) {
            item = tableItemArray[n2];
            data.add(item.getData());
            ++n2;
        }
        if (data.size() > 0) {
            this.doAdd(data);
        }
        this.pageChanged();
    }

    private void handleExistingProjects() {
        ArrayList<Object> result = new ArrayList<Object>();
        IPluginModelBase[] iPluginModelBaseArray = this.fModels;
        int n = this.fModels.length;
        int n2 = 0;
        while (n2 < n) {
            IPluginModelBase model = iPluginModelBaseArray[n2];
            String id = model.getPluginBase().getId();
            IProject project = (IProject)PDEPlugin.getWorkspace().getRoot().findMember(id);
            if (project != null && project.isOpen() && WorkspaceModelManager.isPluginProject((IProject)project)) {
                result.add(model);
            }
            ++n2;
        }
        this.handleSetImportSelection(result);
    }

    private void handleExistingUnshared() {
        ArrayList<Object> result = new ArrayList<Object>();
        IPluginModelBase[] iPluginModelBaseArray = this.fModels;
        int n = this.fModels.length;
        int n2 = 0;
        while (n2 < n) {
            IPluginModelBase model = iPluginModelBaseArray[n2];
            String id = model.getPluginBase().getId();
            IProject project = (IProject)PDEPlugin.getWorkspace().getRoot().findMember(id);
            if (project != null && WorkspaceModelManager.isUnsharedProject((IProject)project) && WorkspaceModelManager.isPluginProject((IProject)project)) {
                result.add(model);
            }
            ++n2;
        }
        this.handleSetImportSelection(result);
    }

    private void handleAddRequiredPlugins() {
        IPluginModelBase model;
        TableItem[] items = this.fImportListViewer.getTable().getItems();
        if (items.length == 0) {
            return;
        }
        if (items.length == 1 && (model = (IPluginModelBase)items[0].getData()).getPluginBase().getId().equals("org.eclipse.core.boot")) {
            return;
        }
        ArrayList<IPluginModelBase> result = new ArrayList<IPluginModelBase>();
        TableItem[] tableItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            this.addPluginAndDependencies((IPluginModelBase)item.getData(), result, this.fAddFragmentsButton.getSelection());
            ++n2;
        }
        ArrayList<Object> resultObject = new ArrayList<Object>(result.size());
        resultObject.addAll(result);
        this.handleSetImportSelection(resultObject);
    }

    @Override
    public void dispose() {
        this.fFilterJob.cancel();
    }

    @Override
    public void storeSettings() {
        IDialogSettings settings = this.getDialogSettings();
        settings.put(SETTINGS_SHOW_LATEST, this.fFilterOldVersionButton.getSelection());
        super.storeSettings();
    }

    private class AvailableFilter
    extends ViewerFilter {
        private Pattern fPattern;

        public AvailableFilter() {
            this.setPattern("*");
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (PluginImportWizardDetailedPage.this.fSelected.contains(element)) {
                return false;
            }
            if (!(element instanceof AbstractPluginModelBase)) {
                return false;
            }
            String itemID = ((AbstractPluginModelBase)element).getPluginBase().getId();
            return this.fPattern.matcher(itemID).matches();
        }

        public boolean setPattern(String newPattern) {
            String oldPattern;
            if (!newPattern.endsWith("*")) {
                newPattern = String.valueOf(newPattern) + "*";
            }
            if (!newPattern.startsWith("*")) {
                newPattern = "*" + newPattern;
            }
            if (this.fPattern != null && newPattern.equals(oldPattern = this.fPattern.pattern())) {
                return false;
            }
            this.fPattern = PatternConstructor.createPattern((String)newPattern, (boolean)true);
            return true;
        }
    }

    class ContentProvider
    implements IStructuredContentProvider {
        ContentProvider() {
        }

        public Object[] getElements(Object element) {
            return PluginImportWizardDetailedPage.this.fModels;
        }
    }

    private class RepositoryFilter
    extends ViewerFilter {
        private RepositoryFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (PluginImportWizardDetailedPage.this.fPage1.getImportType() == 4) {
                return PluginImportWizardDetailedPage.this.fPage1.repositoryModels.contains(element);
            }
            return true;
        }
    }

    private class VersionFilter
    extends ViewerFilter {
        private HashMap<String, Version> versions = new HashMap();

        private VersionFilter() {
        }

        public void setModel(IPluginModelBase[] plugins) {
            if (plugins != null && plugins.length > 0) {
                this.versions.clear();
            }
            IPluginModelBase[] iPluginModelBaseArray = plugins;
            int n = plugins.length;
            int n2 = 0;
            while (n2 < n) {
                IPluginModelBase plugin = iPluginModelBaseArray[n2];
                String name = plugin.getBundleDescription().getSymbolicName();
                Version version = plugin.getBundleDescription().getVersion();
                Version oldVersion = this.versions.get(name);
                if (oldVersion == null || oldVersion.compareTo(version) < 0) {
                    this.versions.put(name, version);
                }
                ++n2;
            }
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            IPluginModelBase plugin = (IPluginModelBase)element;
            Version hVersion = this.versions.get(plugin.getBundleDescription().getSymbolicName());
            if (hVersion == null) {
                return true;
            }
            return hVersion.equals((Object)plugin.getBundleDescription().getVersion());
        }
    }
}

