/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.services.internal;

import org.eclipse.sapphire.LocalizableText;
import org.eclipse.sapphire.MasterConversionService;
import org.eclipse.sapphire.PropertyDef;
import org.eclipse.sapphire.Text;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.modeling.ValueKeyword;
import org.eclipse.sapphire.modeling.annotations.NumericRange;
import org.eclipse.sapphire.services.ServiceCondition;
import org.eclipse.sapphire.services.ServiceContext;
import org.eclipse.sapphire.services.ValidationService;

public final class NumericRangeValidationService
extends ValidationService {
    @Text(value="{0} is smaller than the minimum allowed value ({1})")
    private static LocalizableText smallerThanMinimumMessage;
    @Text(value="{0} is larger than the maximum allowed value ({1})")
    private static LocalizableText largerThanMaxiumMessage;
    private Comparable min;
    private Comparable max;

    static {
        LocalizableText.init(NumericRangeValidationService.class);
    }

    @Override
    protected void initValidationService() {
        String maxStr;
        PropertyDef property = this.context(PropertyDef.class);
        Class<?> type = property.getTypeClass();
        NumericRange rangeConstraintAnnotation = property.getAnnotation(NumericRange.class);
        MasterConversionService converter = property.service(MasterConversionService.class);
        String minStr = rangeConstraintAnnotation.min();
        if (minStr != null) {
            Comparable comparable = this.min = minStr.length() > 0 ? (Comparable)converter.convert(minStr, type) : null;
        }
        if ((maxStr = rangeConstraintAnnotation.max()) != null) {
            this.max = maxStr.length() > 0 ? (Comparable)converter.convert(maxStr, type) : null;
        }
    }

    @Override
    protected Status compute() {
        Value value = this.context(Value.class);
        Comparable val = (Comparable)value.content(true);
        if (val != null) {
            ValueProperty property = value.definition();
            if (this.min != null && val.compareTo(this.min) < 0) {
                String msg = smallerThanMinimumMessage.format(val, this.normalizeForDisplay(property, this.min));
                return Status.createErrorStatus(msg);
            }
            if (this.max != null && val.compareTo(this.max) > 0) {
                String msg = largerThanMaxiumMessage.format(val, this.normalizeForDisplay(property, this.max));
                return Status.createErrorStatus(msg);
            }
        }
        return Status.createOkStatus();
    }

    private String normalizeForDisplay(ValueProperty property, Object value) {
        String result = property.encodeKeywords(value.toString());
        ValueKeyword keyword = property.getKeyword(result);
        if (keyword != null) {
            result = keyword.toDisplayString();
        }
        return result;
    }

    public static final class Condition
    extends ServiceCondition {
        @Override
        public boolean applicable(ServiceContext context) {
            ValueProperty property = context.find(ValueProperty.class);
            return property != null && property.hasAnnotation(NumericRange.class) && Number.class.isAssignableFrom(property.getTypeClass());
        }
    }
}

