/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.services.internal;

import java.util.SortedSet;
import org.eclipse.sapphire.LocalizableText;
import org.eclipse.sapphire.PropertyDef;
import org.eclipse.sapphire.Text;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.FileSystemResourceType;
import org.eclipse.sapphire.modeling.annotations.ValidFileSystemResourceType;
import org.eclipse.sapphire.services.FactsService;
import org.eclipse.sapphire.services.ServiceCondition;
import org.eclipse.sapphire.services.ServiceContext;

public final class ValidFileSystemResourceTypeFactsService
extends FactsService {
    @Text(value="Must be a file")
    private static LocalizableText statementForFile;
    @Text(value="Must be a folder")
    private static LocalizableText statementForFolder;

    static {
        LocalizableText.init(ValidFileSystemResourceTypeFactsService.class);
    }

    @Override
    protected void facts(SortedSet<String> facts) {
        ValidFileSystemResourceType a = this.context(PropertyDef.class).getAnnotation(ValidFileSystemResourceType.class);
        FileSystemResourceType type = a.value();
        if (type == FileSystemResourceType.FILE) {
            facts.add(statementForFile.text());
        } else if (type == FileSystemResourceType.FOLDER) {
            facts.add(statementForFolder.text());
        } else {
            throw new IllegalStateException();
        }
    }

    public static final class Condition
    extends ServiceCondition {
        @Override
        public boolean applicable(ServiceContext context) {
            ValueProperty property = context.find(ValueProperty.class);
            return property != null && property.hasAnnotation(ValidFileSystemResourceType.class);
        }
    }
}

