/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.revision.graph.cache;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import org.eclipse.team.svn.revision.graph.cache.BytesUtility;
import org.eclipse.team.svn.revision.graph.cache.IndexPairsStorage;
import org.eclipse.team.svn.revision.graph.cache.Pair;
import org.eclipse.team.svn.revision.graph.cache.StringStorage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PathStorage {
    public static final int ROOT_INDEX = 0;
    protected static final String PATH_SEPARATOR = "/";
    protected StringStorage strings = new StringStorage();
    protected IndexPairsStorage pathIndex = new IndexPairsStorage();

    public int add(String path) {
        String[] parts;
        if (path == null) {
            return -1;
        }
        int resultIndex = 0;
        String[] stringArray = parts = path.split(PATH_SEPARATOR);
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            String part = stringArray[n2];
            int stringIndex = this.strings.add(part);
            resultIndex = this.pathIndex.add(new Pair(resultIndex, stringIndex));
            ++n2;
        }
        return resultIndex;
    }

    public String getPath(int index) {
        if (index == -1) {
            return null;
        }
        List<Pair> pairs = this.getPathPairs(index);
        if (!pairs.isEmpty()) {
            StringBuffer res = new StringBuffer();
            for (Pair pair : pairs) {
                String path = (String)this.strings.getValue(pair.second);
                res.append(PATH_SEPARATOR).append(path);
            }
            return res.toString();
        }
        return null;
    }

    public List<Integer> getPathParents(int pathIndex) {
        LinkedList<Integer> parents = new LinkedList<Integer>();
        while (pathIndex != 0) {
            parents.addFirst(pathIndex);
            pathIndex = this.getParentPathIndex(pathIndex);
        }
        return parents;
    }

    protected List<Pair> getPathPairs(int index) {
        LinkedList<Pair> list = new LinkedList<Pair>();
        int tmpIndex = index;
        Pair pair = null;
        while ((pair = (Pair)this.pathIndex.getValue(tmpIndex)) != null && !this.isRootPair(pair)) {
            list.addFirst(pair);
            tmpIndex = pair.first;
        }
        return list;
    }

    protected Pair getParentPathPair(int pathIndex) {
        return (Pair)this.pathIndex.getValue(pathIndex);
    }

    public int getParentPathIndex(int pathIndex) {
        return this.getParentPathPair((int)pathIndex).first;
    }

    public int add(int parentIndex, int[] childParts) {
        int res = parentIndex;
        int[] nArray = childParts;
        int n = childParts.length;
        int n2 = 0;
        while (n2 < n) {
            int childPart = nArray[n2];
            res = this.pathIndex.add(new Pair(res, childPart));
            ++n2;
        }
        return res;
    }

    public boolean isParentIndex(int parentPathIndex, int childPathIndex) {
        if (childPathIndex >= parentPathIndex) {
            int index = childPathIndex;
            do {
                if (index != parentPathIndex) continue;
                return true;
            } while ((index = this.getParentPathIndex(index)) != 0);
        }
        return false;
    }

    public int[] makeRelative(int parentPathIndex, int childPathIndex) {
        if (!this.isParentIndex(parentPathIndex, childPathIndex)) {
            return new int[0];
        }
        LinkedList<Integer> elements = new LinkedList<Integer>();
        int index = childPathIndex;
        while (index != parentPathIndex) {
            Pair indexPair = (Pair)this.pathIndex.getValue(index);
            elements.addFirst(indexPair.second);
            index = indexPair.first;
        }
        return this.collection2Array(elements);
    }

    protected int[] collection2Array(Collection<Integer> col) {
        if (!col.isEmpty()) {
            int[] res = new int[col.size()];
            int i = 0;
            for (int element : col) {
                res[i++] = element;
            }
            return res;
        }
        return new int[0];
    }

    public void save(DataOutput out, Deflater encoder) throws IOException {
        BytesUtility.compressAndWrite(this.strings.toBytes(), out, encoder);
        BytesUtility.compressAndWrite(this.pathIndex.toBytes(), out, encoder);
    }

    public void load(DataInput in, Inflater decoder) throws IOException {
        byte[] stringsBytes = BytesUtility.decompressAndRead(in, decoder);
        this.strings = new StringStorage(stringsBytes);
        byte[] pathIndexesBytes = BytesUtility.decompressAndRead(in, decoder);
        this.pathIndex = new IndexPairsStorage(pathIndexesBytes);
    }

    public boolean isRootPair(Pair pair) {
        return pair.first == 0 && pair.second == 0;
    }

    public static void main(String[] s) throws Exception {
        String s1 = "/test/wiki-migration/project_wiki-plus-polarion/_wiki/Space_1/Page_1/attachment-1.txt";
        String s2 = "/sss";
        String s3 = "/test";
        String s4 = "/test/wiki-migration/project_wiki-plus-polarion";
        PathStorage instance = new PathStorage();
        int i1 = instance.add(s1);
        int i2 = instance.add(s2);
        int i3 = instance.add(s3);
        int i4 = instance.add(s4);
        System.out.println(instance.getPath(i1));
        System.out.println(instance.getPath(i2));
        int i10 = instance.add("/g1/g2/g3");
        int[] res = instance.makeRelative(i2, i1);
        System.out.println(instance.getPath(instance.add(i10, res)));
        res = instance.makeRelative(i3, i1);
        System.out.println(instance.getPath(instance.add(i10, res)));
        res = instance.makeRelative(i4, i1);
        System.out.println(instance.getPath(instance.add(i10, res)));
    }
}

