/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.revision.graph.operation;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.team.svn.core.operation.AbstractActionOperation;
import org.eclipse.team.svn.core.operation.ActivityCancelledException;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.revision.graph.SVNRevisionGraphMessages;
import org.eclipse.team.svn.revision.graph.SVNRevisionGraphPlugin;
import org.eclipse.team.svn.revision.graph.cache.RepositoryCache;
import org.eclipse.team.svn.revision.graph.cache.RepositoryCacheInfo;
import org.eclipse.team.svn.revision.graph.cache.RepositoryCachesManager;
import org.eclipse.team.svn.revision.graph.operation.IRepositoryCacheProvider;
import org.eclipse.team.svn.revision.graph.operation.RepositoryConnectionInfo;
import org.eclipse.team.svn.revision.graph.operation.RevisionGraphUtility;
import org.eclipse.team.svn.ui.utility.UIMonitorUtility;

public class CreateCacheDataOperation
extends AbstractActionOperation
implements IRepositoryCacheProvider {
    protected IRepositoryResource resource;
    protected boolean isRefresh;
    protected RepositoryConnectionInfo.IRepositoryConnectionInfoProvider repositoryConnectionInfoProvider;
    protected boolean isSkipFetchErrors;
    protected RepositoryCache repositoryCache;

    public CreateCacheDataOperation(IRepositoryResource resource, boolean isRefresh, RepositoryConnectionInfo.IRepositoryConnectionInfoProvider repositoryConnectionInfoProvider, boolean isSkipFetchErrors) {
        super("Operation_CreateCacheData", SVNRevisionGraphMessages.class);
        this.resource = resource;
        this.isRefresh = isRefresh;
        this.repositoryConnectionInfoProvider = repositoryConnectionInfoProvider;
        this.isSkipFetchErrors = isSkipFetchErrors;
    }

    protected void runImpl(IProgressMonitor monitor) throws Exception {
        RepositoryCacheInfo.CacheResult cacheResult;
        RepositoryCacheInfo cacheInfo = SVNRevisionGraphPlugin.instance().getRepositoryCachesManager().getCacheOrCreate(this.resource);
        RepositoryConnectionInfo connectionData = this.repositoryConnectionInfoProvider.getRepositoryConnectionInfo();
        RepositoryCacheInfo.CacheResult cacheResult2 = cacheResult = this.isRefresh ? cacheInfo.refreshCacheData(this.resource, connectionData, this.isSkipFetchErrors, monitor) : cacheInfo.createCacheData(this.resource, connectionData, this.isSkipFetchErrors, monitor);
        if (cacheResult.status == RepositoryCacheInfo.CacheResultEnum.BROKEN) {
            throw new ActivityCancelledException();
        }
        if (cacheResult.status == RepositoryCacheInfo.CacheResultEnum.CALCULATING) {
            UIMonitorUtility.getDisplay().syncExec(new Runnable(){

                public void run() {
                    MessageDialog dlg = RevisionGraphUtility.getCacheCalculatingDialog(RepositoryCachesManager.getRepositoryRoot(CreateCacheDataOperation.this.resource));
                    dlg.open();
                }
            });
            throw new ActivityCancelledException();
        }
        if (cacheResult.status != RepositoryCacheInfo.CacheResultEnum.OK) {
            throw new ActivityCancelledException();
        }
        this.repositoryCache = cacheResult.repositoryCache;
    }

    public RepositoryCache getRepositoryCache() {
        return this.repositoryCache;
    }
}

