/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.revision.graph.preferences;

import java.io.File;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.team.svn.revision.graph.SVNRevisionGraphMessages;
import org.eclipse.team.svn.revision.graph.SVNRevisionGraphPlugin;
import org.eclipse.team.svn.revision.graph.cache.RepositoryCacheInfo;
import org.eclipse.team.svn.revision.graph.cache.RepositoryCachesManager;
import org.eclipse.team.svn.revision.graph.preferences.AbstractSVNRevisionGraphPreferencesPage;
import org.eclipse.team.svn.revision.graph.preferences.SVNRevisionGraphPreferences;
import org.eclipse.team.svn.ui.composite.PathSelectionComposite;
import org.eclipse.team.svn.ui.dialog.DefaultDialog;
import org.eclipse.team.svn.ui.utility.UIMonitorUtility;
import org.eclipse.team.svn.ui.verifier.IValidationManager;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public class SVNTeamRevisionGraphPage
extends AbstractSVNRevisionGraphPreferencesPage
implements IPropertyChangeListener {
    protected RepositoryCachesManager cachesManager = SVNRevisionGraphPlugin.instance().getRepositoryCachesManager();
    protected ListViewer cachesViewer;
    protected PathSelectionComposite pathSelectionComposite;
    protected Button removeButton;
    protected Button exportButton;
    protected Button importButton;
    protected Button skipErrorsButton;
    protected boolean isSkipFetchErrors;

    public SVNTeamRevisionGraphPage() {
        this.cachesManager.addListener(this);
    }

    public void init(IWorkbench workbench) {
        this.setDescription(SVNRevisionGraphMessages.SVNTeamRevisionGraphPage_Description);
    }

    protected Control createContentsImpl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        this.createCacheComposite(composite);
        Label separator = new Label(composite, 258);
        GridData data = new GridData(768);
        separator.setLayoutData((Object)data);
        separator.setVisible(false);
        this.skipErrorsButton = new Button(composite, 32);
        data = new GridData(768);
        this.skipErrorsButton.setLayoutData((Object)data);
        this.skipErrorsButton.setText(SVNRevisionGraphMessages.SVNTeamRevisionGraphPage_SkipErrors);
        this.skipErrorsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SVNTeamRevisionGraphPage.this.isSkipFetchErrors = SVNTeamRevisionGraphPage.this.skipErrorsButton.getSelection();
            }
        });
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.team.svn.help.revisionGraphPreferencesContext");
        return composite;
    }

    protected void createCacheComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        this.createCachesViewer(composite);
        this.createButtons(composite);
        this.createDirectorySelection(composite);
    }

    protected void createCachesViewer(Composite parent) {
        this.cachesViewer = new ListViewer(parent);
        List list = this.cachesViewer.getList();
        list.setLayoutData((Object)new GridData(1808));
        this.cachesViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                RepositoryCacheInfo cacheInfo = (RepositoryCacheInfo)element;
                return cacheInfo.getRepositoryName();
            }
        });
        this.cachesViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                SVNTeamRevisionGraphPage.this.selectionChanged();
            }
        });
        this.cachesViewer.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                String str1 = ((RepositoryCacheInfo)e1).getRepositoryName();
                String str2 = ((RepositoryCacheInfo)e2).getRepositoryName();
                return str1.compareToIgnoreCase(str2);
            }
        });
        this.cachesViewer.getControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 127) {
                    SVNTeamRevisionGraphPage.this.removeCaches();
                }
            }
        });
    }

    protected void createButtons(Composite parent) {
        Composite buttons = new Composite(parent, 0);
        buttons.setLayoutData((Object)new GridData(2));
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        buttons.setLayout((Layout)layout);
        this.removeButton = new Button(buttons, 8);
        this.removeButton.setText(SVNRevisionGraphMessages.SVNTeamRevisionGraphPage_Remove);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.widthHint = DefaultDialog.computeButtonWidth((Button)this.removeButton);
        this.removeButton.setLayoutData((Object)data);
        this.removeButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                SVNTeamRevisionGraphPage.this.removeCaches();
            }
        });
        this.exportButton = new Button(buttons, 8);
        this.exportButton.setText(SVNRevisionGraphMessages.SVNTeamRevisionGraphPage_Export);
        data = new GridData();
        data.horizontalAlignment = 4;
        data.widthHint = DefaultDialog.computeButtonWidth((Button)this.exportButton);
        this.exportButton.setLayoutData((Object)data);
        this.exportButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                SVNTeamRevisionGraphPage.this.exportCaches();
            }
        });
        this.importButton = new Button(buttons, 8);
        this.importButton.setText(SVNRevisionGraphMessages.SVNTeamRevisionGraphPage_Import);
        data = new GridData();
        data.horizontalAlignment = 4;
        data.widthHint = DefaultDialog.computeButtonWidth((Button)this.importButton);
        this.importButton.setLayoutData((Object)data);
        this.importButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                SVNTeamRevisionGraphPage.this.importCaches();
            }
        });
    }

    protected void createDirectorySelection(Composite parent) {
        Group group = new Group(parent, 0);
        GridLayout layout = new GridLayout();
        group.setLayout((Layout)layout);
        GridData data = new GridData(768);
        data.horizontalSpan = 2;
        group.setLayoutData((Object)data);
        group.setText(SVNRevisionGraphMessages.SVNTeamRevisionGraphPage_Group_CacheDirectory);
        this.pathSelectionComposite = new PathSelectionComposite(SVNRevisionGraphMessages.SVNTeamRevisionGraphPage_Path_Label, SVNRevisionGraphMessages.SVNTeamRevisionGraphPage_Path_Field, SVNRevisionGraphMessages.SVNTeamRevisionGraphPage_Path_BrowseDialogTitle, SVNRevisionGraphMessages.SVNTeamRevisionGraphPage_Path_BrowseDialogDescription, true, (Composite)group, (IValidationManager)this);
        data = new GridData(768);
        this.pathSelectionComposite.setLayoutData((Object)data);
    }

    protected void initializeControls() {
        Object[] caches;
        List list = this.cachesViewer.getList();
        if (list.getItemCount() > 0) {
            list.removeAll();
        }
        if ((caches = this.cachesManager.getCaches()).length > 0) {
            this.cachesViewer.add(caches);
        }
        this.skipErrorsButton.setSelection(this.isSkipFetchErrors);
        this.selectionChanged();
    }

    protected void loadDefaultValues(IPreferenceStore store) {
        String path = SVNRevisionGraphPreferences.getDefaultCacheString(store, "directory");
        this.pathSelectionComposite.setSelectedPath(path);
        this.isSkipFetchErrors = true;
    }

    protected void loadValues(IPreferenceStore store) {
        String path = SVNRevisionGraphPreferences.getCacheString(store, "directory");
        this.pathSelectionComposite.setSelectedPath(path);
        this.isSkipFetchErrors = SVNRevisionGraphPreferences.getGraphBoolean(store, "skip.errors");
    }

    protected void saveValues(IPreferenceStore store) {
        SVNRevisionGraphPreferences.setCacheString(store, "directory", this.pathSelectionComposite.getSelectedPath());
        SVNRevisionGraphPreferences.setGraphBoolean(store, "skip.errors", this.isSkipFetchErrors);
    }

    protected void selectionChanged() {
        IStructuredSelection selection = (IStructuredSelection)this.cachesViewer.getSelection();
        int selectionSize = selection.size();
        this.removeButton.setEnabled(selectionSize > 0);
        this.exportButton.setEnabled(selectionSize > 0);
    }

    protected RepositoryCacheInfo[] getSelectedCaches() {
        IStructuredSelection selection = (IStructuredSelection)this.cachesViewer.getSelection();
        Object[] objects = selection.toArray();
        RepositoryCacheInfo[] caches = new RepositoryCacheInfo[objects.length];
        int i = 0;
        while (i < objects.length) {
            caches[i] = (RepositoryCacheInfo)objects[i];
            ++i;
        }
        return caches;
    }

    protected void removeCaches() {
        MessageDialog dlg = new MessageDialog(this.getShell(), SVNRevisionGraphMessages.SVNTeamRevisionGraphPage_RemoveConfirm_Title, null, SVNRevisionGraphMessages.SVNTeamRevisionGraphPage_RemoveConfirm_Description, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0);
        if (dlg.open() == 0) {
            RepositoryCacheInfo[] caches = this.getSelectedCaches();
            this.cachesManager.remove(caches);
        }
    }

    protected void exportCaches() {
        DirectoryDialog fileDialog = new DirectoryDialog(this.getShell());
        fileDialog.setText(SVNRevisionGraphMessages.SVNTeamRevisionGraphPage_ExportTitle);
        fileDialog.setMessage(SVNRevisionGraphMessages.SVNTeamRevisionGraphPage_ExportDescription);
        String path = fileDialog.open();
        if (path != null) {
            File destinationFolder = new File(path);
            RepositoryCacheInfo[] caches = this.getSelectedCaches();
            this.cachesManager.export(destinationFolder, caches);
        }
    }

    protected void importCaches() {
        DirectoryDialog fileDialog = new DirectoryDialog(this.getShell());
        fileDialog.setText(SVNRevisionGraphMessages.SVNTeamRevisionGraphPage_ImportTitle);
        fileDialog.setMessage(SVNRevisionGraphMessages.SVNTeamRevisionGraphPage_ImportDescription);
        String path = fileDialog.open();
        if (path != null) {
            File cacheData = new File(path);
            this.cachesManager.importCache(cacheData);
        }
    }

    public void dispose() {
        this.cachesManager.removeListener(this);
        super.dispose();
    }

    public void propertyChange(PropertyChangeEvent event) {
        UIMonitorUtility.getDisplay().syncExec(new Runnable(){

            public void run() {
                SVNTeamRevisionGraphPage.this.initializeControls();
            }
        });
    }
}

