/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.console;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.WorkbenchEncoding;
import org.eclipse.ui.console.IConsoleDocumentPartitioner;
import org.eclipse.ui.console.IConsoleView;
import org.eclipse.ui.console.IOConsoleInputStream;
import org.eclipse.ui.console.IOConsoleOutputStream;
import org.eclipse.ui.console.TextConsole;
import org.eclipse.ui.internal.console.IOConsolePage;
import org.eclipse.ui.internal.console.IOConsolePartitioner;
import org.eclipse.ui.part.IPageBookViewPage;

public class IOConsole
extends TextConsole {
    private IOConsolePartitioner partitioner;
    private InputStream inputStream;
    private List<Closeable> openStreams = Collections.synchronizedList(new ArrayList());
    private Charset charset;

    public IOConsole(String name, String consoleType, ImageDescriptor imageDescriptor, boolean autoLifecycle) {
        this(name, consoleType, imageDescriptor, (String)null, autoLifecycle);
    }

    public IOConsole(String name, String consoleType, ImageDescriptor imageDescriptor, String encoding, boolean autoLifecycle) {
        this(name, consoleType, imageDescriptor, encoding == null ? Charset.forName(WorkbenchEncoding.getWorkbenchDefaultEncoding()) : Charset.forName(encoding), autoLifecycle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IOConsole(String name, String consoleType, ImageDescriptor imageDescriptor, Charset charset, boolean autoLifecycle) {
        super(name, consoleType, imageDescriptor, autoLifecycle);
        this.charset = charset;
        List<Closeable> list = this.openStreams;
        synchronized (list) {
            this.inputStream = new IOConsoleInputStream(this);
            this.openStreams.add(this.inputStream);
        }
        if (this.inputStream instanceof IOConsoleInputStream) {
            this.partitioner = new IOConsolePartitioner((IOConsoleInputStream)this.inputStream, this);
            this.partitioner.connect(this.getDocument());
        }
    }

    public IOConsole(String name, String consoleType, ImageDescriptor imageDescriptor) {
        this(name, consoleType, imageDescriptor, true);
    }

    public IOConsole(String name, ImageDescriptor imageDescriptor) {
        this(name, null, imageDescriptor);
    }

    @Override
    public IPageBookViewPage createPage(IConsoleView view) {
        return new IOConsolePage(this, view);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IOConsoleOutputStream newOutputStream() {
        IOConsoleOutputStream outputStream = new IOConsoleOutputStream(this, this.charset);
        List<Closeable> list = this.openStreams;
        synchronized (list) {
            this.openStreams.add(outputStream);
        }
        return outputStream;
    }

    public IOConsoleInputStream getInputStream() {
        if (this.inputStream instanceof IOConsoleInputStream) {
            return (IOConsoleInputStream)this.inputStream;
        }
        return null;
    }

    public void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    @Override
    protected IConsoleDocumentPartitioner getPartitioner() {
        return this.partitioner;
    }

    public int getHighWaterMark() {
        return this.partitioner.getHighWaterMark();
    }

    public int getLowWaterMark() {
        return this.partitioner.getLowWaterMark();
    }

    public void setWaterMarks(int low, int high) {
        if (low >= 0 && low >= high) {
            throw new IllegalArgumentException("High water mark must be greater than low water mark");
        }
        this.partitioner.setWaterMarks(low, high);
    }

    private void checkFinished() {
        if (this.openStreams.isEmpty()) {
            this.partitioner.streamsClosed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void streamClosed(IOConsoleOutputStream stream) {
        List<Closeable> list = this.openStreams;
        synchronized (list) {
            this.openStreams.remove(stream);
            this.checkFinished();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void streamClosed(IOConsoleInputStream stream) {
        List<Closeable> list = this.openStreams;
        synchronized (list) {
            this.openStreams.remove(stream);
            this.checkFinished();
        }
    }

    @Override
    public void clearConsole() {
        if (this.partitioner != null) {
            this.partitioner.clearBuffer();
        }
    }

    @Override
    protected void dispose() {
        super.dispose();
        this.partitioner.disconnect();
        ArrayList<Closeable> list = new ArrayList<Closeable>(this.openStreams);
        for (Closeable closable : list) {
            try {
                closable.close();
            }
            catch (IOException iOException) {}
        }
        this.inputStream = null;
    }

    public String getEncoding() {
        return this.charset.name();
    }

    public Charset getCharset() {
        return this.charset;
    }
}

