/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.branding.wizards;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.internal.junit.ui.JUnitPlugin;
import org.eclipse.jdt.internal.junit.wizards.JUnitWizard;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.m2e.core.MavenPlugin;
import org.fusesource.ide.branding.Activator;
import org.fusesource.ide.branding.wizards.NewCamelTestWizardPageOne;
import org.fusesource.ide.branding.wizards.NewCamelTestWizardPageTwo;
import org.fusesource.ide.branding.wizards.WizardMessages;
import org.fusesource.ide.camel.model.service.core.util.CamelMavenUtils;
import org.fusesource.ide.foundation.core.contenttype.BlueprintXmlMatchingStrategy;
import org.fusesource.ide.foundation.core.contenttype.XmlMatchingStrategySupport;

public class NewCamelTestWizard
extends JUnitWizard {
    private static final String CAMEL_GROUP_ID = "org.apache.camel";
    private static final String CAMEL_ARTIFACT_ID_WILDCARD = "camel-";
    private static final String CAMEL_SPRING_TEST_ARTIFACT_ID = "camel-test-spring";
    private static final String CAMEL_BP_TEST_ARTIFACT_ID = "camel-test-blueprint";
    private static final String CAMEL_TEST_SCOPE = "test";
    private String camelVersion = null;
    private XmlMatchingStrategySupport blueprintXmlMatcher = new BlueprintXmlMatchingStrategy();
    private NewCamelTestWizardPageOne fPage1;

    public NewCamelTestWizard() {
        this.setWindowTitle(WizardMessages.Wizard_title_new_testcase);
        this.setDefaultPageImageDescriptor(ImageDescriptor.createFromFile(((Object)((Object)this)).getClass(), (String)"/icons/new_camel_test_case_wizard.png"));
        this.initDialogSettings();
    }

    public void addPages() {
        super.addPages();
        NewCamelTestWizardPageTwo fPage2 = new NewCamelTestWizardPageTwo();
        this.fPage1 = new NewCamelTestWizardPageOne(this, fPage2);
        this.addPage((IWizardPage)this.fPage1);
        this.addPage((IWizardPage)fPage2);
        this.fPage1.init(this.getSelection());
    }

    protected void initializeDefaultPageImageDescriptor() {
        this.setDefaultPageImageDescriptor(JUnitPlugin.getImageDescriptor((String)"wizban/newtest_wiz.png"));
    }

    public boolean performFinish() {
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)WizardMessages.NewTestCaseCreationWizard_create_progress, (int)2);
                NewCamelTestWizard.this.fPage1.superClassChanged();
                subMonitor.setWorkRemaining(1);
                try {
                    NewCamelTestWizard.this.fPage1.createType((IProgressMonitor)subMonitor.split(1));
                }
                catch (Exception ex) {
                    Activator.getLogger().error((Throwable)ex);
                }
            }
        };
        this.finishPage(runnable);
        IJavaProject project = this.fPage1.getJavaProject();
        runnable = this.fPage1.getRunnable();
        try {
            runnable = this.addCamelTestToPomDeps(project, runnable);
        }
        catch (Exception exception) {
            return false;
        }
        if (this.finishPage(runnable)) {
            IType newClass = this.fPage1.getCreatedType();
            if (newClass == null) {
                return false;
            }
            IResource resource = newClass.getCompilationUnit().getResource();
            if (resource != null) {
                this.selectAndReveal(resource);
                this.openResource(resource);
            }
            return true;
        }
        return false;
    }

    public boolean isBlueprintFile(String filePath) {
        String rawPath;
        Path f;
        File nf;
        boolean isBlueprint = false;
        if (filePath != null && filePath.trim().length() > 0 && (nf = new File((f = new Path(rawPath = filePath.startsWith("file:") ? filePath.substring(5) : filePath)).toOSString())).exists() && nf.isFile()) {
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(f.makeRelativeTo(ResourcesPlugin.getWorkspace().getRoot().getLocation()));
            isBlueprint = this.blueprintXmlMatcher.matches(file);
        }
        return isBlueprint;
    }

    private IRunnableWithProgress addCamelTestToPomDeps(final IJavaProject project, final IRunnableWithProgress runnable) {
        return new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                block22: {
                    SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)WizardMessages.NewTestCaseCreationWizard_create_progress, (int)4);
                    IPath pomPathValue = project.getProject().getRawLocation() != null ? project.getProject().getRawLocation().append("pom.xml") : ResourcesPlugin.getWorkspace().getRoot().getLocation().append(project.getPath().append("pom.xml"));
                    String pomPath = pomPathValue.toOSString();
                    File pomFile = new File(pomPath);
                    try {
                        try {
                            Object dep;
                            Model model = new CamelMavenUtils().getMavenModel(project.getProject());
                            boolean isBlueprint = NewCamelTestWizard.this.isBlueprintFile(NewCamelTestWizard.this.fPage1.getXmlFileUnderTest().getLocationURI().toString());
                            boolean hasCamelSpringTestDep = false;
                            boolean hasCamelBPTestDep = false;
                            List deps = model.getDependencies();
                            for (Dependency dep2 : deps) {
                                if (dep2.getArtifactId().startsWith(NewCamelTestWizard.CAMEL_ARTIFACT_ID_WILDCARD) && dep2.getGroupId().equalsIgnoreCase(NewCamelTestWizard.CAMEL_GROUP_ID) && NewCamelTestWizard.this.camelVersion == null) {
                                    NewCamelTestWizard.this.camelVersion = dep2.getVersion();
                                }
                                if (!isBlueprint && dep2.getArtifactId().equalsIgnoreCase(NewCamelTestWizard.CAMEL_SPRING_TEST_ARTIFACT_ID)) {
                                    hasCamelSpringTestDep = true;
                                    break;
                                }
                                if (!isBlueprint || !dep2.getArtifactId().equalsIgnoreCase(NewCamelTestWizard.CAMEL_BP_TEST_ARTIFACT_ID)) continue;
                                hasCamelBPTestDep = true;
                                break;
                            }
                            boolean changes = false;
                            if (!isBlueprint && !hasCamelSpringTestDep) {
                                dep = new Dependency();
                                dep.setGroupId(NewCamelTestWizard.CAMEL_GROUP_ID);
                                dep.setArtifactId(NewCamelTestWizard.CAMEL_SPRING_TEST_ARTIFACT_ID);
                                dep.setVersion(NewCamelTestWizard.this.camelVersion);
                                dep.setScope(NewCamelTestWizard.CAMEL_TEST_SCOPE);
                                model.addDependency((Dependency)dep);
                                changes = true;
                            }
                            if (isBlueprint && !hasCamelBPTestDep) {
                                dep = new Dependency();
                                dep.setGroupId(NewCamelTestWizard.CAMEL_GROUP_ID);
                                dep.setArtifactId(NewCamelTestWizard.CAMEL_BP_TEST_ARTIFACT_ID);
                                dep.setVersion(NewCamelTestWizard.this.camelVersion);
                                dep.setScope(NewCamelTestWizard.CAMEL_TEST_SCOPE);
                                model.addDependency((Dependency)dep);
                                changes = true;
                            }
                            subMonitor.setWorkRemaining(3);
                            if (!changes) break block22;
                            try {
                                dep = null;
                                Object var13_17 = null;
                                try (BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(pomFile));){
                                    MavenPlugin.getMaven().writeModel(model, (OutputStream)os);
                                    IFile pomIFile = project.getProject().getFile("pom.xml");
                                    if (pomIFile != null) {
                                        pomIFile.refreshLocal(2, (IProgressMonitor)subMonitor.split(1));
                                    }
                                    subMonitor.setWorkRemaining(2);
                                    runnable.run((IProgressMonitor)subMonitor.split(2));
                                }
                                catch (Throwable throwable) {
                                    if (dep == null) {
                                        dep = throwable;
                                    } else if (dep != throwable) {
                                        ((Throwable)dep).addSuppressed(throwable);
                                    }
                                    throw dep;
                                }
                            }
                            catch (Exception ex) {
                                Activator.getLogger().error((Throwable)ex);
                            }
                        }
                        catch (Exception ex) {
                            Activator.getLogger().error((Throwable)ex);
                            subMonitor.setWorkRemaining(0);
                        }
                    }
                    finally {
                        subMonitor.setWorkRemaining(0);
                    }
                }
            }
        };
    }
}

