/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.editor.behaviours;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.URI;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.ui.editor.DefaultPersistencyBehavior;
import org.eclipse.graphiti.ui.editor.DiagramBehavior;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.fusesource.ide.camel.editor.CamelDesignEditor;
import org.fusesource.ide.camel.editor.commands.ImportCamelContextElementsCommand;
import org.fusesource.ide.camel.editor.internal.CamelEditorUIActivator;
import org.fusesource.ide.camel.model.service.core.io.CamelIOHandler;
import org.fusesource.ide.camel.model.service.core.model.AbstractCamelModelElement;
import org.fusesource.ide.camel.model.service.core.model.CamelFile;
import org.fusesource.ide.camel.model.service.core.model.CamelModelElementIDUtil;
import org.fusesource.ide.camel.model.service.core.model.CamelRouteContainerElement;

public class CamelPersistencyBehaviour
extends DefaultPersistencyBehavior {
    private CamelDesignEditor editor;
    private CamelFile camelFile;

    public CamelPersistencyBehaviour(CamelDesignEditor editor) {
        super((DiagramBehavior)editor.getDiagramBehavior());
        this.editor = editor;
    }

    public Diagram loadDiagram(URI uri) {
        if (!this.loadModel(this.editor.getEditorInput())) {
            return null;
        }
        ImportCamelContextElementsCommand importCommand = new ImportCamelContextElementsCommand(this.editor, this.editor.getEditingDomain(), this.editor.getModel());
        this.editor.getEditingDomain().getCommandStack().execute((Command)importCommand);
        this.camelFile = this.editor.getModel();
        this.editor.getParent().onFileLoading(this.camelFile.getResource().getName());
        CamelRouteContainerElement camelContext = this.camelFile.getRouteContainer();
        if (camelContext != null) {
            new CamelModelElementIDUtil().ensureUniqueID((AbstractCamelModelElement)camelContext);
        }
        return importCommand.getDiagram();
    }

    public void saveDiagram(IProgressMonitor monitor) {
        try {
            CamelIOHandler ioHandler = new CamelIOHandler();
            ioHandler.setDocument(this.camelFile.getDocument());
            ioHandler.saveCamelModel(this.camelFile, this.camelFile.getResource(), monitor);
        }
        catch (Exception ex) {
            CamelEditorUIActivator.pluginLog().logError("Unable to save Camel context file: " + this.camelFile.getResource().getRawLocation().toOSString(), (Throwable)ex);
        }
    }

    public boolean loadModel(IEditorInput input) {
        IFileEditorInput fileEditorInput = this.editor.asFileEditorInput(input);
        if (fileEditorInput != null) {
            block4: {
                IFile camelContextFile = fileEditorInput.getFile();
                this.editor.setWorkspaceProject(camelContextFile.getProject());
                try {
                    CamelIOHandler ioHandler = new CamelIOHandler();
                    CamelFile camelModel = ioHandler.loadCamelModel((IResource)camelContextFile, (IProgressMonitor)new NullProgressMonitor());
                    if (camelModel != null) {
                        this.editor.setModel(camelModel);
                        this.camelFile = this.editor.getModel();
                        break block4;
                    }
                    CamelEditorUIActivator.pluginLog().logError("Unable to load Camel context file: " + camelContextFile.getRawLocation().toOSString());
                    return false;
                }
                catch (Exception ex) {
                    CamelEditorUIActivator.pluginLog().logError("Unable to load Camel context file: " + camelContextFile.getRawLocation().toOSString(), (Throwable)ex);
                    return false;
                }
            }
            return true;
        }
        return false;
    }
}

