/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.editor.globalconfiguration.beans;

import java.util.ArrayList;
import java.util.Map;
import java.util.stream.Stream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.internal.ui.wizards.NewClassCreationWizard;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.wizards.NewClassWizardPage;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.fusesource.ide.camel.editor.globalconfiguration.beans.CountingSearchRequestor;
import org.fusesource.ide.camel.editor.globalconfiguration.beans.MethodSelectionDialog;
import org.fusesource.ide.camel.editor.internal.CamelEditorUIActivator;
import org.fusesource.ide.camel.editor.internal.UIMessages;
import org.fusesource.ide.camel.model.service.core.catalog.Parameter;
import org.fusesource.ide.camel.model.service.core.model.AbstractCamelModelElement;
import org.fusesource.ide.camel.model.service.core.model.CamelBean;
import org.fusesource.ide.camel.model.service.core.model.CamelFile;
import org.fusesource.ide.camel.model.service.core.model.GlobalDefinitionCamelModelElement;
import org.fusesource.ide.camel.model.service.core.util.PropertiesUtils;
import org.fusesource.ide.foundation.core.util.Strings;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class BeanConfigUtil {
    private static final String XMLNAMESPACE = "xmlns";

    public String handleNewClassWizard(IProject project, Shell shell, String initialClassName) {
        String value;
        NewClassCreationWizard newClassCreationWizard = new NewClassCreationWizard();
        newClassCreationWizard.init(PlatformUI.getWorkbench(), (IStructuredSelection)new StructuredSelection((Object)project));
        WizardDialog wd = new WizardDialog(shell, (IWizard)newClassCreationWizard);
        wd.create();
        NewClassWizardPage ncwp = (NewClassWizardPage)newClassCreationWizard.getPage("NewClassWizardPage");
        ncwp.setAddComments(true, true);
        if (!Strings.isEmpty((String)initialClassName)) {
            if (initialClassName.indexOf(46) > -1) {
                String packageName = initialClassName.substring(0, initialClassName.lastIndexOf(46));
                String simpleClassName = initialClassName.substring(initialClassName.lastIndexOf(46) + 1);
                ncwp.setTypeName(simpleClassName, true);
                this.setInitialPackageFramentWithName(project, ncwp, packageName);
            } else {
                ncwp.setTypeName(initialClassName, true);
                this.setInitialPackageFrament(project, ncwp);
            }
        } else {
            this.setInitialPackageFrament(project, ncwp);
        }
        if (wd.open() == 0 && (value = ncwp.getCreatedType().getFullyQualifiedName()) != null) {
            return value;
        }
        return null;
    }

    private void setInitialPackageFrament(IProject project, NewClassWizardPage wp) {
        try {
            IJavaProject javaProject = (IJavaProject)project.getNature("org.eclipse.jdt.core.javanature");
            if (javaProject != null) {
                IPackageFragmentRoot fragroot = this.findPackageFragmentRoot(project, javaProject);
                wp.setPackageFragmentRoot(fragroot, true);
                wp.setPackageFragment(PropertiesUtils.getPackage((IJavaProject)javaProject, (IPackageFragmentRoot)fragroot), true);
            }
        }
        catch (Exception ex) {
            CamelEditorUIActivator.pluginLog().logError((Throwable)ex);
        }
    }

    private void setInitialPackageFramentWithName(IProject project, NewClassWizardPage wp, String packName) {
        try {
            IJavaProject javaProject = (IJavaProject)project.getNature("org.eclipse.jdt.core.javanature");
            if (javaProject != null) {
                IPackageFragmentRoot fragroot = this.findPackageFragmentRoot(project, javaProject);
                wp.setPackageFragmentRoot(fragroot, true);
                wp.setPackageFragment(fragroot.getPackageFragment(packName), true);
            }
        }
        catch (Exception ex) {
            CamelEditorUIActivator.pluginLog().logError((Throwable)ex);
        }
    }

    private IPackageFragmentRoot findPackageFragmentRootWithFacade(IProject project, IJavaProject javaProject) {
        IPath[] paths;
        IMavenProjectFacade facade = MavenPlugin.getMavenProjectRegistry().create(project, (IProgressMonitor)new NullProgressMonitor());
        if (facade != null && (paths = facade.getCompileSourceLocations()) != null && paths.length > 0) {
            IPath[] iPathArray = paths;
            int n = paths.length;
            int n2 = 0;
            while (n2 < n) {
                IResource res;
                IPath p = iPathArray[n2];
                if (p != null && (res = project.findMember(p)) != null) {
                    return javaProject.getPackageFragmentRoot(res);
                }
                ++n2;
            }
        }
        return null;
    }

    private IPackageFragmentRoot findPackageFragmentRoot(IProject project, IJavaProject javaProject) throws CoreException {
        IPackageFragmentRoot fromFacade = this.findPackageFragmentRootWithFacade(project, javaProject);
        if (fromFacade != null) {
            return fromFacade;
        }
        IPackageFragmentRoot[] allPackageFragmentRoots = javaProject.getAllPackageFragmentRoots();
        if (allPackageFragmentRoots.length == 1) {
            return allPackageFragmentRoots[0];
        }
        IFolder tstFolder = project.getFolder("src/main/java");
        IPackageFragmentRoot tstRoot = javaProject.getPackageFragmentRoot((IResource)tstFolder);
        if (tstRoot.exists()) {
            return tstRoot;
        }
        tstFolder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
        tstRoot = javaProject.getPackageFragmentRoot((IResource)tstFolder);
        return tstRoot;
    }

    public String handleClassBrowse(IProject project, Shell shell) {
        IJavaSearchScope scope = null;
        if (project != null) {
            IJavaProject jproject = JavaCore.create((IProject)project);
            scope = jproject == null ? SearchEngine.createWorkspaceScope() : SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{jproject});
        }
        try {
            Object[] result;
            SelectionDialog dialog = JavaUI.createTypeDialog((Shell)shell, null, (IJavaSearchScope)scope, (int)2, (boolean)false, (String)"*Bean");
            if (dialog.open() == 0 && (result = dialog.getResult()).length > 0 && result[0] instanceof IType) {
                return ((IType)result[0]).getFullyQualifiedName();
            }
        }
        catch (JavaModelException e) {
            CamelEditorUIActivator.pluginLog().logError((Throwable)e);
        }
        return null;
    }

    private String openStaticOrPublicMethodDialog(IJavaProject jproject, String className, Shell shell) throws JavaModelException {
        IType foundClass = jproject.findType(className);
        if (foundClass != null) {
            return this.openMethodDialog(shell, this.getStaticOrPublicMethods(foundClass), UIMessages.beanConfigUtilSelectStaticPublicMethod);
        }
        return null;
    }

    private IMethod[] getStaticOrPublicMethods(IType foundClass) throws JavaModelException {
        return (IMethod[])Stream.of(foundClass.getMethods()).filter(method -> {
            try {
                return Flags.isStatic((int)method.getFlags()) && Flags.isPublic((int)method.getFlags()) || Flags.isPublic((int)method.getFlags());
            }
            catch (JavaModelException e) {
                CamelEditorUIActivator.pluginLog().logInfo("Issue when testing method for public & static flags.", (Throwable)e);
                return false;
            }
        }).toArray(IMethod[]::new);
    }

    private String openStaticAndPublicMethodDialog(IJavaProject jproject, String className, Shell shell) throws JavaModelException {
        IType foundClass = jproject.findType(className);
        if (foundClass != null) {
            return this.openMethodDialog(shell, this.getStaticPublicMethods(foundClass), UIMessages.beanConfigUtilSelectStaticPublicMethod);
        }
        return null;
    }

    private IMethod[] getStaticPublicMethods(IType foundClass) throws JavaModelException {
        return (IMethod[])Stream.of(foundClass.getMethods()).filter(method -> {
            try {
                return Flags.isStatic((int)method.getFlags()) && Flags.isPublic((int)method.getFlags());
            }
            catch (JavaModelException e) {
                CamelEditorUIActivator.pluginLog().logInfo("Issue when testing method for public & static flags.", (Throwable)e);
                return false;
            }
        }).toArray(IMethod[]::new);
    }

    private IMethod[] getPublicNoArgMethods(IType foundClass) throws JavaModelException {
        return (IMethod[])Stream.of(foundClass.getMethods()).filter(method -> {
            try {
                return this.isPublicNoArgNotConstructorMethod((IMethod)method);
            }
            catch (JavaModelException e) {
                CamelEditorUIActivator.pluginLog().logInfo("Issue when testing method for public & no arguments.", (Throwable)e);
                return false;
            }
        }).toArray(IMethod[]::new);
    }

    protected boolean isPublicNoArgNotConstructorMethod(IMethod method) throws JavaModelException {
        return Flags.isPublic((int)method.getFlags()) && method.getNumberOfParameters() == 0 && !method.isConstructor();
    }

    private IMethod[] getVoidPublicNoArgMethods(IType foundClass) throws JavaModelException {
        return (IMethod[])Stream.of(foundClass.getMethods()).filter(method -> {
            try {
                return this.isPublicNoArgNotConstructorMethod((IMethod)method) && "V".equals(method.getReturnType());
            }
            catch (JavaModelException e) {
                CamelEditorUIActivator.pluginLog().logInfo("Issue when testing method for public void & no arguments.", (Throwable)e);
                return false;
            }
        }).toArray(IMethod[]::new);
    }

    private String openNoArgMethodDialog(IJavaProject jproject, String className, Shell shell) throws JavaModelException {
        IType foundClass = jproject.findType(className);
        if (foundClass != null) {
            return this.openMethodDialog(shell, this.getNoParamMethods(foundClass), UIMessages.beanConfigUtilNoParmMethodSelectionMessage);
        }
        return null;
    }

    private String openPublicNoArgMethodDialog(IJavaProject jproject, String className, Shell shell) throws JavaModelException {
        IType foundClass = jproject.findType(className);
        if (foundClass != null) {
            return this.openMethodDialog(shell, this.getPublicNoArgMethods(foundClass), UIMessages.beanConfigUtilNoParmMethodSelectionMessage);
        }
        return null;
    }

    private String openVoidPublicNoArgMethodDialog(IJavaProject jproject, String className, Shell shell) throws JavaModelException {
        IType foundClass = jproject.findType(className);
        if (foundClass != null) {
            return this.openMethodDialog(shell, this.getVoidPublicNoArgMethods(foundClass), UIMessages.beanConfigUtilNoParmAndVoidMethodSelectionMessage);
        }
        return null;
    }

    private String openMethodDialog(Shell shell, IMethod[] methods, String dialogMessage) {
        MethodSelectionDialog dialog = new MethodSelectionDialog(shell, (ILabelProvider)new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT));
        dialog.setTitle(UIMessages.beanConfigUtilMethodSelectionDialogTitle);
        dialog.setMessage(dialogMessage);
        dialog.setElements(methods);
        dialog.setHelpAvailable(false);
        if (dialog.open() == 0) {
            IMethod result = (IMethod)dialog.getFirstResult();
            return result.getElementName();
        }
        return null;
    }

    private boolean methodIsConstructor(IMethod method) {
        try {
            return method.isConstructor();
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
    }

    private IMethod[] getNoParamMethods(IType foundClass) throws JavaModelException {
        return (IMethod[])Stream.of(foundClass.getMethods()).filter(method -> method.getNumberOfParameters() == 0 && !this.methodIsConstructor((IMethod)method)).toArray(IMethod[]::new);
    }

    private String openMethodDialog(IJavaProject jproject, String className, Shell shell) throws JavaModelException {
        IType foundClass = jproject.findType(className);
        if (foundClass != null) {
            return this.openMethodDialog(shell, this.getPublicNoArgMethods(foundClass), UIMessages.beanConfigUtilMethodSelectionMessage);
        }
        return null;
    }

    public String handleNoArgMethodBrowse(IProject project, String className, Shell shell) {
        IJavaProject jproject;
        if (project != null && (jproject = JavaCore.create((IProject)project)).exists()) {
            try {
                return this.openNoArgMethodDialog(jproject, className, shell);
            }
            catch (JavaModelException e) {
                CamelEditorUIActivator.pluginLog().logError((Throwable)e);
            }
        }
        return null;
    }

    public String handlePublicNoArgMethodBrowse(IProject project, String className, Shell shell) {
        IJavaProject jproject;
        if (project != null && (jproject = JavaCore.create((IProject)project)).exists()) {
            try {
                return this.openPublicNoArgMethodDialog(jproject, className, shell);
            }
            catch (JavaModelException e) {
                CamelEditorUIActivator.pluginLog().logError((Throwable)e);
            }
        }
        return null;
    }

    public String handleVoidPublicNoArgMethodBrowse(IProject project, String className, Shell shell) {
        IJavaProject jproject;
        if (project != null && (jproject = JavaCore.create((IProject)project)).exists()) {
            try {
                return this.openVoidPublicNoArgMethodDialog(jproject, className, shell);
            }
            catch (JavaModelException e) {
                CamelEditorUIActivator.pluginLog().logError((Throwable)e);
            }
        }
        return null;
    }

    public String handleMethodBrowse(IProject project, String className, Shell shell) {
        IJavaProject jproject;
        if (project != null && (jproject = JavaCore.create((IProject)project)).exists()) {
            try {
                return this.openMethodDialog(jproject, className, shell);
            }
            catch (JavaModelException e) {
                CamelEditorUIActivator.pluginLog().logError((Throwable)e);
            }
        }
        return null;
    }

    public String handlePublicOrStaticMethodBrowse(IProject project, String className, Shell shell) {
        IJavaProject jproject;
        if (project != null && (jproject = JavaCore.create((IProject)project)).exists()) {
            try {
                return this.openStaticOrPublicMethodDialog(jproject, className, shell);
            }
            catch (JavaModelException e) {
                CamelEditorUIActivator.pluginLog().logError((Throwable)e);
            }
        }
        return null;
    }

    public String handlePublicAndStaticMethodBrowse(IProject project, String className, Shell shell) {
        IJavaProject jproject;
        if (project != null && (jproject = JavaCore.create((IProject)project)).exists()) {
            try {
                return this.openStaticAndPublicMethodDialog(jproject, className, shell);
            }
            catch (JavaModelException e) {
                CamelEditorUIActivator.pluginLog().logError((Throwable)e);
            }
        }
        return null;
    }

    public Parameter createParameter(String name, String jType) {
        Parameter outParm = new Parameter();
        outParm.setName(name);
        outParm.setJavaType(jType);
        return outParm;
    }

    public boolean hasMethod(String methodName, IType type) {
        if (type == null) {
            return false;
        }
        SearchPattern pattern = SearchPattern.createPattern((String)methodName, (int)1, (int)0, (int)0);
        IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{type});
        CountingSearchRequestor matchCounter = new CountingSearchRequestor();
        SearchEngine search = new SearchEngine();
        try {
            search.search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, scope, (SearchRequestor)matchCounter, null);
        }
        catch (CoreException ce) {
            CamelEditorUIActivator.pluginLog().logError(String.valueOf(UIMessages.beanConfigUtilMethodSelectionErrorNoTypeFound) + ce.getMessage(), (Throwable)ce);
        }
        return matchCounter.getNumMatch() > 0;
    }

    public IJavaProject getJavaProject(IProject project) {
        IJavaProject jproject;
        if (project != null && (jproject = JavaCore.create((IProject)project)).exists()) {
            return jproject;
        }
        return null;
    }

    public Object getAttributeValue(AbstractCamelModelElement element, String attrName) {
        if (element.getXmlNode() != null) {
            return this.getAttributeValue(element.getXmlNode(), attrName);
        }
        return null;
    }

    public Object getAttributeValue(Node element, String attrName) {
        Node attrNode;
        if (element != null && element.hasAttributes() && (attrNode = element.getAttributes().getNamedItem(attrName)) != null) {
            return attrNode.getNodeValue();
        }
        return null;
    }

    public void setAttributeValue(AbstractCamelModelElement element, String attrName, String attrValue) {
        if (element.getXmlNode() != null) {
            this.setAttributeValue(element.getXmlNode(), attrName, attrValue);
        }
    }

    public void setAttributeValue(Node node, String attrName, String attrValue) {
        if (node != null) {
            String oldValueStr;
            Element e = (Element)node;
            Object oldValue = this.getAttributeValue(node, attrName);
            if (oldValue == null && attrValue == null) {
                return;
            }
            if (oldValue != null && attrValue != null && (oldValueStr = (String)oldValue).contentEquals(attrValue)) {
                return;
            }
            if (!Strings.isEmpty((String)attrValue)) {
                e.setAttribute(attrName, attrValue);
            } else {
                e.removeAttribute(attrName);
            }
        }
    }

    public String getNamespace(Node node) {
        if (node != null) {
            String nsURI = node.getNamespaceURI();
            if (nsURI == null && node.getParentNode() != null) {
                return this.getNamespace(node.getParentNode());
            }
            if (nsURI != null) {
                return nsURI;
            }
        }
        return null;
    }

    public boolean isBlueprintConfig(Node node) {
        String nsURI;
        if (node != null && !Strings.isEmpty((String)(nsURI = this.getNamespace(node))) && nsURI != null) {
            return nsURI.contains("blueprint");
        }
        return false;
    }

    public String getArgumentTag(Node node) {
        if (node != null) {
            boolean isBlueprint = this.isBlueprintConfig(node);
            String tagName = isBlueprint ? "argument" : "constructor-arg";
            return tagName;
        }
        return null;
    }

    public String getFactoryBeanTag(Node node) {
        if (node != null) {
            boolean isBlueprint = this.isBlueprintConfig(node);
            String tagName = isBlueprint ? "factory-ref" : "factory-bean";
            return tagName;
        }
        return null;
    }

    public String getArgumentTag(AbstractCamelModelElement camelElement) {
        if (camelElement instanceof CamelFile) {
            return this.getArgumentTag(camelElement.getRouteContainer().getXmlNode());
        }
        if (camelElement != null && camelElement.getXmlNode() != null) {
            return this.getArgumentTag(camelElement.getXmlNode());
        }
        return null;
    }

    public String getFactoryMethodAttribute() {
        return "factory-method";
    }

    public Element createBeanArgument(Element inputElement, String type, String value) {
        String prefixNS = inputElement.getPrefix();
        String tagName = this.getArgumentTag(inputElement);
        Element propertyNode = inputElement.getOwnerDocument().createElementNS(prefixNS, tagName);
        if (!Strings.isEmpty((String)type)) {
            propertyNode.setAttribute("type", type);
        } else {
            propertyNode.removeAttribute("type");
        }
        if (!Strings.isEmpty((String)value)) {
            propertyNode.setAttribute("value", value);
        }
        return propertyNode;
    }

    public Element createBeanArgument(CamelFile camelFile, String type, String value) {
        String prefixNS = camelFile.getRouteContainer().getXmlNode().getPrefix();
        AbstractCamelModelElement newRoot = (AbstractCamelModelElement)camelFile.getChildElements().get(0);
        String tagName = this.getArgumentTag(newRoot);
        Element propertyNode = newRoot.createElement(tagName, prefixNS);
        if (!Strings.isEmpty((String)type)) {
            propertyNode.setAttribute("type", type);
        } else {
            propertyNode.removeAttribute("type");
        }
        if (!Strings.isEmpty((String)value)) {
            propertyNode.setAttribute("value", value);
        }
        return propertyNode;
    }

    public void editBeanArgument(Element xmlElement, String type, String value) {
        this.setAttributeValue(xmlElement, "type", type);
        if (!Strings.isEmpty((String)value)) {
            xmlElement.setAttribute("value", value);
        }
    }

    private String getFirstNSPrefixForURI(Node rootNode, String namespaceUri) {
        NamedNodeMap atts = rootNode.getAttributes();
        int i = 0;
        while (i < atts.getLength()) {
            Node node = atts.item(i);
            String name = node.getNodeName();
            if (namespaceUri.equals(node.getNodeValue()) && name != null && (XMLNAMESPACE.equals(name) || name.startsWith("xmlns:"))) {
                if (name.startsWith("xmlns:")) {
                    return name.substring(name.indexOf(58) + 1);
                }
                return node.getPrefix();
            }
            ++i;
        }
        return null;
    }

    private String getBeanPrefix(Node rootNode) {
        String blueprintPrefix = this.getFirstNSPrefixForURI(rootNode, "http://www.osgi.org/xmlns/blueprint/v1.0.0");
        if (blueprintPrefix != null) {
            return blueprintPrefix;
        }
        String springPrefix = this.getFirstNSPrefixForURI(rootNode, "http://www.springframework.org/schema/beans");
        if (springPrefix != null) {
            return springPrefix;
        }
        return null;
    }

    public Element createBeanNode(CamelFile camelFile, String id, String className) {
        String prefixNS = this.getBeanPrefix(camelFile.getRouteContainer().getXmlNode().getOwnerDocument().getDocumentElement());
        Element newBeanNode = camelFile.createElement("bean", prefixNS);
        newBeanNode.setAttribute("id", id);
        if (!Strings.isBlank((String)className)) {
            newBeanNode.setAttribute("class", className);
        }
        newBeanNode.setAttribute("scope", "singleton");
        return newBeanNode;
    }

    public Element createBeanNode(CamelFile camelFile, String id, String className, String refId) {
        String prefixNS = this.getBeanPrefix(camelFile.getRouteContainer().getXmlNode().getOwnerDocument().getDocumentElement());
        Element newBeanNode = camelFile.createElement("bean", prefixNS);
        newBeanNode.setAttribute("id", id);
        if (!Strings.isBlank((String)className)) {
            newBeanNode.setAttribute("class", className);
        }
        if (!Strings.isBlank((String)refId)) {
            String beanTag = this.getFactoryBeanTag(camelFile.getRouteContainer().getXmlNode().getOwnerDocument().getDocumentElement());
            newBeanNode.setAttribute(beanTag, refId);
        }
        newBeanNode.setAttribute("scope", "singleton");
        return newBeanNode;
    }

    public Element createBeanProperty(String name, String value) {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = dbf.newDocumentBuilder();
            Document doc = builder.newDocument();
            Element propertyNode = doc.createElement("property");
            propertyNode.setAttribute("name", name);
            propertyNode.setAttribute("value", value);
            return propertyNode;
        }
        catch (ParserConfigurationException pse) {
            CamelEditorUIActivator.pluginLog().logError(UIMessages.beanConfigUtilMethodSelectionErrorCreatingXML, (Throwable)pse);
            return null;
        }
    }

    public Element createBeanProperty(CamelFile camelFile, String name, String value) {
        String prefixNS = camelFile.getRouteContainer().getXmlNode().getPrefix();
        AbstractCamelModelElement newRoot = (AbstractCamelModelElement)camelFile.getChildElements().get(0);
        Element propertyNode = newRoot.createElement("property", prefixNS);
        propertyNode.setAttribute("name", name);
        propertyNode.setAttribute("value", value);
        return propertyNode;
    }

    public Element createBeanProperty(Element inputElement, String name, String value) {
        String prefixNS = inputElement.getPrefix();
        Element propertyNode = inputElement.getOwnerDocument().createElementNS(prefixNS, "property");
        propertyNode.setAttribute("name", name);
        propertyNode.setAttribute("value", value);
        return propertyNode;
    }

    public void addBeanArgument(Element beanParent, Element arg) {
        if (arg != null) {
            Element children = (Element)((Object)beanParent.getChildNodes());
            children.appendChild(arg);
        }
    }

    public void addBeanArgument(CamelFile camelFile, Element beanParent, String type, String value) {
        if (!Strings.isBlank((String)value)) {
            Element argument = this.createBeanArgument(camelFile, type, value);
            this.addBeanArgument(beanParent, argument);
        }
    }

    public void addBeanProperty(Element beanParent, Element property) {
        if (property != null) {
            Element children = (Element)((Object)beanParent.getChildNodes());
            children.appendChild(property);
        }
    }

    public void addBeanProperty(CamelFile camelFile, Element beanParent, String name, String value) {
        if (!Strings.isBlank((String)name)) {
            Element property = this.createBeanProperty(camelFile, name, value);
            Element children = (Element)((Object)beanParent.getChildNodes());
            children.appendChild(property);
        }
    }

    public void editBeanProperty(Element xmlElement, String name, String value) {
        this.setAttributeValue(xmlElement, "name", name);
        if (!Strings.isEmpty((String)value)) {
            xmlElement.setAttribute("value", value);
        }
    }

    public String getClassNameFromReferencedCamelBean(AbstractCamelModelElement selectedEP, String refID) {
        Map globalDefs;
        GlobalDefinitionCamelModelElement referencedBean;
        if (!Strings.isEmpty((String)refID) && selectedEP != null && (referencedBean = (GlobalDefinitionCamelModelElement)(globalDefs = selectedEP.getCamelFile().getGlobalDefinitions()).get(refID)) instanceof CamelBean) {
            return ((CamelBean)referencedBean).getClassName();
        }
        return null;
    }

    public String[] removeStringFromStringArray(String[] input, String deleteMe) {
        return (String[])Stream.of(input).filter(item -> !deleteMe.equals(item)).toArray(String[]::new);
    }

    public String[] removeRefsWithNoClassFromArray(String[] input, AbstractCamelModelElement selectedEP) {
        ArrayList<String> result = new ArrayList<String>();
        String[] stringArray = input;
        int n = input.length;
        int n2 = 0;
        while (n2 < n) {
            String item = stringArray[n2];
            String referencedClassName = this.getClassNameFromReferencedCamelBean(selectedEP, item);
            if (!Strings.isEmpty((String)referencedClassName) || Strings.isEmpty((String)item)) {
                result.add(item);
            }
            ++n2;
        }
        return result.toArray(new String[result.size()]);
    }

    public String getBeanRef(AbstractCamelModelElement selectedEP) {
        Object refParm;
        String beanRefTag;
        if (selectedEP != null && (beanRefTag = this.getFactoryBeanTag(selectedEP.getXmlNode())) != null && (refParm = selectedEP.getParameter(beanRefTag)) instanceof String) {
            return (String)refParm;
        }
        return null;
    }
}

