/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.editor.globalconfiguration.beans;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.fusesource.ide.camel.editor.globalconfiguration.beans.AbstractBeanInputDialog;
import org.fusesource.ide.camel.editor.internal.UIMessages;
import org.fusesource.ide.camel.model.service.core.model.AbstractCamelModelElement;
import org.fusesource.ide.foundation.core.util.Strings;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class PropertyInputDialog
extends AbstractBeanInputDialog {
    private String propertyName = null;
    private String initialPropertyName = null;
    private String propertyValue = null;
    private List<AbstractCamelModelElement> propertyList = new ArrayList<AbstractCamelModelElement>();
    private Element inputElement;

    public PropertyInputDialog(Shell parent) {
        super(parent);
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(UIMessages.propertyInputDialogPropertyDialogTitle);
        this.getShell().setText(UIMessages.propertyInputDialogPropertyDialogWindowTitle);
        if (this.isEditDialog()) {
            this.setMessage(UIMessages.propertyInputDialogPropertyDialogEditMessage);
        } else {
            this.setMessage(UIMessages.propertyInputDialogPropertyDialogNewPropertyMessage);
        }
        Composite area = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        area.setLayout((Layout)gridLayout);
        area.setLayoutData((Object)new GridData(1808));
        Text propertyNameText = this.createLabelAndText(area, UIMessages.propertyInputDialogNameFieldLabel);
        if (this.propertyName != null && !this.propertyName.trim().isEmpty()) {
            propertyNameText.setText(this.propertyName);
        }
        propertyNameText.addModifyListener(input -> {
            this.propertyName = propertyNameText.getText().trim();
            this.getButton(0).setEnabled(this.validate());
        });
        Text propertyValueText = this.createLabelAndText(area, UIMessages.propertyInputDialogValueFieldLabel);
        if (this.propertyValue != null && !this.propertyValue.trim().isEmpty()) {
            propertyValueText.setText(this.propertyValue);
        }
        propertyValueText.addModifyListener(input -> {
            this.propertyValue = propertyValueText.getText().trim();
            this.getButton(0).setEnabled(this.validate());
        });
        return area;
    }

    private boolean nameIsUnique(String propName, String newPropName) {
        boolean namesMatch = propName.contentEquals(newPropName);
        if (namesMatch) {
            if (this.initialPropertyName != null) {
                boolean isOldName = this.initialPropertyName.contentEquals(newPropName);
                if (!isOldName) {
                    return false;
                }
            } else {
                return false;
            }
        }
        return true;
    }

    public String validate(String newPropName, String newPropValue) {
        if (Strings.isEmpty((String)newPropName)) {
            return UIMessages.propertyInputDialogErrorNoNameSpecified;
        }
        if (!this.propertyList.isEmpty()) {
            for (AbstractCamelModelElement camelElement : this.propertyList) {
                Element xmlElement = (Element)camelElement.getXmlNode();
                String propName = xmlElement.getAttribute("name");
                boolean nameIsUnique = this.nameIsUnique(propName, newPropName);
                if (nameIsUnique) continue;
                return UIMessages.propertyInputDialogNameNotUnique;
            }
        } else if (this.inputElement != null) {
            NodeList childList = this.inputElement.getElementsByTagName("property");
            int i = 0;
            while (i < childList.getLength()) {
                Element arrayElement = (Element)childList.item(i);
                String propName = arrayElement.getAttribute("name");
                if (!this.nameIsUnique(propName, newPropName)) {
                    return UIMessages.propertyInputDialogNameNotUnique;
                }
                ++i;
            }
        }
        if (Strings.isEmpty((String)newPropValue)) {
            return UIMessages.propertyInputDialogValueNotSpecified;
        }
        return null;
    }

    @Override
    protected boolean validate() {
        this.setErrorMessage(null);
        String newPropName = this.getPropertyName();
        String newPropValue = this.getPropertyValue();
        String msg = this.validate(newPropName, newPropValue);
        if (msg != null) {
            this.setErrorMessage(msg);
        }
        return this.getErrorMessage() == null;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public String getPropertyValue() {
        return this.propertyValue;
    }

    public void setPropertyName(String name) {
        this.propertyName = name;
        this.initialPropertyName = name;
    }

    public void setPropertyValue(String value) {
        this.propertyValue = value;
    }

    public void setPropertyList(List<AbstractCamelModelElement> list) {
        this.propertyList = list;
    }

    public void setInput(Element input) {
        this.inputElement = input;
    }
}

