/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.editor.globalconfiguration.beans.wizards;

import java.util.Set;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.fusesource.ide.camel.editor.component.wizard.ComponentManager;
import org.fusesource.ide.camel.editor.globalconfiguration.beans.BeanConfigUtil;
import org.fusesource.ide.camel.editor.globalconfiguration.beans.wizards.pages.GlobalBeanWizardPage;
import org.fusesource.ide.camel.editor.internal.UIMessages;
import org.fusesource.ide.camel.editor.provider.ext.GlobalConfigurationTypeWizard;
import org.fusesource.ide.camel.model.service.core.catalog.cache.CamelModel;
import org.fusesource.ide.camel.model.service.core.catalog.components.Component;
import org.fusesource.ide.camel.model.service.core.model.AbstractCamelModelElement;
import org.fusesource.ide.camel.model.service.core.model.CamelFile;
import org.w3c.dom.Element;

public class AddGlobalBeanWizard
extends Wizard
implements GlobalConfigurationTypeWizard {
    private DataBindingContext dbc;
    private Element newBeanNode;
    private GlobalBeanWizardPage globalBeanPage;
    private final CamelFile camelFile;
    private ComponentManager componentManager;
    private BeanConfigUtil beanConfigUtil = new BeanConfigUtil();

    public AddGlobalBeanWizard(CamelFile camelFile, CamelModel camelModel) {
        this.camelFile = camelFile;
        this.dbc = new DataBindingContext();
        this.componentManager = new ComponentManager(camelModel);
        this.setWindowTitle(UIMessages.addGlobalBeanWizardWindowTitle);
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        super.addPages();
        this.globalBeanPage = new GlobalBeanWizardPage(this.dbc, UIMessages.addGlobalBeanWizardBeanPageTitle, UIMessages.addGlobalBeanWizardBeanPageMessage, (AbstractCamelModelElement)this.camelFile);
        this.addPage((IWizardPage)this.globalBeanPage);
    }

    @Override
    public Element getGlobalConfigurationElementNode() {
        return this.newBeanNode;
    }

    @Override
    public void setGlobalConfigurationElementNode(Element node) {
        this.newBeanNode = node;
    }

    public Component getComponent() {
        Set<Component> component = this.componentManager.getComponentForTag("bean");
        if (component != null && component instanceof Component) {
            return (Component)component;
        }
        return null;
    }

    public boolean performFinish() {
        Element children;
        this.newBeanNode = this.beanConfigUtil.createBeanNode(this.camelFile, this.globalBeanPage.getId(), this.globalBeanPage.getClassname(), this.globalBeanPage.getBeanRefId());
        if (!this.globalBeanPage.getArgumentsList().isEmpty()) {
            for (AbstractCamelModelElement argument : this.globalBeanPage.getArgumentsList()) {
                children = (Element)((Object)this.newBeanNode.getChildNodes());
                children.appendChild(argument.getXmlNode());
            }
        }
        if (!this.globalBeanPage.getPropertyList().isEmpty()) {
            for (AbstractCamelModelElement property : this.globalBeanPage.getPropertyList()) {
                children = (Element)((Object)this.newBeanNode.getChildNodes());
                children.appendChild(property.getXmlNode());
            }
        }
        this.setGlobalConfigurationElementNode(this.newBeanNode);
        return true;
    }

    public void init() {
        this.setWindowTitle(UIMessages.addGlobalBeanWizardWindowTitle);
        this.setNeedsProgressMonitor(true);
        this.dbc = new DataBindingContext();
    }
}

