/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.editor.globalconfiguration.beans.wizards;

import java.util.Set;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.fusesource.ide.camel.editor.component.wizard.ComponentManager;
import org.fusesource.ide.camel.editor.globalconfiguration.beans.wizards.pages.GlobalBeanEditWizardPage;
import org.fusesource.ide.camel.editor.internal.UIMessages;
import org.fusesource.ide.camel.editor.provider.ext.GlobalConfigurationTypeWizard;
import org.fusesource.ide.camel.model.service.core.catalog.cache.CamelModel;
import org.fusesource.ide.camel.model.service.core.catalog.components.Component;
import org.fusesource.ide.camel.model.service.core.model.AbstractCamelModelElement;
import org.fusesource.ide.camel.model.service.core.model.CamelFile;
import org.w3c.dom.Element;

public class EditGlobalBeanWizard
extends Wizard
implements GlobalConfigurationTypeWizard {
    private DataBindingContext dbc;
    private Element inputNode;
    private ComponentManager componentManager;
    private final CamelFile camelFile;
    private Element updatedNode = null;

    public EditGlobalBeanWizard(CamelFile camelFile, CamelModel camelModel) {
        this.camelFile = camelFile;
        this.dbc = new DataBindingContext();
        this.componentManager = new ComponentManager(camelModel);
        this.setWindowTitle(UIMessages.editGlobalBeanWizardWindowTitle);
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        super.addPages();
        GlobalBeanEditWizardPage globalBeanPage = new GlobalBeanEditWizardPage(this.dbc, UIMessages.editGlobalBeanWizardBeanEditPageTitle, UIMessages.editGlobalBeanWizardBeanEditPageMessage, (AbstractCamelModelElement)this.camelFile);
        globalBeanPage.setElement(this.updatedNode);
        this.addPage((IWizardPage)globalBeanPage);
    }

    @Override
    public Element getGlobalConfigurationElementNode() {
        return this.inputNode;
    }

    @Override
    public void setGlobalConfigurationElementNode(Element node) {
        this.inputNode = node;
        if (this.updatedNode == null) {
            this.updatedNode = (Element)this.inputNode.cloneNode(true);
            this.inputNode.getOwnerDocument().adoptNode(this.updatedNode);
        }
    }

    public Component getComponent() {
        Set<Component> component = this.componentManager.getComponentForTag("bean");
        if (component != null && component instanceof Component) {
            return (Component)component;
        }
        return null;
    }

    public boolean performFinish() {
        Element parentNode = (Element)this.inputNode.getParentNode();
        if (parentNode != null) {
            parentNode.replaceChild(this.updatedNode, this.inputNode);
        }
        this.setGlobalConfigurationElementNode(this.updatedNode);
        return true;
    }

    public boolean performCancel() {
        this.setGlobalConfigurationElementNode(this.inputNode);
        return true;
    }

    public void init() {
        this.setWindowTitle(UIMessages.editGlobalBeanWizardWindowTitle);
        this.setNeedsProgressMonitor(true);
        this.dbc = new DataBindingContext();
    }
}

