/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.editor.globalconfiguration.dataformat.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Composite;
import org.fusesource.ide.camel.editor.globalconfiguration.dataformat.wizards.pages.DataFormatSelectionPage;
import org.fusesource.ide.camel.editor.internal.CamelEditorUIActivator;
import org.fusesource.ide.camel.editor.internal.UIMessages;
import org.fusesource.ide.camel.editor.provider.ext.GlobalConfigurationTypeWizard;
import org.fusesource.ide.camel.editor.utils.MavenUtils;
import org.fusesource.ide.camel.model.service.core.catalog.Parameter;
import org.fusesource.ide.camel.model.service.core.catalog.cache.CamelModel;
import org.fusesource.ide.camel.model.service.core.catalog.dataformats.DataFormat;
import org.fusesource.ide.camel.model.service.core.model.CamelFile;
import org.w3c.dom.Element;

public class NewDataFormatWizard
extends Wizard
implements GlobalConfigurationTypeWizard {
    private CamelModel model;
    private Element dataformatNode;
    private DataFormatSelectionPage dataFormatSelectionPage;
    private DataFormat dataformatSelected;
    private CamelFile camelFile;

    public NewDataFormatWizard(CamelFile camelFile, CamelModel model) {
        this.model = model;
        this.camelFile = camelFile;
        this.setNeedsProgressMonitor(true);
    }

    public void createPageControls(Composite pageContainer) {
        super.createPageControls(pageContainer);
        this.setWindowTitle(UIMessages.newGlobalConfigurationTypeDataFormatWizardDialogTitle);
    }

    public void addPages() {
        super.addPages();
        this.dataFormatSelectionPage = new DataFormatSelectionPage(this.model);
        this.addPage((IWizardPage)this.dataFormatSelectionPage);
    }

    public boolean performCancel() {
        this.dataformatNode = null;
        return super.performCancel();
    }

    public boolean performFinish() {
        try {
            this.getContainer().run(false, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    NewDataFormatWizard.this.dataformatSelected = NewDataFormatWizard.this.dataFormatSelectionPage.getDataFormatSelected();
                    NewDataFormatWizard.this.dataformatNode = NewDataFormatWizard.this.createDataFormatNode(NewDataFormatWizard.this.dataformatSelected, NewDataFormatWizard.this.dataFormatSelectionPage.getId(), monitor);
                }
            });
        }
        catch (InterruptedException | InvocationTargetException e) {
            CamelEditorUIActivator.pluginLog().logError((Throwable)e);
        }
        return true;
    }

    public Element createDataFormatNode(DataFormat dataformat, String id, IProgressMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        String prefixNS = this.camelFile.getRouteContainer().getXmlNode().getPrefix();
        Element newDataformatNode = this.camelFile.createElement(dataformat.getModelName(), prefixNS);
        newDataformatNode.setAttribute("id", id);
        for (Parameter parameter : dataformat.getParameters()) {
            String defaultValue = parameter.getDefaultValue();
            if (defaultValue == null) continue;
            newDataformatNode.setAttribute(parameter.getName(), defaultValue);
        }
        subMonitor.worked(1);
        List dependencies = dataformat.getDependencies();
        MavenUtils utils = new MavenUtils();
        utils.updateMavenDependencies(dependencies, this.camelFile.getResource().getProject(), (IProgressMonitor)subMonitor.split(1));
        return newDataformatNode;
    }

    @Override
    public Element getGlobalConfigurationElementNode() {
        return this.dataformatNode;
    }

    @Override
    public void setGlobalConfigurationElementNode(Element node) {
        this.dataformatNode = node;
    }
}

