/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.editor.globalconfiguration.dataformat.wizards.pages;

import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.beans.PojoProperties;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationSupport;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.viewers.ViewerProperties;
import org.eclipse.jface.databinding.wizard.WizardPageSupport;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.fusesource.ide.camel.editor.globalconfiguration.dataformat.wizards.pages.DataFormatLabelProvider;
import org.fusesource.ide.camel.editor.internal.UIMessages;
import org.fusesource.ide.camel.model.service.core.catalog.cache.CamelModel;
import org.fusesource.ide.camel.model.service.core.catalog.dataformats.DataFormat;

public class DataFormatSelectionPage
extends WizardPage {
    private CamelModel model;
    private DataFormat dataFormatSelected;
    private String id;
    private DataBindingContext dbc;

    public DataFormatSelectionPage(CamelModel model) {
        super("Dataformat selection page");
        this.setTitle(UIMessages.dataFormatSelectionPageDataFormatSelectionPageTitle);
        this.setDescription(UIMessages.dataFormatSelectionPageDataFormatSelectionPageDescription);
        this.model = model;
        this.dbc = new DataBindingContext();
    }

    public void createControl(Composite parent) {
        GridLayout gl = new GridLayout(2, false);
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)gl);
        this.createDataFormatSelectionLine(container);
        this.createIdLine(container);
        this.setControl((Control)container);
        WizardPageSupport.create((WizardPage)this, (DataBindingContext)this.dbc);
    }

    private void createDataFormatSelectionLine(Composite container) {
        Label l = new Label(container, 0);
        l.setText(UIMessages.dataFormatSelectionPageDataformatLabel);
        l.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 1, 1));
        ComboViewer dataformatComboViewer = new ComboViewer(container, 2060);
        dataformatComboViewer.getControl().setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        dataformatComboViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        dataformatComboViewer.setLabelProvider((IBaseLabelProvider)new DataFormatLabelProvider());
        dataformatComboViewer.setComparator(new ViewerComparator());
        dataformatComboViewer.setInput((Object)this.model.getDataFormats().toArray());
        this.dbc.bindValue((IObservableValue)ViewerProperties.singleSelection().observe((Viewer)dataformatComboViewer), PojoProperties.value(DataFormatSelectionPage.class, (String)"dataFormatSelected", DataFormat.class).observe((Object)this));
        dataformatComboViewer.setSelection((ISelection)new StructuredSelection(dataformatComboViewer.getElementAt(0)));
    }

    private void createIdLine(Composite container) {
        Label l_id = new Label(container, 0);
        l_id.setText(UIMessages.dataFormatSelectionPageIdLabel);
        l_id.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 1, 1));
        Text txt_id = new Text(container, 2048);
        txt_id.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        UpdateValueStrategy strategy = new UpdateValueStrategy();
        strategy.setBeforeSetValidator(new IValidator(){

            public IStatus validate(Object value) {
                String id = (String)value;
                if (id == null || id.isEmpty()) {
                    return ValidationStatus.error((String)UIMessages.globalEndpointWizardPageIdMandatoryMessage);
                }
                return ValidationStatus.ok();
            }
        });
        IObservableValue idObservable = PojoProperties.value(DataFormatSelectionPage.class, (String)"id", String.class).observe((Object)this);
        Binding binding = this.dbc.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)txt_id), idObservable, strategy, null);
        ControlDecorationSupport.create((ValidationStatusProvider)binding, (int)16512);
    }

    public DataFormat getDataFormatSelected() {
        return this.dataFormatSelected;
    }

    public void setDataFormatSelected(DataFormat dataFormatSelected) {
        this.dataFormatSelected = dataFormatSelected;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }
}

