/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.editor.globalconfiguration.endpoint.provider;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.fusesource.ide.camel.editor.globalconfiguration.endpoint.wizards.AddGlobalEndpointWizard;
import org.fusesource.ide.camel.editor.provider.ext.GlobalConfigElementType;
import org.fusesource.ide.camel.editor.provider.ext.GlobalConfigurationTypeWizard;
import org.fusesource.ide.camel.editor.provider.ext.ICustomGlobalConfigElementContribution;
import org.fusesource.ide.camel.model.service.core.catalog.Dependency;
import org.fusesource.ide.camel.model.service.core.catalog.cache.CamelCatalogCacheManager;
import org.fusesource.ide.camel.model.service.core.catalog.cache.CamelModel;
import org.fusesource.ide.camel.model.service.core.catalog.components.Component;
import org.fusesource.ide.camel.model.service.core.model.AbstractCamelModelElement;
import org.fusesource.ide.camel.model.service.core.model.CamelFile;
import org.fusesource.ide.foundation.core.util.CamelUtils;
import org.w3c.dom.Node;

public class GlobalEndpointContributor
implements ICustomGlobalConfigElementContribution {
    private static final String ENDPOINT = "endpoint";
    private AddGlobalEndpointWizard wizard = null;

    @Override
    public GlobalConfigurationTypeWizard createGlobalElement(CamelFile camelFile) {
        IProject project = camelFile.getResource().getProject();
        CamelModel camelModel = CamelCatalogCacheManager.getInstance().getCamelModelForProject(project);
        this.wizard = new AddGlobalEndpointWizard(camelFile, camelModel);
        return this.wizard;
    }

    @Override
    public GlobalConfigurationTypeWizard modifyGlobalElement(CamelFile camelFile) {
        return null;
    }

    @Override
    public List<Dependency> getElementDependencies() {
        Component component;
        if (this.wizard != null && (component = this.wizard.getComponent()) != null) {
            return component.getDependencies();
        }
        return Collections.emptyList();
    }

    @Override
    public void onGlobalElementDeleted(AbstractCamelModelElement camelModelElement) {
    }

    @Override
    public boolean canHandle(AbstractCamelModelElement camelModelElementToHandle) {
        return CamelUtils.getTagNameWithoutPrefix((Node)camelModelElementToHandle.getXmlNode()).equalsIgnoreCase(ENDPOINT);
    }

    @Override
    public GlobalConfigElementType getGlobalConfigElementType() {
        return GlobalConfigElementType.CONTEXT_ENDPOINT;
    }
}

