/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.editor.internal;

import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.fusesource.ide.camel.editor.utils.IPrefersPerspective;

public class PreferredPerspectivePartListener
implements IStartup,
IPartListener {
    public void partActivated(IWorkbenchPart part) {
        PreferredPerspectivePartListener.refresh(part);
    }

    public static void refresh(IWorkbenchPart part) {
        if (!(part instanceof IPrefersPerspective)) {
            return;
        }
        final IWorkbenchWindow workbenchWindow = part.getSite().getPage().getWorkbenchWindow();
        IPerspectiveDescriptor activePerspective = workbenchWindow.getActivePage().getPerspective();
        final String preferredPerspectiveId = ((IPrefersPerspective)part).getPreferredPerspectiveId();
        if (preferredPerspectiveId == null) {
            return;
        }
        if (activePerspective == null || !activePerspective.getId().equals(preferredPerspectiveId)) {
            Display.getCurrent().asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        workbenchWindow.getWorkbench().showPerspective(preferredPerspectiveId, workbenchWindow);
                    }
                    catch (WorkbenchException workbenchException) {}
                }
            });
        }
    }

    public void partBroughtToTop(IWorkbenchPart arg0) {
    }

    public void partClosed(IWorkbenchPart arg0) {
    }

    public void partDeactivated(IWorkbenchPart arg0) {
    }

    public void partOpened(IWorkbenchPart arg0) {
    }

    public void earlyStartup() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().addPartListener((IPartListener)PreferredPerspectivePartListener.this);
                }
                catch (Exception exception) {}
            }
        });
    }
}

