/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.editor.properties;

import org.eclipse.core.databinding.validation.MultiValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.fusesource.ide.camel.editor.internal.UIMessages;

public final class BeanRefAndClassCrossValidator
extends MultiValidator {
    private ISWTObservableValue classObservable;
    private ISWTObservableValue beanrefObservable;

    public BeanRefAndClassCrossValidator(ISWTObservableValue classObservable, ISWTObservableValue beanrefObservable) {
        this.classObservable = classObservable;
        this.beanrefObservable = beanrefObservable;
    }

    protected IStatus validate() {
        String className = (String)this.classObservable.getValue();
        String beanRef = (String)this.beanrefObservable.getValue();
        if ((className == null || className.isEmpty()) && (beanRef == null || beanRef.isEmpty())) {
            return ValidationStatus.error((String)UIMessages.beanRefClassExistsValidatorBeanClassOrBeanRefRequired);
        }
        if (className != null && !className.isEmpty() && beanRef != null && !beanRef.isEmpty()) {
            return ValidationStatus.error((String)UIMessages.beanRefClassExistsValidatorMustPickEitherBeanRefOrBeanClass);
        }
        return Status.OK_STATUS;
    }
}

