/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.editor.provider;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.graphiti.features.ICreateFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.fusesource.ide.camel.editor.features.create.ext.CreateEndpointFigureFeature;
import org.fusesource.ide.camel.editor.provider.ActiveMQPaletteEntryDependenciesManager;
import org.fusesource.ide.camel.editor.provider.ext.ICustomPaletteEntry;
import org.fusesource.ide.camel.editor.utils.CamelUtils;
import org.fusesource.ide.camel.model.service.core.catalog.Dependency;

public class ActiveMQPaletteEntry
implements ICustomPaletteEntry {
    public static final String ACTIVE_MQ = "ActiveMQ";
    private static final String ORG_APACHE_CAMEL = "org.apache.camel";
    public static final String CAMEL_JMS = "camel-jms";
    public static final String CAMEL_JMS_STARTER = "camel-jms-starter";
    private static final String PROTOCOL = "activemq";

    @Override
    public ICreateFeature newCreateFeature(IFeatureProvider fp) {
        List<Dependency> requiredDependencies = this.getRequiredDependencies(CamelUtils.getRuntimeProvider(fp));
        return new CreateEndpointFigureFeature(fp, ACTIVE_MQ, "Creates an ActiveMQ endpoint...", "activemq:queue:foo", requiredDependencies);
    }

    @Override
    public String getProtocol() {
        return PROTOCOL;
    }

    @Override
    public boolean providesProtocol(String protocol) {
        return PROTOCOL.equalsIgnoreCase(protocol);
    }

    @Override
    public List<Dependency> getRequiredDependencies(String runtimeProvider) {
        ArrayList<Dependency> deps = new ArrayList<Dependency>();
        deps.add(this.createActiveMQDependency(runtimeProvider));
        deps.add(this.createJMSDependency(runtimeProvider));
        return deps;
    }

    private Dependency createJMSDependency(String runtimeProvider) {
        return this.createDependency(ORG_APACHE_CAMEL, this.computeJMSArtifactId(runtimeProvider), this.getCurrentProjectCamelVersion());
    }

    private String computeJMSArtifactId(String runtimeProvider) {
        if ("springboot".equals(runtimeProvider)) {
            return CAMEL_JMS_STARTER;
        }
        return CAMEL_JMS;
    }

    private Dependency createActiveMQDependency(String runtimeProvider) {
        ActiveMQPaletteEntryDependenciesManager activeMQPaletteEntryDependenciesManager = new ActiveMQPaletteEntryDependenciesManager();
        return this.createDependency("org.apache.activemq", activeMQPaletteEntryDependenciesManager.getArtifactId(runtimeProvider), activeMQPaletteEntryDependenciesManager.getActiveMQVersion(this.getCurrentProjectCamelVersion()));
    }

    String getCurrentProjectCamelVersion() {
        return CamelUtils.getCurrentProjectCamelVersion();
    }

    private Dependency createDependency(String groupId, String artifactId, String version) {
        Dependency dep = new Dependency();
        dep.setGroupId(groupId);
        dep.setArtifactId(artifactId);
        dep.setVersion(version);
        return dep;
    }

    @Override
    public boolean isValid(String runtimeProvider) {
        return true;
    }
}

