/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.editor.utils;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorMatchingStrategy;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.FileEditorInput;
import org.fusesource.ide.camel.editor.internal.CamelEditorUIActivator;
import org.fusesource.ide.foundation.ui.io.CamelXMLEditorInput;

public class CamelEditorMatchingStrategy
implements IEditorMatchingStrategy {
    public boolean matches(IEditorReference editorRef, IEditorInput input) {
        CamelXMLEditorInput toBeOpenedInput;
        IEditorInput editorInput = null;
        try {
            editorInput = editorRef.getEditorInput();
        }
        catch (PartInitException ex) {
            CamelEditorUIActivator.pluginLog().logError((Throwable)ex);
        }
        if (editorInput == null || input == null) {
            return false;
        }
        if (!(editorInput instanceof CamelXMLEditorInput)) {
            return false;
        }
        CamelXMLEditorInput currentOpenInput = (CamelXMLEditorInput)editorInput;
        if (input instanceof CamelXMLEditorInput) {
            toBeOpenedInput = (CamelXMLEditorInput)input;
        } else if (input instanceof FileEditorInput) {
            FileEditorInput fei = (FileEditorInput)input;
            toBeOpenedInput = new CamelXMLEditorInput(fei.getFile(), null);
        } else {
            return false;
        }
        IFile currentInputCamelContextFile = currentOpenInput.getCamelContextFile();
        IFile toBeOpenedInputCamelContextFile = toBeOpenedInput.getCamelContextFile();
        if (currentInputCamelContextFile != null && toBeOpenedInputCamelContextFile != null) {
            IPath currentEditorInputCamelContextFileLocation = currentInputCamelContextFile.getLocation();
            IPath tobOpenedEditorInputCamelContextFileLocation = toBeOpenedInputCamelContextFile.getLocation();
            if (currentEditorInputCamelContextFileLocation != null && tobOpenedEditorInputCamelContextFileLocation != null) {
                return currentEditorInputCamelContextFileLocation.toOSString().equals(tobOpenedEditorInputCamelContextFileLocation.toOSString());
            }
        }
        return false;
    }
}

