/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.editor.utils;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.Resource;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.m2e.core.MavenPlugin;
import org.fusesource.ide.camel.editor.internal.CamelEditorUIActivator;
import org.fusesource.ide.camel.editor.internal.UIMessages;
import org.fusesource.ide.camel.editor.utils.BuildAndRefreshJobWaiterUtil;
import org.fusesource.ide.camel.editor.utils.CamelUtils;
import org.fusesource.ide.camel.model.service.core.catalog.Dependency;
import org.fusesource.ide.camel.model.service.core.util.CamelMavenUtils;
import org.fusesource.ide.foundation.ui.util.Shells;

public class MavenUtils {
    private static final String SYNDESIS_PLUGIN_GROUPID = "io.syndesis";
    private static final String SYNDESIS_PLUGIN_ARTIFACTID = "syndesis-maven-plugin";
    private static final String CAMEL_GROUP_ID = "org.apache.camel";
    private static final String CAMEL_CORE_ARTIFACT_ID = "camel-core";
    private static final String SCOPE_PROVIDED = "provided";
    private static final String MAIN_PATH = "src/main/";
    public static final String RESOURCES_PATH = "src/main/resources/";
    private static final String JAVA_PATH = "src/main/java/";

    public String javaSourceFolder() {
        String name = new CamelMavenUtils().getMavenModel(CamelUtils.project()).getBuild().getSourceDirectory();
        if (name == null) {
            return JAVA_PATH;
        }
        return name.endsWith("/") ? name : String.valueOf(name) + "/";
    }

    @Deprecated
    public void updateMavenDependencies(List<Dependency> compDeps) {
        IProject project = CamelUtils.project();
        if (project == null) {
            CamelEditorUIActivator.pluginLog().logWarning("Unable to add component dependencies because selected project can't be determined. Maybe this is a remote camel context.");
            return;
        }
        this.updateMavenDependencies(compDeps, project);
    }

    public void updateMavenDependencies(final List<Dependency> compDeps, final IProject project) {
        if (compDeps == null || compDeps.isEmpty()) {
            CamelEditorUIActivator.pluginLog().logWarning("Unable to add component dependencies because no dependencies were specified.");
            return;
        }
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(Shells.getShell());
        try {
            dialog.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)UIMessages.updatePomDependenciesProgressDialogLabel, (int)1);
                    MavenUtils.this.updateMavenDependencies(compDeps, project, (IProgressMonitor)subMonitor.split(1));
                }
            });
        }
        catch (Exception ex) {
            CamelEditorUIActivator.pluginLog().logError((Throwable)ex);
        }
    }

    public void updateMavenDependencies(List<Dependency> compDeps, IProject project, IProgressMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
        CamelMavenUtils cmu = new CamelMavenUtils();
        File pomFile = this.getPomFile(project);
        Model model = cmu.getMavenModel(project);
        List projectDependencies = cmu.getDependencyList(project);
        ArrayList<Dependency> missingDependencies = new ArrayList<Dependency>();
        String scope = this.determineScopeOfCamelCoreDependency(projectDependencies);
        this.determineMissingDependencies(compDeps, projectDependencies, missingDependencies);
        subMonitor.setWorkRemaining(9);
        this.addDependency(model, missingDependencies, scope);
        subMonitor.setWorkRemaining(8);
        if (!missingDependencies.isEmpty()) {
            this.writeNewPomFile(project, pomFile, model, (IProgressMonitor)subMonitor.split(8));
        }
        subMonitor.setWorkRemaining(0);
    }

    private void determineMissingDependencies(List<Dependency> compDeps, List<org.apache.maven.model.Dependency> projectDependencies, List<Dependency> missingDependencies) {
        for (Dependency catalogConnectorDependency : compDeps) {
            boolean found = false;
            for (org.apache.maven.model.Dependency pomDep : projectDependencies) {
                if (!pomDep.getGroupId().equalsIgnoreCase(catalogConnectorDependency.getGroupId()) || !pomDep.getArtifactId().equalsIgnoreCase(catalogConnectorDependency.getArtifactId())) continue;
                if (pomDep.getVersion() == null || !pomDep.getVersion().equalsIgnoreCase(catalogConnectorDependency.getVersion())) {
                    pomDep.setVersion(catalogConnectorDependency.getVersion());
                }
                found = true;
                break;
            }
            if (found) continue;
            missingDependencies.add(catalogConnectorDependency);
        }
    }

    private String determineScopeOfCamelCoreDependency(List<org.apache.maven.model.Dependency> projectDependencies) {
        String scope = null;
        for (org.apache.maven.model.Dependency pomDep : projectDependencies) {
            if (!CAMEL_GROUP_ID.equalsIgnoreCase(pomDep.getGroupId()) || !CAMEL_CORE_ARTIFACT_ID.equalsIgnoreCase(pomDep.getArtifactId()) || !SCOPE_PROVIDED.equalsIgnoreCase(pomDep.getScope())) continue;
            scope = pomDep.getScope();
            break;
        }
        return scope;
    }

    File getPomFile(IProject project) {
        IPath pomPathValue = project.getProject().getRawLocation() != null ? project.getProject().getRawLocation().append("pom.xml") : ResourcesPlugin.getWorkspace().getRoot().getLocation().append(project.getFullPath().append("pom.xml"));
        String pomPath = pomPathValue.toOSString();
        return new File(pomPath);
    }

    public void writeNewPomFile(IProject project, File pomFile, Model model, IProgressMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)3);
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try (BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(pomFile));){
                MavenPlugin.getMaven().writeModel(model, (OutputStream)os);
                subMonitor.worked(1);
                IFile pomIFile2 = project.getProject().getFile("pom.xml");
                if (pomIFile2 != null) {
                    pomIFile2.refreshLocal(2, (IProgressMonitor)subMonitor.split(1));
                    new BuildAndRefreshJobWaiterUtil().waitJob((IProgressMonitor)subMonitor.split(1));
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception ex) {
            CamelEditorUIActivator.pluginLog().logError((Throwable)ex);
        }
    }

    void addDependency(Model model, List<Dependency> missingDeps, String scope) {
        for (Dependency missDep : missingDeps) {
            org.apache.maven.model.Dependency dep = new org.apache.maven.model.Dependency();
            dep.setGroupId(missDep.getGroupId());
            dep.setArtifactId(missDep.getArtifactId());
            dep.setVersion(missDep.getVersion());
            if (scope != null) {
                dep.setScope(scope);
            }
            model.addDependency(dep);
        }
    }

    public void addResourceFolder(IProject project, File pomFile, String resourceFolderName) throws CoreException {
        Model model = new CamelMavenUtils().getMavenModel(project);
        List resources = model.getBuild().getResources();
        boolean exists = false;
        for (Resource resource : resources) {
            if (!resource.getDirectory().equals(resourceFolderName)) continue;
            exists = true;
            break;
        }
        if (!exists) {
            Resource resource;
            resource = new Resource();
            resource.setDirectory(resourceFolderName);
            model.getBuild().addResource(resource);
            try {
                Object object = null;
                Object var9_11 = null;
                try (BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(pomFile));){
                    MavenPlugin.getMaven().writeModel(model, (OutputStream)os);
                    IFile pomIFile = project.getFile("pom.xml");
                    if (pomIFile != null) {
                        pomIFile.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
                    }
                }
                catch (Throwable throwable) {
                    if (object == null) {
                        object = throwable;
                    } else if (object != throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                    throw object;
                }
            }
            catch (Exception ex) {
                CamelEditorUIActivator.pluginLog().logError((Throwable)ex);
            }
        }
    }

    public boolean isSyndesisExtensionProject(IProject project) {
        Model model = new CamelMavenUtils().getMavenModel(project);
        if (model != null) {
            boolean pluginFound = this.isSyndesisPluginDefined(model.getBuild().getPlugins());
            if (!pluginFound && model.getBuild().getPluginManagement() != null) {
                pluginFound = this.isSyndesisPluginDefined(model.getBuild().getPluginManagement().getPlugins());
            }
            if (pluginFound) {
                return true;
            }
        }
        return false;
    }

    public boolean isSyndesisPluginDefined(List<Plugin> plugins) {
        if (plugins != null) {
            for (Plugin p : plugins) {
                if (!SYNDESIS_PLUGIN_GROUPID.equalsIgnoreCase(p.getGroupId()) || !SYNDESIS_PLUGIN_ARTIFACTID.equalsIgnoreCase(p.getArtifactId())) continue;
                return true;
            }
        }
        return false;
    }
}

