/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.camel.model.service.internal;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.camel.catalog.CamelCatalog;
import org.apache.camel.catalog.DefaultCamelCatalog;
import org.apache.camel.catalog.RuntimeProvider;
import org.apache.camel.catalog.TimePatternConverter;
import org.apache.camel.catalog.URISupport;
import org.apache.camel.catalog.VersionManager;
import org.apache.camel.catalog.karaf.KarafRuntimeProvider;
import org.apache.camel.catalog.maven.MavenVersionManager;
import org.apache.camel.catalog.springboot.SpringBootRuntimeProvider;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Repository;
import org.fusesource.ide.camel.model.service.core.CamelSchemaProvider;
import org.fusesource.ide.camel.model.service.core.ICamelManagerService;
import org.fusesource.ide.camel.model.service.core.catalog.cache.CamelCatalogCoordinates;
import org.fusesource.ide.camel.model.service.core.catalog.cache.CamelModel;
import org.fusesource.ide.camel.model.service.core.catalog.components.Component;
import org.fusesource.ide.camel.model.service.core.catalog.dataformats.DataFormat;
import org.fusesource.ide.camel.model.service.core.catalog.eips.Eip;
import org.fusesource.ide.camel.model.service.core.catalog.languages.Language;
import org.fusesource.ide.camel.model.service.core.util.CamelCatalogUtils;
import org.fusesource.ide.camel.model.service.core.util.CamelMavenUtils;
import org.fusesource.ide.camel.model.service.internal.CamelModelPatcher;
import org.fusesource.ide.camel.model.service.internal.CamelServiceImplementationActivator;
import org.jboss.tools.foundation.core.plugin.log.IPluginLog;

public class CamelService
implements ICamelManagerService {
    private static final String OLDER_CAMEL_VERSION_WITH_CATALOG = "2.15.0";
    private static final String OLDER_CAMEL_CATALOG_VERSION_TO_LOAD_IN_CASE_OF_ERROR = "2.15.6";
    private static final boolean ENCODE_DEFAULT = false;
    private Map<CamelCatalogCoordinates, CamelCatalog> cachedCatalogs = new HashMap<CamelCatalogCoordinates, CamelCatalog>();
    private File tempFolder;
    private CamelMavenUtils camelMavenUtils = new CamelMavenUtils();
    private IPluginLog logger;

    public CamelService() {
        this(CamelServiceImplementationActivator.pluginLog());
    }

    public CamelService(IPluginLog logger) {
        try {
            Path grapeFolder = this.getGrapeFolderInsideTempFolder();
            Files.createTempDirectory(grapeFolder, "m2repo", new FileAttribute[0]);
        }
        catch (IOException ex) {
            logger.logError((Throwable)ex);
            this.tempFolder = null;
        }
        this.logger = logger;
    }

    private Path getGrapeFolderInsideTempFolder() throws IOException {
        Path grapeFolder = Paths.get(System.getProperty("java.io.tmpdir"), "grape");
        if (!grapeFolder.toFile().exists()) {
            Files.createDirectory(grapeFolder, new FileAttribute[0]);
        }
        return grapeFolder;
    }

    private CamelCatalog getCatalog(CamelCatalogCoordinates coords) {
        if (!this.cachedCatalogs.containsKey(coords)) {
            DefaultCamelCatalog catalog = new DefaultCamelCatalog(true);
            MavenVersionManager versionManager = new MavenVersionManager();
            if (this.tempFolder != null) {
                versionManager.setCacheDirectory(this.tempFolder.getPath());
            }
            this.configureAdditionalRepos(versionManager);
            catalog.setVersionManager((VersionManager)versionManager);
            String version = coords.getVersion();
            String loadedVersion = this.loadVersion((CamelCatalog)catalog, version);
            coords.setVersion(loadedVersion);
            if (!CamelCatalogUtils.isCamelVersionWithoutProviderSupport((String)loadedVersion)) {
                this.configureRuntimeprovider(coords, (CamelCatalog)catalog);
            }
            this.cachedCatalogs.put(coords, (CamelCatalog)catalog);
        }
        return this.cachedCatalogs.get(coords);
    }

    private String loadVersion(CamelCatalog catalog, String requestedVersion) {
        if (!catalog.loadVersion(requestedVersion)) {
            if (OLDER_CAMEL_VERSION_WITH_CATALOG.compareTo(requestedVersion) > 1) {
                this.logger.logError("No catalog available for older version than 2.15.0, the 2.15.6 catalog will be used.");
                if (catalog.loadVersion(OLDER_CAMEL_CATALOG_VERSION_TO_LOAD_IN_CASE_OF_ERROR)) {
                    return OLDER_CAMEL_CATALOG_VERSION_TO_LOAD_IN_CASE_OF_ERROR;
                }
                return this.loadVersion(catalog, "2.20.1");
            }
            this.logger.logWarning("Unable to load Camel Catalog for version " + requestedVersion);
            this.logger.logWarning("The version 2.20.1 will be used instead.");
            if (catalog.loadVersion("2.20.1")) {
                return "2.20.1";
            }
            this.logger.logError("Unable to load Camel Catalog for version 2.20.1. Please check your connection and your local .m2 repository.");
            return null;
        }
        return requestedVersion;
    }

    private void configureRuntimeprovider(CamelCatalogCoordinates coords, CamelCatalog catalog) {
        String runtimeProvider = CamelCatalogUtils.getRuntimeProviderFromDependency((Dependency)coords.asMavenDependency());
        if ("springboot".equalsIgnoreCase(runtimeProvider)) {
            catalog.setRuntimeProvider((RuntimeProvider)new SpringBootRuntimeProvider());
        } else {
            catalog.setRuntimeProvider((RuntimeProvider)new KarafRuntimeProvider());
        }
        if (!catalog.loadRuntimeProviderVersion(coords.getGroupId(), coords.getArtifactId(), coords.getVersion())) {
            this.logger.logError(String.format("Unable to load the Camel Catalog for %s! Loaded %s as fallback.", coords, catalog.getCatalogVersion()));
        }
    }

    private void configureAdditionalRepos(MavenVersionManager versionManager) {
        List additionalM2Repos = this.camelMavenUtils.getAdditionalRepos();
        for (List repo : additionalM2Repos) {
            String repoName = (String)repo.get(0);
            String repoUri = (String)repo.get(1);
            versionManager.addMavenRepository(repoName, repoUri);
        }
    }

    public CamelModel getCamelModelForKarafRuntimeProvider(String camelVersion) {
        return this.getCamelModel(camelVersion, "karaf");
    }

    public CamelModel getCamelModel(String camelVersion, String runtimeProvider) {
        CamelCatalogCoordinates coords = CamelCatalogUtils.getCatalogCoordinatesFor((String)runtimeProvider, (String)camelVersion);
        CamelCatalog catalog = this.getCatalog(coords);
        CamelModel loadedModel = this.loadCamelModelFromCatalog(catalog);
        CamelModelPatcher.applyVersionSpecificCatalogFixes(catalog, loadedModel);
        return loadedModel;
    }

    public CamelSchemaProvider getCamelSchemaProvider(CamelCatalogCoordinates coords) {
        CamelCatalog catalog = this.getCatalog(coords);
        return new CamelSchemaProvider(catalog.blueprintSchemaAsXml(), catalog.springSchemaAsXml());
    }

    public String createEndpointUri(String scheme, Map<String, String> properties, CamelCatalogCoordinates coords) throws URISyntaxException {
        CamelCatalog catalog = this.getCatalog(coords);
        return catalog.asEndpointUri(scheme, properties, false);
    }

    public String createEndpointUri(String scheme, Map<String, String> properties, boolean encode, CamelCatalogCoordinates coords) throws URISyntaxException {
        CamelCatalog catalog = this.getCatalog(coords);
        return catalog.asEndpointUri(scheme, properties, encode);
    }

    public Map<String, String> getEndpointProperties(String uri, CamelCatalogCoordinates coords) throws URISyntaxException {
        CamelCatalog catalog = this.getCatalog(coords);
        return catalog.endpointProperties(uri);
    }

    public String createEndpointXml(String scheme, Map<String, String> properties, CamelCatalogCoordinates coords) throws URISyntaxException {
        CamelCatalog catalog = this.getCatalog(coords);
        return catalog.asEndpointUriXml(scheme, properties, false);
    }

    public String createEndpointXml(String scheme, Map<String, String> properties, boolean encode, CamelCatalogCoordinates coords) throws URISyntaxException {
        CamelCatalog catalog = this.getCatalog(coords);
        return catalog.asEndpointUriXml(scheme, properties, encode);
    }

    public String getEndpointScheme(String uri, CamelCatalogCoordinates coords) {
        CamelCatalog catalog = this.getCatalog(coords);
        return catalog.endpointComponentName(uri);
    }

    public String testExpression(String language, String expression) {
        String errorResult = null;
        DefaultCamelContext ctx = new DefaultCamelContext();
        try {
            try {
                ctx.resolveLanguage(language).createPredicate(expression.replaceAll("\n", "").replaceAll("\r", "").trim());
            }
            catch (Exception ex) {
                errorResult = ex.getMessage();
                try {
                    ctx.shutdown();
                }
                catch (Exception ex2) {
                    this.logger.logError((Throwable)ex2);
                }
                ctx = null;
            }
        }
        finally {
            try {
                ctx.shutdown();
            }
            catch (Exception ex) {
                this.logger.logError((Throwable)ex);
            }
            ctx = null;
        }
        return errorResult;
    }

    public long durationToMillis(String duration) {
        return TimePatternConverter.toMilliSeconds((String)duration);
    }

    public Map<String, Object> parseQuery(String uri) throws URISyntaxException {
        return URISupport.parseQuery((String)uri);
    }

    public String createQuery(Map<String, Object> parameters) throws URISyntaxException {
        HashMap<String, String> params = new HashMap<String, String>();
        for (Map.Entry<String, Object> e : parameters.entrySet()) {
            params.put(e.getKey(), (String)e.getValue());
        }
        return URISupport.createQueryString(params, (String)Character.toString('&'), (boolean)false);
    }

    public void updateMavenRepositoryLookup(List<Repository> repositories, CamelCatalogCoordinates coords) {
        for (Repository repo : repositories) {
            ((MavenVersionManager)this.getCatalog(coords).getVersionManager()).addMavenRepository(repo.getId(), repo.getUrl());
        }
    }

    /*
     * Unable to fully structure code
     */
    public boolean isCamelVersionExisting(String camelVersion) {
        block8: {
            block7: {
                tmpMan = new MavenVersionManager();
                try {
                    try {
                        grapeFolder = this.getGrapeFolderInsideTempFolder();
                        tmpFolderPath = Files.createTempDirectory(grapeFolder, UUID.randomUUID().toString(), new FileAttribute[0]);
                        tmpFolder = tmpFolderPath.toFile();
                        tmpFolder.deleteOnExit();
                        tmpMan.setCacheDirectory(tmpFolder.getPath());
                        tmpMan.setLog(true);
                        break block7;
                    }
                    catch (IOException ex) {
                        this.logger.logError((Throwable)ex);
                        ** for (rep : this.camelMavenUtils.getAdditionalRepos())
                    }
                }
                catch (Throwable var6_13) {
                    ** for (rep : this.camelMavenUtils.getAdditionalRepos())
                }
lbl-1000:
                // 1 sources

                {
                    tmpMan.addMavenRepository((String)rep.get(0), (String)rep.get(1));
                    continue;
lbl16:
                    // 1 sources

                    break block8;
                }
lbl-1000:
                // 1 sources

                {
                    tmpMan.addMavenRepository((String)rep.get(0), (String)rep.get(1));
                    continue;
                }
lbl21:
                // 1 sources

                throw var6_13;
            }
            for (List rep : this.camelMavenUtils.getAdditionalRepos()) {
                tmpMan.addMavenRepository((String)rep.get(0), (String)rep.get(1));
            }
        }
        return tmpMan.loadVersion(camelVersion);
    }

    CamelModel loadCamelModelFromCatalog(CamelCatalog catalog) {
        CamelModel model = new CamelModel();
        this.loadCamelComponents(catalog, model);
        this.loadDataformats(catalog, model);
        this.loadLanguages(catalog, model);
        this.loadEips(catalog, model);
        return model;
    }

    private void loadEips(CamelCatalog catalog, CamelModel model) {
        for (String name : catalog.findModelNames()) {
            String json = catalog.modelJSonSchema(name);
            Eip elem = Eip.getJSONFactoryInstance((InputStream)new ByteArrayInputStream(this.getUnicodeEncodedStreamIfPossible(json)));
            model.addEip(elem);
        }
    }

    private void loadLanguages(CamelCatalog catalog, CamelModel model) {
        for (String name : catalog.findLanguageNames()) {
            String json = catalog.languageJSonSchema(name);
            Language elem = Language.getJSONFactoryInstance((InputStream)new ByteArrayInputStream(this.getUnicodeEncodedStreamIfPossible(json)));
            model.addLanguage(elem);
        }
    }

    private void loadDataformats(CamelCatalog catalog, CamelModel model) {
        for (String name : catalog.findDataFormatNames()) {
            String json = catalog.dataFormatJSonSchema(name);
            DataFormat elem = DataFormat.getJSONFactoryInstance((InputStream)new ByteArrayInputStream(this.getUnicodeEncodedStreamIfPossible(json)));
            model.addDataFormat(elem);
        }
    }

    private void loadCamelComponents(CamelCatalog catalog, CamelModel model) {
        for (String name : catalog.findComponentNames()) {
            String json = catalog.componentJSonSchema(name);
            Component elem = Component.getJSONFactoryInstance((InputStream)new ByteArrayInputStream(this.getUnicodeEncodedStreamIfPossible(json)));
            model.addComponent(elem);
        }
    }

    private byte[] getUnicodeEncodedStreamIfPossible(String json) {
        return json.getBytes(StandardCharsets.UTF_8);
    }
}

