/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.foundation.ui.config;

import org.fusesource.ide.foundation.ui.util.BeanSupport;
import org.fusesource.ide.foundation.ui.util.DialogUtils;
import org.fusesource.ide.foundation.ui.util.PreferencesHelper;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public abstract class ConfigurationDetails
extends BeanSupport {
    private String id;

    public ConfigurationDetails() {
    }

    public ConfigurationDetails(String id) {
        this.id = id;
    }

    protected abstract void store(Preferences var1);

    public Preferences getConfigurationNode() {
        return PreferencesHelper.configurationNode(this.getConfigurationNodeId());
    }

    protected String getConfigurationNodeId() {
        return this.getClass().getName();
    }

    public void flush() {
        try {
            Preferences node = this.getConfigurationNode();
            if (this.id == null) {
                int i = node.childrenNames().length;
                do {
                    this.id = String.valueOf(this.getIdPrefix()) + ++i;
                } while (node.nodeExists(this.id));
            }
            Preferences chlld = node.node(this.id);
            this.store(chlld);
            PreferencesHelper.flush(node);
        }
        catch (BackingStoreException e) {
            DialogUtils.showUserError("org.fusesource.ide.foundation.ui", "Unable to store configuration...", "Failed to store configuration: " + this, (Exception)((Object)e));
        }
    }

    public void delete() {
        try {
            Preferences node = this.getConfigurationNode();
            if (this.id != null) {
                Preferences child = node.node(this.id);
                child.removeNode();
            }
            PreferencesHelper.flush(node);
        }
        catch (BackingStoreException e) {
            DialogUtils.showUserError("org.fusesource.ide.foundation.ui", "Unable to remove configuration...", "Failed to remove + " + this + " from configuration store", (Exception)((Object)e));
        }
    }

    protected String getIdPrefix() {
        return "n";
    }

    public String getId() {
        return this.id;
    }
}

