/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.foundation.ui.util;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.fusesource.ide.foundation.ui.tree.HasViewer;
import org.fusesource.ide.foundation.ui.tree.Refreshable;
import org.fusesource.ide.foundation.ui.util.Selections;
import org.fusesource.ide.foundation.ui.util.Viewers;
import org.jboss.tools.jmx.core.tree.Node;

public class Nodes {
    public static void refreshParent(final Node node) {
        final Node parent = node.getParent();
        if (parent instanceof Refreshable) {
            final Viewer viewer = Nodes.getViewer(node);
            final Object firstSelection = Selections.getFirstSelection(viewer);
            final String text = node.toString();
            Refreshable refreshable = (Refreshable)parent;
            refreshable.refresh();
            if (viewer != null) {
                Viewers.async(new Runnable(){

                    @Override
                    public void run() {
                        if (firstSelection == node) {
                            Nodes.selectChild(viewer, parent, text);
                        } else {
                            Nodes.addExpanded(viewer, parent, text);
                        }
                    }
                });
            }
        } else if (node instanceof Refreshable) {
            Refreshable refreshable = (Refreshable)node;
            refreshable.refresh();
        }
    }

    public static void refreshParentUsingFullPath(Node node) {
        Node parent = node.getParent();
        if (parent instanceof Refreshable) {
            final LinkedList<String> path = new LinkedList<String>();
            final Node root = Nodes.getRootAndAppendPath(path, node);
            final Viewer viewer = Nodes.getViewer(node);
            Refreshable refreshable = (Refreshable)parent;
            refreshable.refresh();
            if (viewer != null) {
                Viewers.async(new Runnable(){

                    @Override
                    public void run() {
                        Nodes.selectPath(viewer, root, path);
                    }
                });
            }
        } else if (node instanceof Refreshable) {
            Refreshable refreshable = (Refreshable)node;
            refreshable.refresh();
        }
    }

    public static List<String> getTreePath(Node node) {
        LinkedList<String> list = new LinkedList<String>();
        Nodes.getRootAndAppendPath(list, node);
        return list;
    }

    public static Node getRootAndAppendPath(LinkedList<String> list, Node node) {
        Node parent;
        if (node != null && (parent = node.getParent()) != null) {
            list.addFirst(node.toString());
            return Nodes.getRootAndAppendPath(list, parent);
        }
        return node;
    }

    public static void selectPath(Viewer viewer, Node root, LinkedList<String> path) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        Node node = root;
        nodes.add(node);
        for (String text : path) {
            if ((node = Nodes.findChild(node, text)) == null) break;
            nodes.add(node);
        }
        if (node != null && viewer instanceof AbstractTreeViewer) {
            AbstractTreeViewer tv = (AbstractTreeViewer)viewer;
            Object[] expandElements = nodes.toArray();
            tv.setExpandedElements(expandElements);
            tv.setSelection((ISelection)new StructuredSelection((Object)node));
        }
    }

    public static void addExpanded(Viewer viewer, Node node, String text) {
        Node child = Nodes.findChild(node, text);
        if (child != null) {
            Viewers.addExpanded(viewer, child);
        }
    }

    public static void selectChild(Viewer viewer, Node node, String text) {
        Node child = Nodes.findChild(node, text);
        if (child != null) {
            Nodes.setSelection(viewer, child);
        }
    }

    public static Node findChild(Node node, String text) {
        Node[] children = node.getChildren();
        if (children != null) {
            Node[] nodeArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Node child = nodeArray[n2];
                String childText = child.toString();
                if (text.equals(childText)) {
                    return child;
                }
                ++n2;
            }
        }
        return null;
    }

    public static void setSelection(Node node, Node ... selectedNodes) {
        Viewer viewer = Nodes.getViewer(node);
        Nodes.setSelection(viewer, selectedNodes);
    }

    public static void setSelection(Viewer viewer, Node ... selectedNodes) {
        Viewers.addExpanded(viewer, selectedNodes);
        Viewers.setSelected(viewer, (ISelection)new StructuredSelection((Object[])selectedNodes));
    }

    public static Viewer getViewer(Node node) {
        HasViewer hv = null;
        if (hv == null && node instanceof HasViewer) {
            hv = (HasViewer)node;
        }
        Viewer viewer = null;
        if (hv != null) {
            viewer = hv.getViewer();
        }
        return viewer;
    }

    public static void refreshSelection(final Node node) {
        final Viewer viewer = Nodes.getViewer(node);
        if (viewer != null && Selections.selectionIs(viewer, node)) {
            viewer.setSelection(null);
            Viewers.async(new Runnable(){

                @Override
                public void run() {
                    viewer.setSelection((ISelection)new StructuredSelection((Object)node));
                }
            });
        }
    }
}

