/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.foundation.ui.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.fusesource.ide.foundation.ui.util.TextFilter;

public class TextFilters {
    public static boolean matches(String searchText, String text) {
        return text != null && text.contains(searchText);
    }

    public static boolean matches(String searchText, TextFilter filter) {
        return filter != null && filter.matches(searchText);
    }

    public static boolean matches(String searchText, Object object) {
        if (searchText == null || searchText.trim().length() == 0) {
            return true;
        }
        if (object instanceof TextFilter) {
            return TextFilters.matches(searchText, (TextFilter)object);
        }
        if (object instanceof Map) {
            return TextFilters.matches(searchText, (Map)object);
        }
        if (object instanceof Collection) {
            return TextFilters.matches(searchText, (Collection)object);
        }
        if (object instanceof IPropertySource) {
            return TextFilters.matches(searchText, (IPropertySource)object);
        }
        if (object instanceof Object[]) {
            return TextFilters.matches(searchText, Arrays.asList((Object[])object));
        }
        if (object != null) {
            return TextFilters.matches(searchText, object.toString());
        }
        return false;
    }

    public static boolean matches(String searchText, IPropertySource property) {
        IPropertyDescriptor[] descriptors;
        IPropertyDescriptor[] iPropertyDescriptorArray = descriptors = property.getPropertyDescriptors();
        int n = descriptors.length;
        int n2 = 0;
        while (n2 < n) {
            IPropertyDescriptor descriptor = iPropertyDescriptorArray[n2];
            Object value = property.getPropertyValue(descriptor.getId());
            if (value != null && TextFilters.matches(searchText, value)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean matches(String searchText, Map map) {
        Set entrySet = map.entrySet();
        for (Map.Entry entry : entrySet) {
            if (!TextFilters.matches(searchText, entry.getKey()) && !TextFilters.matches(searchText, entry.getValue())) continue;
            return true;
        }
        return false;
    }

    public static boolean matches(String searchText, Collection<?> collection) {
        for (Object element : collection) {
            if (!TextFilters.matches(searchText, element)) continue;
            return true;
        }
        return false;
    }
}

