/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.foundation.ui.util;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;
import org.fusesource.ide.foundation.ui.util.Widgets;

public class Viewers {
    private Viewers() {
    }

    public static Viewer getViewer(Object object) {
        if (object instanceof Viewer) {
            return (Viewer)object;
        }
        return null;
    }

    public static void expand(Viewer viewer, Object elementOrTreePath, int level) {
        if (viewer instanceof TreeViewer) {
            TreeViewer tv = (TreeViewer)viewer;
            tv.expandToLevel(elementOrTreePath, level);
        }
    }

    public static void refresh(final Viewer viewer) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                if (Viewers.isValid(viewer)) {
                    viewer.refresh();
                    Control control = viewer.getControl();
                    if (control instanceof Table) {
                        ((Table)control).showSelection();
                    } else if (control instanceof Tree) {
                        ((Tree)control).showSelection();
                    }
                }
            }
        });
    }

    public static void async(Runnable runnable) {
        Display display = Viewers.getDisplay();
        if (display != null) {
            display.asyncExec(runnable);
        }
    }

    public static Display getDisplay() {
        Display display = Display.getDefault();
        if (display == null) {
            display = Display.getCurrent();
        }
        return display;
    }

    public static void refreshAsync(Viewer viewer) {
        Viewers.async(() -> Viewers.refresh(viewer));
    }

    public static boolean isValid(Viewer viewer) {
        boolean valid = false;
        if (viewer != null) {
            Control widget = viewer.getControl();
            valid = Widgets.isValid((Widget)widget);
        }
        return valid;
    }

    public static void reveal(Viewer viewer, Object element) {
        if (viewer instanceof StructuredViewer) {
            StructuredViewer sv = (StructuredViewer)viewer;
            sv.reveal(element);
        }
    }

    public static void setInput(Viewer viewer, Object input) {
        if (viewer != null && Viewers.isValid(viewer)) {
            viewer.setInput(input);
        }
    }

    public static boolean isVisible(Viewer viewer) {
        if (Viewers.isValid(viewer)) {
            Control control = viewer.getControl();
            return control != null && control.isVisible();
        }
        return false;
    }

    public static void setSelected(Viewer viewer, ISelection selection) {
        if (viewer != null) {
            viewer.setSelection(selection);
        }
    }

    public static void addExpanded(Viewer viewer, Object ... expanded) {
        if (viewer instanceof AbstractTreeViewer) {
            AbstractTreeViewer cv = (AbstractTreeViewer)viewer;
            Object[] expandedElements = cv.getExpandedElements();
            ArrayList<Object> list = new ArrayList<Object>();
            if (expandedElements != null) {
                list.addAll(Arrays.asList(expandedElements));
            }
            list.addAll(Arrays.asList(expanded));
            cv.setExpandedElements(expanded);
        }
    }
}

