/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.imports.sap;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import org.eclipse.core.runtime.Platform;
import org.fusesource.ide.imports.sap.ImportUtils;
import org.fusesource.ide.imports.sap.JCo3ImportSettings;
import org.fusesource.ide.imports.sap.Messages;
import org.fusesource.ide.imports.sap.SAPArchive;

public class JCo3Archive
extends SAPArchive {
    private static final String SAPJCO_RELEASE_DELIMITER = ".";
    private static final String MANIFEST_LINE_DELIMITER = ":";
    public static final String NATIVE_ARCHIVE_NAME_WIN = "sapjco3.dll";
    public static final String NATIVE_ARCHIVE_NAME_LINUX = "libsapjco3.so";
    public static final String NATIVE_ARCHIVE_NAME_MACOS = "libsapjco3.jnilib";
    public static final String PLUGIN_JCO = "com.sap.conn.jco";
    public static final String FRAGMENT_WINDOWS_32 = "com.sap.conn.jco.win32.x86";
    public static final String FRAGMENT_WINDOWS_64IA = "com.sap.conn.jco.win32.ia64";
    public static final String FRAGMENT_WINDOWS_64X86 = "com.sap.conn.jco.win32.x86_64";
    public static final String FRAGMENT_LINUX_32 = "com.sap.conn.jco.linux.x86";
    public static final String FRAGMENT_LINUX_64IA = "com.sap.conn.jco.linux.ia64";
    public static final String FRAGMENT_LINUX_64X86 = "com.sap.conn.jco.linux.x86_64";
    public static final String FRAGMENT_DARWIN_32 = "com.sap.conn.jco.osx.x86";
    public static final String FRAGMENT_DARWIN_64 = "com.sap.conn.jco.osx.x86_64";
    public static final String ECLIPSE_PLATFORM_FILTER = "Eclipse-PlatformFilter";
    public static final String BUNDLE_CLASS_PATH_VALUE = "bin/,\n sapjco3.jar,\n jni/";
    public static final String EXPORT_PACKAGE_VALUE = "com.sap.conn.jco, com.sap.conn.jco.ext, com.sap.conn.jco.monitor, com.sap.conn.jco.rt, com.sap.conn.jco.rt.json,  com.sap.conn.jco.server, com.sap.conn.jco.session, com.sap.conn.jco.support, com.sap.conn.jco.util";
    public static final String SAPJCO_RELEASE = "sapjco release";
    public static final String SAPJCO_PATCH_LEVEL = "sapjco patch level";
    public static final String SAPJCO_OS = "sapjco os";
    public static final String SAPJCO3_JAR = "sapjco3.jar";
    public static final String SAPJCOMANIFEST_MF = "sapjcomanifest.mf";
    protected byte[] buf = new byte[32768];
    protected String name;
    protected JCoArchiveType type;
    protected Map<String, String> manifest = new HashMap<String, String>();
    protected long lastModified;
    private String version;
    private byte[] sapjco3jar;
    private byte[] nativelib;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public JCo3Archive(String filename) throws IOException {
        this.name = filename;
        File file = new File(filename);
        this.lastModified = file.lastModified();
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try {
                FileInputStream is = new FileInputStream(file);
                try {
                    try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
                        int numRead;
                        while ((numRead = ((InputStream)is).read(this.buf, 0, this.buf.length)) != -1) {
                            os.write(this.buf, 0, numRead);
                        }
                        this.readArchiveFile(filename, os.toByteArray());
                        this.readArchiveType();
                        this.readJCo3JarFile();
                        this.readNativeLibraryFile();
                    }
                    if (is == null) return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (is == null) throw throwable;
                    ((InputStream)is).close();
                    throw throwable;
                }
                ((InputStream)is).close();
                return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            this.type = JCoArchiveType.JCO_INVALID_ARCHIVE;
            throw e;
        }
    }

    public String getName() {
        return this.name;
    }

    public JCoArchiveType getType() {
        return this.type;
    }

    public Map<String, byte[]> getContents() {
        return this.contents;
    }

    public Map<String, String> getManifest() {
        return this.manifest;
    }

    public byte[] getJCo3JarFile() {
        return this.sapjco3jar;
    }

    public byte[] getNativeLibraryFile() {
        return this.nativelib;
    }

    public String getVersion() {
        if (this.version == null) {
            StringBuilder builder = new StringBuilder();
            String sapjcoRelease = this.manifest.get(SAPJCO_RELEASE).trim();
            String sapjcoPatchLevel = this.manifest.get(SAPJCO_PATCH_LEVEL).trim();
            if (sapjcoRelease != null && sapjcoRelease.length() > 0) {
                builder.append(sapjcoRelease);
                builder.append(SAPJCO_RELEASE_DELIMITER);
                builder.append(sapjcoPatchLevel);
                this.version = builder.toString();
            }
        }
        return this.version;
    }

    public String getBundleName() {
        return this.type.getPluginName();
    }

    public byte[] getSapjco3jar() {
        return this.sapjco3jar;
    }

    public byte[] getNativelib() {
        return this.nativelib;
    }

    public boolean supportsCurrentPlatform() {
        return Platform.getOS().equals(this.getType().getEclipseOS()) && Platform.getOSArch().equals(this.getType().getEclipseArch());
    }

    public void buildJCoPlugin(JCo3ImportSettings settings) throws IOException {
        ByteArrayInputStream is = null;
        byte[] bBuf = new byte[32768];
        String bundleFilename = settings.getBundleFilename();
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (JarOutputStream target = new JarOutputStream(new FileOutputStream(bundleFilename));){
                int numRead;
                int numRead2;
                byte[] bManifest = this.createBundleManifestFile(settings);
                JarEntry manifestEntry = new JarEntry("META-INF/MANIFEST.MF");
                manifestEntry.setTime(this.lastModified);
                target.putNextEntry(manifestEntry);
                is = new ByteArrayInputStream(bManifest);
                while ((numRead2 = ((InputStream)is).read(bBuf, 0, bBuf.length)) != -1) {
                    target.write(bBuf, 0, numRead2);
                }
                target.closeEntry();
                JarEntry nativeDirEntry = new JarEntry(settings.getBundleNativeDirEntry());
                nativeDirEntry.setTime(this.lastModified);
                target.putNextEntry(nativeDirEntry);
                JarEntry jco3JarEntry = new JarEntry(settings.getBundleJCoJarEntry());
                jco3JarEntry.setTime(this.lastModified);
                target.putNextEntry(jco3JarEntry);
                is = new ByteArrayInputStream(this.sapjco3jar);
                while ((numRead = ((InputStream)is).read(bBuf, 0, bBuf.length)) != -1) {
                    target.write(bBuf, 0, numRead);
                }
                target.closeEntry();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            throw new IOException(Messages.JCo3Archive_FailedToBuildJCo3Plugin, e);
        }
    }

    public void buildJCoNativePlugin(JCo3ImportSettings settings) throws IOException {
        ByteArrayInputStream is = null;
        byte[] sbBuf = new byte[32768];
        String bundleFilename = settings.getFragmentFilename();
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (JarOutputStream target = new JarOutputStream(new FileOutputStream(bundleFilename));){
                int numRead;
                int numRead2;
                byte[] bManifest = this.createFragmentManifestFile(settings);
                JarEntry manifestEntry = new JarEntry("META-INF/MANIFEST.MF");
                manifestEntry.setTime(this.lastModified);
                target.putNextEntry(manifestEntry);
                is = new ByteArrayInputStream(bManifest);
                while ((numRead2 = ((InputStream)is).read(sbBuf, 0, sbBuf.length)) != -1) {
                    target.write(sbBuf, 0, numRead2);
                }
                target.closeEntry();
                JarEntry nativeDirEntry = new JarEntry(settings.getBundleNativeDirEntry());
                nativeDirEntry.setTime(this.lastModified);
                target.putNextEntry(nativeDirEntry);
                JarEntry jco3NativeLibEntry = new JarEntry(settings.getBundleNativeLibraryEntry());
                jco3NativeLibEntry.setTime(this.lastModified);
                target.putNextEntry(jco3NativeLibEntry);
                is = new ByteArrayInputStream(this.nativelib);
                while ((numRead = ((InputStream)is).read(sbBuf, 0, sbBuf.length)) != -1) {
                    target.write(sbBuf, 0, numRead);
                }
                target.closeEntry();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            throw new IOException(Messages.JCo3Archive_FailedToBuildJCo3PluginFragment, e);
        }
    }

    private void readArchiveType() throws IOException {
        byte[] file = (byte[])this.contents.get(SAPJCOMANIFEST_MF);
        if (file == null) {
            this.type = JCoArchiveType.JCO_INVALID_ARCHIVE;
            throw new IOException(MessageFormat.format(Messages.JCo3Archive_FileMissingFromArchive, SAPJCOMANIFEST_MF));
        }
        try {
            this.manifest = this.parseManifest(file);
        }
        catch (IOException e) {
            this.type = JCoArchiveType.JCO_INVALID_ARCHIVE;
            throw new IOException(Messages.JCo3Archive_UnableToParseArchiveManifestFile, e);
        }
        String sapjcoos = this.manifest.get(SAPJCO_OS);
        if (sapjcoos == null) {
            this.type = JCoArchiveType.JCO_INVALID_ARCHIVE;
            throw new IOException(MessageFormat.format(Messages.JCo3Archive_HeaderisMissingFromManifestFile, SAPJCO_OS));
        }
        this.type = JCoArchiveType.getType(sapjcoos);
        if (this.type == JCoArchiveType.JCO_INVALID_ARCHIVE) {
            throw new IOException(MessageFormat.format(Messages.JCo3Archive_OSPlatformIsNotSupported, sapjcoos));
        }
    }

    private void readJCo3JarFile() throws IOException {
        byte[] bsapjco3jar = (byte[])this.contents.get(SAPJCO3_JAR);
        if (bsapjco3jar == null) {
            throw new IOException(MessageFormat.format(Messages.JCo3Archive_FileMissingFromArchive, SAPJCO3_JAR));
        }
        this.sapjco3jar = bsapjco3jar;
    }

    private void readNativeLibraryFile() throws IOException {
        byte[] bNativelib = (byte[])this.contents.get(this.type.getNativeArchiveName());
        if (bNativelib == null) {
            throw new IOException(MessageFormat.format(Messages.JCo3Archive_FileMissingFromArchive, this.type.getNativeArchiveName()));
        }
        this.nativelib = bNativelib;
    }

    private Map<String, String> parseManifest(byte[] file) throws IOException {
        this.manifest.clear();
        Throwable throwable = null;
        Object var3_4 = null;
        try (BufferedReader br = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(file)));){
            String line;
            while ((line = br.readLine()) != null) {
                String[] elements = line.split(MANIFEST_LINE_DELIMITER);
                if (elements.length < 2) continue;
                this.manifest.put(elements[0], elements[1]);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return this.manifest;
    }

    private byte[] createBundleManifestFile(JCo3ImportSettings settings) throws IOException {
        StringBuilder sbManifest = new StringBuilder();
        this.writeAttribute(sbManifest, Attributes.Name.MANIFEST_VERSION.toString(), "1.0");
        this.writeAttribute(sbManifest, "Bundle-ManifestVersion", "2");
        this.writeAttribute(sbManifest, "Bundle-Name", settings.getBundleName());
        this.writeAttribute(sbManifest, "Bundle-SymbolicName", settings.getBundleSymbolicName());
        this.writeAttribute(sbManifest, "Bundle-Version", settings.getBundleVersion());
        this.writeAttribute(sbManifest, "Bundle-ClassPath", BUNDLE_CLASS_PATH_VALUE);
        this.writeAttribute(sbManifest, "Bundle-Vendor", settings.getBundleVendor());
        this.writeAttribute(sbManifest, "Bundle-RequiredExecutionEnvironment", ImportUtils.getExecutionEnvironment(settings.getRequiredExecutionEnvironmentIndex()));
        this.writeAttribute(sbManifest, "Export-Package", EXPORT_PACKAGE_VALUE);
        this.writeAttribute(sbManifest, "Bundle-ActivationPolicy", "lazy");
        return sbManifest.toString().getBytes(MANIFEST_ENCODING);
    }

    private byte[] createFragmentManifestFile(JCo3ImportSettings settings) throws IOException {
        StringBuilder sbManifest = new StringBuilder();
        this.writeAttribute(sbManifest, Attributes.Name.MANIFEST_VERSION.toString(), "1.0");
        this.writeAttribute(sbManifest, "Bundle-ManifestVersion", "2");
        this.writeAttribute(sbManifest, "Bundle-Name", settings.getFragmentBundleName());
        this.writeAttribute(sbManifest, "Bundle-SymbolicName", settings.getFragmentSymbolicName());
        this.writeAttribute(sbManifest, "Bundle-Version", settings.getBundleVersion());
        this.writeAttribute(sbManifest, "Bundle-Vendor", settings.getBundleVendor());
        this.writeAttribute(sbManifest, "Fragment-Host", settings.getFragmentHost());
        this.writeAttribute(sbManifest, "Bundle-RequiredExecutionEnvironment", ImportUtils.getExecutionEnvironment(settings.getRequiredExecutionEnvironmentIndex()));
        this.writeAttribute(sbManifest, "Bundle-NativeCode", settings.getBundleNativeLibraryEntry());
        this.writeAttribute(sbManifest, ECLIPSE_PLATFORM_FILTER, settings.getPlatformFilter());
        return sbManifest.toString().getBytes(MANIFEST_ENCODING);
    }

    public static enum JCoArchiveType {
        JCO_INVALID_ARCHIVE("Invalid JCo 3 Archive", "", "", "", "", "", "", ""),
        JCO_WIN32_X86_ARCHIVE("Microsoft Windows (x86 32 bit)", "NTintel", "sapjco3.dll", "com.sap.conn.jco.win32.x86", "(& (osgi.os=win32) (osgi.arch=x86))", "win32", "x86", "win32"),
        JCO_WIN32_IA64_ARCHIVE("Microsoft Windows (Itanium 64 bit)", "NTia64", "sapjco3.dll", "com.sap.conn.jco.win32.ia64", "(& (osgi.os=win32) (osgi.arch=ia64n))", "win32", "ia64", "win32"),
        JCO_WIN32_X86_64_ARCHIVE("Microsoft Windows (x86 64 bit)", "NTAMD64", "sapjco3.dll", "com.sap.conn.jco.win32.x86_64", "(& (osgi.os=win32) (osgi.arch=x86_64))", "win32", "x86_64", "win32"),
        JCO_LINUX_X86_ARCHIVE("Linux (x86 32 bit)", "linuxintel", "libsapjco3.so", "com.sap.conn.jco.linux.x86", "(& (osgi.os=linux) (osgi.arch=x86))", "linux", "x86", "gtk"),
        JCO_LINUX_IA64_ARCHIVE("Linux (Itanium 64 bit)", "linuxia64", "libsapjco3.so", "com.sap.conn.jco.linux.ia64", "(& (osgi.os=linux) (osgi.arch=ia64n))", "linux", "ia64", "gtk"),
        JCO_LINUX_X86_64_ARCHIVE("Linux (x86 64 bit)", "linuxx86_64", "libsapjco3.so", "com.sap.conn.jco.linux.x86_64", "(& (osgi.os=linux) (osgi.arch=x86_64))", "linux", "x86_64", "gtk"),
        JCO_OSX_X86_ARCHIVE("Apple MacOS X (x86 32 bit)", "darwinintel", "libsapjco3.jnilib", "com.sap.conn.jco.osx.x86", "(& (osgi.os=macosx) (osgi.arch=x86))", "macosx", "x86", "cocoa"),
        JCO_OSX_X86_64_ARCHIVE("Apple MacOS X (x86 64 bit)", "darwinintel64", "libsapjco3.jnilib", "com.sap.conn.jco.osx.x86_64", "(& (osgi.os=macosx) (osgi.arch=x86_64))", "macosx", "x86_64", "cocoa");

        private String description;
        private String sapjcoOs;
        private String nativeArchiveName;
        private String fragmentName;
        private String platformFilter;
        private String eclipseOS;
        private String eclipseArch;
        private String eclipseWS;

        private JCoArchiveType(String description, String sapjcoOs, String nativeArchiveName, String fragmentName, String platformFilter, String eclipseOS, String eclipseArch, String eclipseWS) {
            this.description = description;
            this.nativeArchiveName = nativeArchiveName;
            this.sapjcoOs = sapjcoOs;
            this.fragmentName = fragmentName;
            this.platformFilter = platformFilter;
            this.eclipseOS = eclipseOS;
            this.eclipseArch = eclipseArch;
            this.eclipseWS = eclipseWS;
        }

        public String getDescription() {
            return this.description;
        }

        public String getSapjcoOs() {
            return this.sapjcoOs;
        }

        public String getNativeArchiveName() {
            return this.nativeArchiveName;
        }

        public String getPluginName() {
            return JCo3Archive.PLUGIN_JCO;
        }

        public String getFragmentName() {
            return this.fragmentName;
        }

        public String getPlatformFilter() {
            return this.platformFilter;
        }

        public String getEclipseOS() {
            return this.eclipseOS;
        }

        public String getEclipseArch() {
            return this.eclipseArch;
        }

        public String getEclipseWS() {
            return this.eclipseWS;
        }

        public static JCoArchiveType getType(String sapjcoOsCode) {
            String trimmedSapjcoOsCode = sapjcoOsCode.trim();
            if (trimmedSapjcoOsCode.equals(JCO_WIN32_X86_ARCHIVE.getSapjcoOs())) {
                return JCO_WIN32_X86_ARCHIVE;
            }
            if (trimmedSapjcoOsCode.equals(JCO_WIN32_IA64_ARCHIVE.getSapjcoOs())) {
                return JCO_WIN32_IA64_ARCHIVE;
            }
            if (trimmedSapjcoOsCode.equals(JCO_WIN32_X86_64_ARCHIVE.getSapjcoOs())) {
                return JCO_WIN32_X86_64_ARCHIVE;
            }
            if (trimmedSapjcoOsCode.equals(JCO_LINUX_X86_ARCHIVE.getSapjcoOs())) {
                return JCO_LINUX_X86_ARCHIVE;
            }
            if (trimmedSapjcoOsCode.equals(JCO_LINUX_IA64_ARCHIVE.getSapjcoOs())) {
                return JCO_LINUX_IA64_ARCHIVE;
            }
            if (trimmedSapjcoOsCode.equals(JCO_LINUX_X86_64_ARCHIVE.getSapjcoOs())) {
                return JCO_LINUX_X86_64_ARCHIVE;
            }
            if (trimmedSapjcoOsCode.equals(JCO_OSX_X86_ARCHIVE.getSapjcoOs())) {
                return JCO_OSX_X86_ARCHIVE;
            }
            if (trimmedSapjcoOsCode.equals(JCO_OSX_X86_64_ARCHIVE.getSapjcoOs())) {
                return JCO_OSX_X86_64_ARCHIVE;
            }
            return JCO_INVALID_ARCHIVE;
        }

        public static JCoArchiveType getTypeForCurrentPlatform() {
            String os = Platform.getOS();
            String arch = Platform.getOSArch();
            if (os.equals("win32")) {
                if (arch.equals("x86")) {
                    return JCO_WIN32_X86_ARCHIVE;
                }
                if (arch.equals("ia64")) {
                    return JCO_WIN32_IA64_ARCHIVE;
                }
                if (arch.equals("x86_64")) {
                    return JCO_WIN32_X86_64_ARCHIVE;
                }
            } else if (os.equals("linux")) {
                if (arch.equals("x86")) {
                    return JCO_LINUX_X86_ARCHIVE;
                }
                if (arch.equals("ia64")) {
                    return JCO_LINUX_IA64_ARCHIVE;
                }
                if (arch.equals("x86_64")) {
                    return JCO_LINUX_X86_64_ARCHIVE;
                }
            } else if (os.equals("macosx")) {
                if (arch.equals("x86")) {
                    return JCO_OSX_X86_ARCHIVE;
                }
                if (arch.equals("x86_64")) {
                    return JCO_OSX_X86_64_ARCHIVE;
                }
            }
            return JCO_INVALID_ARCHIVE;
        }
    }
}

