/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.jmx.camel.navigator;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import org.fusesource.ide.jmx.camel.CamelJMXPlugin;
import org.fusesource.ide.jmx.camel.navigator.CamelContextNode;
import org.fusesource.ide.jmx.camel.navigator.stats.model.CamelContextStatistics;
import org.fusesource.ide.jmx.camel.navigator.stats.model.IProcessorStatistics;
import org.fusesource.ide.jmx.camel.navigator.stats.model.IProcessorStatisticsContainer;
import org.fusesource.ide.jmx.camel.navigator.stats.model.ProcessorStatistics;
import org.fusesource.ide.jmx.camel.navigator.stats.model.RouteStatistics;
import org.fusesource.ide.jmx.commons.messages.NodeStatisticsContainer;

public class CachingCamelContextNodeStatisticsContainer
implements NodeStatisticsContainer,
IProcessorStatisticsContainer {
    private static final long THROTTLE_MILLIS = 10000L;
    private final CamelContextNode camelContextNode;
    private long lastRequestTime = 0L;
    private Map<String, IProcessorStatistics> cache = new HashMap<String, IProcessorStatistics>();

    public CachingCamelContextNodeStatisticsContainer(CamelContextNode camelContextNode) {
        this.camelContextNode = camelContextNode;
    }

    public IProcessorStatistics getNodeStats(String nodeId) {
        Map<String, IProcessorStatistics> statsMap = this.getNodeStatsMap();
        return statsMap.get(nodeId);
    }

    @Override
    public Map<String, IProcessorStatistics> getNodeStatsMap() {
        if (this.shouldQuery()) {
            String managementName = this.camelContextNode.getManagementName();
            try {
                ArrayList<RouteStatistics> routeStatisticsList;
                CamelContextStatistics stats;
                String xml = this.camelContextNode.getFacade().dumpRoutesStatsAsXml(managementName);
                if (xml != null && (xml = xml.trim()).length() > 0 && (stats = this.getStatistics(xml)) != null && (routeStatisticsList = stats.getRouteStatisticsList()) != null) {
                    HashMap<String, IProcessorStatistics> map = new HashMap<String, IProcessorStatistics>();
                    for (RouteStatistics stat : routeStatisticsList) {
                        String id = stat.getId();
                        map.put(id, stat);
                        ArrayList<ProcessorStatistics> procStats = stat.getProcessorStatisticsList();
                        if (procStats == null) continue;
                        for (ProcessorStatistics procStat : procStats) {
                            map.put(procStat.getId(), procStat);
                        }
                    }
                    this.cache = map;
                }
            }
            catch (Exception e) {
                CamelJMXPlugin.getLogger().error("Failed to query the JMX statistics of Camel: " + managementName, (Throwable)e);
            }
        }
        Map<String, IProcessorStatistics> statsMap = this.cache;
        return statsMap;
    }

    private CamelContextStatistics getStatistics(String xmlDump) {
        CamelContextStatistics stats = null;
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{CamelContextStatistics.class, RouteStatistics.class, ProcessorStatistics.class});
            Unmarshaller um = context.createUnmarshaller();
            stats = (CamelContextStatistics)um.unmarshal((Reader)new StringReader(xmlDump));
        }
        catch (Exception ex) {
            stats = null;
            CamelJMXPlugin.getLogger().error("Error retrieving the statistics for camel context: " + this.camelContextNode.getContextId(), (Throwable)ex);
        }
        return stats;
    }

    protected boolean shouldQuery() {
        long now = System.currentTimeMillis();
        long delta = now - this.lastRequestTime;
        this.lastRequestTime = now;
        return delta > 10000L || this.cache.isEmpty();
    }
}

