/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.jmx.camel.navigator;

import java.util.List;
import java.util.Objects;
import org.eclipse.swt.graphics.Image;
import org.fusesource.ide.camel.model.service.core.jmx.camel.CamelContextMBean;
import org.fusesource.ide.camel.model.service.core.jmx.camel.CamelJMXFacade;
import org.fusesource.ide.foundation.ui.tree.RefreshableCollectionNode;
import org.fusesource.ide.jmx.camel.CamelJMXPlugin;
import org.fusesource.ide.jmx.camel.navigator.CamelContextNode;
import org.jboss.tools.jmx.core.tree.Node;
import org.jboss.tools.jmx.ui.ImageProvider;

public class CamelContextsNode
extends RefreshableCollectionNode
implements ImageProvider {
    private final CamelJMXFacade facade;

    public CamelContextsNode(Node parent, CamelJMXFacade facade) {
        super(parent);
        this.facade = facade;
    }

    public String toString() {
        return "Camel";
    }

    public CamelJMXFacade getFacade() {
        return this.facade;
    }

    protected void loadChildren() {
        try {
            List camelContexts = this.facade.getCamelContexts();
            if (camelContexts != null) {
                for (CamelContextMBean camelContextMBean : camelContexts) {
                    CamelContextNode child = new CamelContextNode(this, this.facade, camelContextMBean);
                    this.addChild((Node)child);
                }
            }
        }
        catch (Exception e) {
            CamelJMXPlugin.getLogger().warning("Failed to connect to JMX: " + e, (Throwable)e);
        }
    }

    public Image getImage() {
        return CamelJMXPlugin.getDefault().getImage("camel.png");
    }

    public boolean equals(Object obj) {
        return obj instanceof CamelContextsNode && obj.hashCode() == this.hashCode();
    }

    public int hashCode() {
        return Objects.hash(this.getConnection(), "CamelContextsNode");
    }
}

