/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.jmx.camel.navigator;

import java.util.List;
import java.util.Objects;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.swt.graphics.Image;
import org.fusesource.ide.camel.model.service.core.model.AbstractCamelModelElement;
import org.fusesource.ide.jmx.camel.CamelJMXPlugin;
import org.fusesource.ide.jmx.camel.navigator.CamelContextNode;
import org.fusesource.ide.jmx.camel.navigator.ProcessorNodeSupport;
import org.fusesource.ide.jmx.camel.navigator.RouteNode;
import org.jboss.tools.jmx.core.tree.Node;

public class ProcessorNode
extends ProcessorNodeSupport {
    private static final boolean useCaching = true;
    private final RouteNode routeNode;
    private final AbstractCamelModelElement node;

    public ProcessorNode(RouteNode routeNode, Node parent, AbstractCamelModelElement node) {
        super(parent, routeNode.getRoute());
        this.routeNode = routeNode;
        this.node = node;
    }

    public String toString() {
        return this.node.getDisplayText();
    }

    @Override
    public CamelContextNode getCamelContextNode() {
        return this.routeNode.getCamelContextNode();
    }

    protected void loadChildren() {
        List children = this.node.getChildElements();
        if (this.node.getOutputElement() != null) {
            this.addChild((Node)new ProcessorNode(this.routeNode, (Node)this, this.node.getOutputElement()));
        }
        for (AbstractCamelModelElement pnode : children) {
            if (pnode.getInputElement() != null) continue;
            this.addChild((Node)new ProcessorNode(this.routeNode, (Node)this, pnode));
        }
    }

    protected Object createPropertyBean() {
        String nodeId = this.getNodeId();
        if (nodeId != null) {
            return this.getCamelContextNode().createProcessorBeanView(this.getRouteId(), nodeId);
        }
        return super.createPropertyBean();
    }

    public void provideContextMenu(IMenuManager menu) {
        this.routeNode.provideContextMenu(menu);
    }

    @Override
    public String getNodeId() {
        return this.node.getId();
    }

    public Image getImage() {
        Image img = CamelJMXPlugin.getDefault().getImage(this.node.getIconName().replaceAll(".png", "16.png"));
        if (img == null) {
            img = CamelJMXPlugin.getDefault().getImage("generic16.png");
        }
        return img;
    }

    public boolean equals(Object obj) {
        return obj instanceof ProcessorNode && obj.hashCode() == this.hashCode();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getConnection(), this.routeNode, this.node.getId()});
    }
}

