/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.jmx.commons;

import java.io.IOException;
import java.util.Arrays;
import java.util.Hashtable;
import javax.management.JMX;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import org.fusesource.ide.jmx.commons.Activator;

public abstract class JmxTemplateSupport {
    public abstract <T> T execute(JmxConnectorCallback<T> var1);

    public static ObjectName safeObjectName(String domain, String ... args) {
        if (args.length % 2 != 0) {
            Activator.getLogger().warning(String.format("Not all values were defined for arguments %s", Arrays.toString(args)));
        }
        Hashtable<String, String> table = new Hashtable<String, String>();
        int i = 0;
        while (i < args.length) {
            table.put(args[i], args[i + 1]);
            i += 2;
        }
        try {
            return new ObjectName(domain, table);
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException("Object name is invalid", e);
        }
    }

    public <T> T getMBean(JMXConnector connector, Class<T> type, String domain, String ... params) {
        try {
            return JMX.newMBeanProxy(connector.getMBeanServerConnection(), JmxTemplateSupport.safeObjectName(domain, params), type);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static interface JmxConnectorCallback<T> {
        public T doWithJmxConnector(JMXConnector var1) throws Exception;
    }
}

