/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.jmx.commons.messages;

import java.util.concurrent.atomic.AtomicLong;
import org.fusesource.ide.jmx.commons.messages.IInvocationStatistics;
import org.fusesource.ide.jmx.commons.messages.INodeStatistics;
import org.fusesource.ide.jmx.commons.messages.NodeStatistics;

public class InvocationStatistics
implements IInvocationStatistics {
    private AtomicLong counter = new AtomicLong(0L);
    private AtomicLong elapsedTime = new AtomicLong(0L);
    private AtomicLong maxElapsedTime = new AtomicLong(0L);
    private AtomicLong minElapsedTime = new AtomicLong(0L);

    public InvocationStatistics() {
    }

    public InvocationStatistics(IInvocationStatistics that) {
        if (that != null) {
            this.counter.set(that.getCounter());
            this.elapsedTime.set(that.getTotalElapsedTime());
            this.maxElapsedTime.set(that.getMaxElapsedTime());
            this.minElapsedTime.set(that.getMinElapsedTime());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void append(NodeStatistics that) {
        this.counter.addAndGet(that.getCounter());
        this.elapsedTime.addAndGet(that.getTotalElapsedTime());
        InvocationStatistics invocationStatistics = this;
        synchronized (invocationStatistics) {
            long time = that.getMinElapsedTime();
            if (time < this.minElapsedTime.get()) {
                this.minElapsedTime.set(time);
            }
            if ((time = that.getMaxElapsedTime()) > this.maxElapsedTime.get()) {
                this.maxElapsedTime.set(time);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void combineChild(INodeStatistics that) {
        long value = that.getCounter();
        if (value > this.counter.get()) {
            this.counter.set(value);
        }
        this.elapsedTime.addAndGet(that.getTotalElapsedTime());
        InvocationStatistics invocationStatistics = this;
        synchronized (invocationStatistics) {
            value = that.getMinElapsedTime();
            if (value < this.minElapsedTime.get()) {
                this.minElapsedTime.set(value);
            }
            if ((value = that.getMaxElapsedTime()) > this.maxElapsedTime.get()) {
                this.maxElapsedTime.set(value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void increment(Long time) {
        this.counter.incrementAndGet();
        if (time != null) {
            this.elapsedTime.addAndGet(time);
            InvocationStatistics invocationStatistics = this;
            synchronized (invocationStatistics) {
                if (time < this.minElapsedTime.get()) {
                    this.minElapsedTime.set(time);
                }
                if (time > this.maxElapsedTime.get()) {
                    this.maxElapsedTime.set(time);
                }
            }
        }
    }

    @Override
    public long getCounter() {
        return this.counter.get();
    }

    @Override
    public long getTotalElapsedTime() {
        return this.elapsedTime.get();
    }

    @Override
    public long getMinElapsedTime() {
        return this.minElapsedTime.get();
    }

    @Override
    public long getMaxElapsedTime() {
        return this.maxElapsedTime.get();
    }

    @Override
    public double getMeanElapsedTime() {
        long c = this.getCounter();
        if (c <= 0L) {
            return 0.0;
        }
        return this.getTotalElapsedTime() / c;
    }
}

