/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.jmx.commons.views.messages;

import java.util.Map;
import java.util.TreeMap;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.fusesource.ide.foundation.core.util.Strings;
import org.fusesource.ide.foundation.ui.util.Selections;
import org.fusesource.ide.foundation.ui.util.Viewers;
import org.fusesource.ide.jmx.commons.Messages;
import org.fusesource.ide.jmx.commons.messages.Exchange;
import org.fusesource.ide.jmx.commons.messages.Exchanges;
import org.fusesource.ide.jmx.commons.views.messages.MessageUIHelper;

public class MessageDetailView
extends ViewPart
implements IPropertySheetPage {
    private Form form;
    private Exchange selectedExchange;
    private TableViewer headerViewer;
    private Text bodyText;
    private SashForm sash;

    public void createPartControl(Composite parent) {
        this.createControl(parent);
    }

    public void createControl(Composite parent) {
        FormToolkit toolkit = new FormToolkit(Display.getDefault());
        this.form = toolkit.createForm(parent);
        Composite formBody = this.form.getBody();
        formBody.setLayout((Layout)new FillLayout());
        this.form.setText(Messages.MessageDetailFormTitle);
        toolkit.decorateFormHeading(this.form);
        this.sash = new SashForm(formBody, 66048);
        this.sash.setLayout((Layout)new FillLayout());
        Composite compositeUpperTable = new Composite((Composite)this.sash, 0);
        TableColumnLayout tableLayout = new TableColumnLayout();
        compositeUpperTable.setLayout((Layout)tableLayout);
        this.headerViewer = new TableViewer(compositeUpperTable, 2816);
        TableViewerColumn col = this.createTableViewerColumn(Messages.MessageDetailHeadersTableNameColumn, Messages.MessageDetailHeadersTableNameColumnTooltip, 16384);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Map.Entry entry = (Map.Entry)element;
                return Strings.getOrElse(entry.getKey());
            }
        });
        tableLayout.setColumnData((Widget)col.getColumn(), (ColumnLayoutData)new ColumnWeightData(4, 20, true));
        col = this.createTableViewerColumn(Messages.MessageDetailHeadersTableValueColumn, Messages.MessageDetailHeadersTableValueColumnTooltip, 16384);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Map.Entry entry = (Map.Entry)element;
                return Strings.getOrElse(entry.getValue());
            }
        });
        tableLayout.setColumnData((Widget)col.getColumn(), (ColumnLayoutData)new ColumnWeightData(8, 20, true));
        this.headerViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void inputChanged(Viewer v, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object parent) {
                if (parent instanceof Map) {
                    Map map = (Map)parent;
                    return map.entrySet().toArray();
                }
                return new Object[0];
            }
        });
        Table table = this.headerViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.setToolTipText(Messages.MessageDetailHeadersTableToolTip);
        this.headerViewer.setUseHashlookup(true);
        Composite child3 = new Composite((Composite)this.sash, 0);
        child3.setLayout((Layout)new FillLayout());
        this.bodyText = toolkit.createText(child3, "", 2890);
        this.bodyText.setToolTipText(Messages.MessageDetailBodyTextToolTip);
        this.sash.setWeights(new int[]{60, 40});
    }

    private TableViewerColumn createTableViewerColumn(String title, String tooltip, int style) {
        TableViewerColumn viewerColumn = new TableViewerColumn(this.headerViewer, style);
        TableColumn column = viewerColumn.getColumn();
        column.setText(title);
        column.setWidth(100);
        column.setResizable(true);
        column.setMoveable(false);
        column.setToolTipText(tooltip);
        return viewerColumn;
    }

    public void dispose() {
        this.disposeForm();
        super.dispose();
    }

    protected void disposeForm() {
        if (this.form != null && !this.form.isDisposed()) {
            try {
                this.form.dispose();
            }
            catch (Exception exception) {}
        }
        this.form = null;
    }

    public Control getControl() {
        return this.form;
    }

    public void setActionBars(IActionBars actionBars) {
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        Object firstSelection = Selections.getFirstSelection((ISelection)selection);
        Exchange exchange = Exchanges.asExchange(firstSelection);
        this.setSelectedExchange(exchange);
    }

    public void setSelectedExchange(Exchange selectedExchange) {
        this.selectedExchange = selectedExchange;
        this.updateDataBinding();
    }

    protected void updateDataBinding() {
        this.bodyText.setText(MessageUIHelper.getBody(this.selectedExchange));
        Map<String, Object> headers = Exchanges.getHeaders(this.selectedExchange);
        this.headerViewer.setInput(new TreeMap<String, Object>(headers));
        Viewers.refresh((Viewer)this.headerViewer);
        this.layoutForm();
    }

    protected void layoutForm() {
        this.form.setRedraw(true);
    }

    public void setFocus() {
        if (this.headerViewer != null) {
            this.headerViewer.getControl().setFocus();
        }
    }
}

