/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.launcher.debug.model;

import java.io.IOException;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugException;
import org.fusesource.ide.camel.model.service.core.jmx.camel.ICamelDebuggerMBeanFacade;
import org.fusesource.ide.jmx.commons.backlogtracermessage.BacklogTracerEventMessage;
import org.fusesource.ide.jmx.commons.backlogtracermessage.BacklogTracerEventMessageParser;
import org.fusesource.ide.launcher.Activator;
import org.fusesource.ide.launcher.debug.model.CamelDebugTarget;
import org.fusesource.ide.launcher.debug.model.CamelStackFrame;
import org.fusesource.ide.launcher.debug.model.CamelThread;

class EventDispatchJob
extends Job {
    private static final int TIME_WAIT_BETWEEN_CHECKS = 2000;
    private final CamelDebugTarget camelDebugTarget;

    public EventDispatchJob(CamelDebugTarget camelDebugTarget) {
        super("Camel Debug Event Dispatch");
        this.camelDebugTarget = camelDebugTarget;
        this.setSystem(true);
    }

    protected IStatus run(IProgressMonitor monitor) {
        while (!this.camelDebugTarget.isTerminated() && !monitor.isCanceled()) {
            this.checkSuspendedBreakpoints();
        }
        return Status.OK_STATUS;
    }

    private void checkSuspendedBreakpoints() {
        ICamelDebuggerMBeanFacade debugger = this.camelDebugTarget.getDebugger();
        if (debugger != null && !this.camelDebugTarget.isSuspended()) {
            try {
                Set suspendedBreakpoints = debugger.getSuspendedBreakpointNodeIds();
                if (suspendedBreakpoints != null && !suspendedBreakpoints.isEmpty()) {
                    this.handleSuspendedBreakpoints(suspendedBreakpoints);
                }
                Thread.sleep(2000L);
            }
            catch (IOException ioe) {
                Activator.getLogger().warning("The remote connection has been lost, debugger will be disconnected.", (Throwable)ioe);
                try {
                    this.camelDebugTarget.disconnect();
                }
                catch (DebugException e) {
                    Activator.getLogger().error((Throwable)e);
                }
            }
            catch (Exception ex) {
                Activator.getLogger().error((Throwable)ex);
            }
        }
    }

    private void handleSuspendedBreakpoints(Set<String> suspendedBreakpoints) throws DebugException {
        this.camelDebugTarget.suspend();
        for (String nodeId : suspendedBreakpoints) {
            String endpointId;
            BacklogTracerEventMessage evMsg = new BacklogTracerEventMessageParser().getBacklogTracerEventMessage(this.camelDebugTarget.getMessagesForNode(nodeId));
            String id = this.camelDebugTarget.generateKey(evMsg);
            CamelThread t = this.camelDebugTarget.getThreadForId(id);
            CamelStackFrame toStackFrame = t.getTopStackFrame();
            String string = endpointId = toStackFrame != null ? toStackFrame.getEndpointId() : null;
            if (nodeId.equals(endpointId) || t.isSuspended()) continue;
            this.camelDebugTarget.breakpointHit(nodeId, evMsg);
            this.camelDebugTarget.resume();
        }
    }
}

