/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.launcher.debug.model;

import java.io.IOException;
import java.util.HashMap;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugException;
import org.fusesource.ide.foundation.core.util.Strings;
import org.fusesource.ide.launcher.Activator;
import org.fusesource.ide.launcher.debug.model.CamelDebugFacade;
import org.fusesource.ide.launcher.debug.model.CamelDebugTarget;
import org.jboss.tools.jmx.core.IConnectionWrapper;
import org.jboss.tools.jmx.core.IJMXRunnable;
import org.jboss.tools.jmx.core.JMXException;

public class JMXCamelConnectJob
extends Job {
    private static final int TIME_WAIT_BETWEEN_RETRY = 500;
    public static final Object JMX_CONNECT_JOB_FAMILY = new Object();
    private final CamelDebugTarget camelDebugTarget;
    private JMXConnector jmxc = null;
    private MBeanServerConnection mBeanServerConnection;
    private String jmxUser;
    private String jmxPass;
    private static final long CONNECTION_TIMEOUT_IN_MILLIS = 600000L;

    public JMXCamelConnectJob(CamelDebugTarget camelDebugTarget) {
        super("Connect to Camel Debugger...");
        this.camelDebugTarget = camelDebugTarget;
        this.setSystem(false);
    }

    public JMXCamelConnectJob(CamelDebugTarget camelDebugTarget, String jmxUser, String jmxPass) {
        this(camelDebugTarget);
        this.jmxUser = jmxUser;
        this.jmxPass = jmxPass;
    }

    protected IStatus run(IProgressMonitor monitor) {
        monitor.beginTask("Connect to Camel VM...", 1);
        long startTime = System.currentTimeMillis();
        boolean connected = this.connect(monitor, startTime);
        if (!connected) {
            this.abortConnection();
        }
        monitor.done();
        return connected ? Status.OK_STATUS : Status.CANCEL_STATUS;
    }

    private void abortConnection() {
        try {
            this.camelDebugTarget.abort("Unable to connect to Camel VM", new Exception("Unable to connect to Camel Debugger"));
        }
        catch (DebugException ex) {
            Activator.getLogger().error((Throwable)ex);
        }
    }

    private boolean connect(IProgressMonitor monitor, long startTime) {
        boolean connected = false;
        while (!connected && System.currentTimeMillis() - startTime <= 600000L && !monitor.isCanceled()) {
            try {
                connected = this.tryToConnect();
            }
            catch (Exception ex) {
                Activator.getLogger().error((Throwable)ex);
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    monitor.setCanceled(true);
                }
            }
        }
        return connected;
    }

    private boolean tryToConnect() throws MalformedObjectNameException, IOException {
        boolean connected = false;
        if (this.connectToVM()) {
            CamelDebugFacade debugger = new CamelDebugFacade(this.camelDebugTarget, this.mBeanServerConnection, this.camelDebugTarget.getCamelContextId());
            this.camelDebugTarget.setDebugger(debugger);
            connected = true;
            this.camelDebugTarget.started(true);
            if (!debugger.isEnabled()) {
                debugger.enableDebugger();
            }
        }
        return connected;
    }

    boolean connectToVM() {
        try {
            IConnectionWrapper jmxConnectionWrapper = this.camelDebugTarget.getJmxConnectionWrapper();
            this.mBeanServerConnection = jmxConnectionWrapper != null ? this.createMBeanServerConnection(jmxConnectionWrapper) : this.connectToVMUsingCredentials(this.camelDebugTarget.getJmxUri(), this.jmxUser, this.jmxPass);
            return true;
        }
        catch (IOException | JMXException throwable) {
            return false;
        }
    }

    private MBeanServerConnection createMBeanServerConnection(IConnectionWrapper jmxConnectionWrapper) throws IOException, JMXException {
        if (!jmxConnectionWrapper.isConnected()) {
            jmxConnectionWrapper.connect();
        }
        MBeanSerConnectionJMXRunnableRetriever connectionRetriever = new MBeanSerConnectionJMXRunnableRetriever();
        jmxConnectionWrapper.run((IJMXRunnable)connectionRetriever);
        return connectionRetriever.getConnection();
    }

    private MBeanServerConnection connectToVMUsingCredentials(String jmxUri, String jmxUser, String jmxPass) throws IOException {
        JMXServiceURL url = new JMXServiceURL(jmxUri);
        if (!Strings.isBlank((String)jmxUser)) {
            HashMap<String, String[]> envMap = new HashMap<String, String[]>();
            envMap.put("jmx.remote.credentials", new String[]{jmxUser, jmxPass});
            this.jmxc = JMXConnectorFactory.connect(url, envMap);
        } else {
            this.jmxc = JMXConnectorFactory.connect(url);
        }
        return this.jmxc.getMBeanServerConnection();
    }

    protected void canceling() {
        this.clean();
        super.canceling();
    }

    private void clean() {
        try {
            if (this.jmxc != null) {
                this.jmxc.close();
            }
        }
        catch (IOException e) {
            Activator.getLogger().error((Throwable)e);
        }
        if (this.camelDebugTarget != null) {
            try {
                this.camelDebugTarget.terminate();
            }
            catch (DebugException e) {
                Activator.getLogger().error((Throwable)e);
            }
        }
    }

    public boolean belongsTo(Object family) {
        return JMX_CONNECT_JOB_FAMILY.equals(family) || super.belongsTo(family);
    }

    public MBeanServerConnection getMBeanConnection() {
        return this.mBeanServerConnection;
    }

    private final class MBeanSerConnectionJMXRunnableRetriever
    implements IJMXRunnable {
        MBeanServerConnection connection = null;

        private MBeanSerConnectionJMXRunnableRetriever() {
        }

        public void run(MBeanServerConnection connection) throws Exception {
            this.connection = connection;
        }

        MBeanServerConnection getConnection() {
            return this.connection;
        }
    }
}

