/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.launcher.debug.util;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IBreakpoint;
import org.fusesource.ide.camel.model.service.core.model.AbstractCamelModelElement;
import org.fusesource.ide.foundation.core.util.Strings;
import org.fusesource.ide.launcher.Activator;
import org.fusesource.ide.launcher.debug.model.CamelConditionalBreakpoint;
import org.fusesource.ide.launcher.debug.model.CamelEndpointBreakpoint;

public class CamelDebugUtils {
    public static IBreakpoint[] getBreakpointsForContext(String fileName, String projectName) {
        IBreakpoint[] breakpoints;
        ArrayList<IBreakpoint> breakpointsFound = new ArrayList<IBreakpoint>();
        IBreakpoint[] iBreakpointArray = breakpoints = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints("org.fusesource.ide.launcher.debug.camel");
        int n = breakpoints.length;
        int n2 = 0;
        while (n2 < n) {
            IBreakpoint breakpoint = iBreakpointArray[n2];
            CamelEndpointBreakpoint ceb = (CamelEndpointBreakpoint)breakpoint;
            if (fileName != null && projectName != null && ceb != null && ceb.getFileName() != null && ceb.getFileName().equals(fileName) && ceb.getProjectName() != null && ceb.getProjectName().equals(projectName)) {
                breakpointsFound.add(breakpoint);
            }
            ++n2;
        }
        return breakpointsFound.toArray(new IBreakpoint[breakpointsFound.size()]);
    }

    public static IBreakpoint getBreakpointForSelection(String endpointId, String fileName, String projectName) {
        IBreakpoint[] breakpoints;
        IBreakpoint[] iBreakpointArray = breakpoints = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints("org.fusesource.ide.launcher.debug.camel");
        int n = breakpoints.length;
        int n2 = 0;
        while (n2 < n) {
            IBreakpoint breakpoint = iBreakpointArray[n2];
            IMarker marker = breakpoint.getMarker();
            String markerType = null;
            try {
                markerType = marker.getType();
            }
            catch (Exception ex) {
                Activator.getLogger().error((Throwable)ex);
            }
            if (marker != null && ("org.fusesource.ide.launcher.debug.camel.breakpoint.marker".equals(markerType) || "org.fusesource.ide.launcher.debug.camel.conditionalbreakpoint.marker".equals(markerType)) && CamelDebugUtils.breakpointMatchesSelection((CamelEndpointBreakpoint)breakpoint, fileName, endpointId, projectName)) {
                return breakpoint;
            }
            ++n2;
        }
        return null;
    }

    static boolean breakpointMatchesSelection(CamelEndpointBreakpoint breakpoint, String fileName, String endpointId, String projectName) {
        return fileName != null && endpointId != null && projectName != null && breakpoint != null && endpointId.equals(breakpoint.getEndpointNodeId()) && fileName.equals(breakpoint.getFileName()) && projectName.equals(breakpoint.getProjectName());
    }

    public static IBreakpoint createAndRegisterEndpointBreakpoint(IResource resource, AbstractCamelModelElement endpoint, String projectName, String fileName) throws CoreException {
        CamelEndpointBreakpoint epb = new CamelEndpointBreakpoint(resource, endpoint, projectName, fileName);
        DebugPlugin.getDefault().getBreakpointManager().addBreakpoint((IBreakpoint)epb);
        return epb;
    }

    public static IBreakpoint createAndRegisterConditionalBreakpoint(IResource resource, AbstractCamelModelElement endpoint, String projectName, String fileName, String language, String condition) throws CoreException {
        CamelConditionalBreakpoint epb = new CamelConditionalBreakpoint(resource, endpoint, projectName, fileName, language, condition);
        DebugPlugin.getDefault().getBreakpointManager().addBreakpoint((IBreakpoint)epb);
        return epb;
    }

    public static String getEndpointNodeId(IBreakpoint breakpoint) {
        if (breakpoint instanceof CamelEndpointBreakpoint) {
            return ((CamelEndpointBreakpoint)breakpoint).getEndpointNodeId();
        }
        return null;
    }

    public static String getLanguage(IBreakpoint breakpoint) {
        if (breakpoint instanceof CamelConditionalBreakpoint) {
            return ((CamelConditionalBreakpoint)breakpoint).getLanguage();
        }
        return null;
    }

    public static String getCondition(IBreakpoint breakpoint) {
        if (breakpoint instanceof CamelConditionalBreakpoint) {
            return ((CamelConditionalBreakpoint)breakpoint).getConditionPredicate();
        }
        return null;
    }

    public static IProject getProjectForFilePath(String filePath) {
        if (Strings.isBlank((String)filePath)) {
            return null;
        }
        String checkPath = filePath;
        IFile contextFile = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(Path.fromOSString((String)checkPath));
        if (contextFile != null) {
            return contextFile.getProject();
        }
        return null;
    }

    public static String getRawCamelContextFilePathFromLaunchConfig(ILaunchConfiguration launchConfig) {
        if (launchConfig != null) {
            try {
                String fileUnderDebug = launchConfig.getAttribute("rider.file", null);
                if (fileUnderDebug.startsWith("file:")) {
                    fileUnderDebug = fileUnderDebug.substring("file:".length());
                }
                fileUnderDebug = URLDecoder.decode(fileUnderDebug, StandardCharsets.UTF_8.name());
                return fileUnderDebug;
            }
            catch (UnsupportedEncodingException | CoreException ex) {
                Activator.getLogger().error(ex);
            }
        }
        return null;
    }
}

