/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.launcher.util;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.equinox.security.storage.EncodingUtils;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.SecurePreferencesFactory;
import org.eclipse.equinox.security.storage.StorageException;
import org.fusesource.ide.launcher.Activator;

public class SecureStorageUtil {
    private SecureStorageUtil() {
    }

    public static String getFromSecureStorage(String baseKey, ILaunchConfiguration launch, String key) {
        String val;
        block3: {
            ISecurePreferences node = SecureStorageUtil.getNode(baseKey, launch);
            val = node.get(key, null);
            if (val != null) break block3;
            return null;
        }
        try {
            return new String(EncodingUtils.decodeBase64((String)val));
        }
        catch (IOException | StorageException e) {
            Activator.getLogger().error(e);
            return null;
        }
    }

    public static void storeInSecureStorage(String baseKey, ILaunchConfiguration launch, String key, String val) throws StorageException, UnsupportedEncodingException {
        ISecurePreferences node = SecureStorageUtil.getNode(baseKey, launch);
        if (val == null) {
            node.put(key, val, true);
        } else {
            node.put(key, EncodingUtils.encodeBase64((byte[])val.getBytes(StandardCharsets.UTF_8)), true);
        }
    }

    private static ISecurePreferences getNode(String baseKey, ILaunchConfiguration launch) throws UnsupportedEncodingException {
        String secureKey = baseKey + launch.getName() + '/';
        ISecurePreferences root = SecurePreferencesFactory.getDefault();
        String encoded = URLEncoder.encode(secureKey, StandardCharsets.UTF_8.name());
        return root.node(encoded);
    }
}

