/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.projecttemplates.impl.simple;

import java.io.IOException;
import java.io.InputStream;
import org.fusesource.ide.foundation.core.util.VersionUtil;
import org.fusesource.ide.projecttemplates.adopters.AbstractProjectTemplate;
import org.fusesource.ide.projecttemplates.adopters.configurators.MavenTemplateConfigurator;
import org.fusesource.ide.projecttemplates.adopters.configurators.TemplateConfiguratorSupport;
import org.fusesource.ide.projecttemplates.adopters.creators.TemplateCreatorSupport;
import org.fusesource.ide.projecttemplates.adopters.creators.UnzipStreamCreator;
import org.fusesource.ide.projecttemplates.adopters.util.CamelDSLType;
import org.fusesource.ide.projecttemplates.adopters.util.InvalidProjectMetaDataException;
import org.fusesource.ide.projecttemplates.util.CommonNewProjectMetaData;
import org.fusesource.ide.projecttemplates.util.ICamelDSLTypeSupport;

public class AMQTemplate
extends AbstractProjectTemplate {
    @Override
    public boolean supportsDSL(CamelDSLType type) {
        switch (type) {
            case BLUEPRINT: {
                return true;
            }
            case SPRING: {
                return true;
            }
            case JAVA: {
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean isCompatible(String camelVersion) {
        return new VersionUtil().isStrictlyLowerThan2200(camelVersion);
    }

    @Override
    public TemplateConfiguratorSupport getConfigurator() {
        return new MavenTemplateConfigurator(null);
    }

    @Override
    public TemplateCreatorSupport getCreator(CommonNewProjectMetaData projectMetaData) {
        return new AMQUnzipTemplateCreator();
    }

    private class AMQUnzipTemplateCreator
    extends UnzipStreamCreator {
        private static final String TEMPLATE_FOLDER = "templates/";
        private static final String TEMPLATE_BLUEPRINT = "template-simple-amq-blueprint.zip";
        private static final String TEMPLATE_SPRING = "template-simple-amq-spring.zip";

        private AMQUnzipTemplateCreator() {
        }

        @Override
        public InputStream getTemplateStream(CommonNewProjectMetaData metadata) throws IOException, InvalidProjectMetaDataException {
            String bundleEntry = null;
            if (metadata instanceof ICamelDSLTypeSupport) {
                switch (((ICamelDSLTypeSupport)((Object)metadata)).getDslType()) {
                    case BLUEPRINT: {
                        bundleEntry = String.format("%s%s", TEMPLATE_FOLDER, TEMPLATE_BLUEPRINT);
                        break;
                    }
                    case SPRING: {
                        bundleEntry = String.format("%s%s", TEMPLATE_FOLDER, TEMPLATE_SPRING);
                    }
                }
                return this.getTemplateStream(bundleEntry);
            }
            throw new InvalidProjectMetaDataException("Invalid project metadata not supporting Camel DSL types");
        }
    }
}

