/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.projecttemplates.impl.simple;

import java.io.IOException;
import java.io.InputStream;
import org.fusesource.ide.projecttemplates.adopters.AbstractProjectTemplate;
import org.fusesource.ide.projecttemplates.adopters.creators.UnzipStreamCreator;
import org.fusesource.ide.projecttemplates.adopters.util.CamelDSLType;
import org.fusesource.ide.projecttemplates.adopters.util.InvalidProjectMetaDataException;
import org.fusesource.ide.projecttemplates.util.CommonNewProjectMetaData;
import org.fusesource.ide.projecttemplates.util.ICamelDSLTypeSupport;

public abstract class AbstractCBRTemplate
extends AbstractProjectTemplate {
    @Override
    public boolean supportsDSL(CamelDSLType type) {
        switch (type) {
            case BLUEPRINT: {
                return true;
            }
            case SPRING: {
                return true;
            }
            case JAVA: {
                return true;
            }
        }
        return false;
    }

    protected class CBRUnzipTemplateCreator
    extends UnzipStreamCreator {
        private String suffix;
        private static final String TEMPLATE_FOLDER = "templates/";
        private static final String TEMPLATE_BLUEPRINT = "template-simple-cbr-blueprint-fuse";
        private static final String TEMPLATE_SPRING = "template-simple-cbr-spring-fuse";
        private static final String TEMPLATE_JAVA = "template-simple-cbr-java-fuse";

        public CBRUnzipTemplateCreator(String suffix) {
            this.suffix = suffix;
        }

        @Override
        public InputStream getTemplateStream(CommonNewProjectMetaData metadata) throws IOException, InvalidProjectMetaDataException {
            String bundleEntry = null;
            if (metadata instanceof ICamelDSLTypeSupport) {
                switch (((ICamelDSLTypeSupport)((Object)metadata)).getDslType()) {
                    case BLUEPRINT: {
                        bundleEntry = this.getBundleEntry(TEMPLATE_BLUEPRINT);
                        break;
                    }
                    case SPRING: {
                        bundleEntry = this.getBundleEntry(TEMPLATE_SPRING);
                        break;
                    }
                    case JAVA: {
                        bundleEntry = this.getBundleEntry(TEMPLATE_JAVA);
                    }
                }
                return this.getTemplateStream(bundleEntry);
            }
            throw new IOException("Invalid project metadata not supporting Camel DSL types");
        }

        private String getBundleEntry(String templateDsl) {
            return String.format("%s%s%s.zip", TEMPLATE_FOLDER, templateDsl, this.suffix);
        }
    }
}

