/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.projecttemplates.wizards.pages.filter;

import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.fusesource.ide.projecttemplates.wizards.pages.model.CategoryItem;
import org.fusesource.ide.projecttemplates.wizards.pages.model.TemplateItem;

public class CompatibleCamelVersionFilter
extends ViewerFilter {
    private String camelVersion;

    public CompatibleCamelVersionFilter(String camelVersion) {
        this.setCamelVersion(camelVersion);
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (element instanceof TemplateItem) {
            return ((TemplateItem)element).isCompatible(this.camelVersion);
        }
        if (element instanceof CategoryItem) {
            return this.hasCompatibleChildren((CategoryItem)element);
        }
        return true;
    }

    private boolean hasCompatibleChildren(CategoryItem category) {
        boolean hasCompatibleTemplate = category.getTemplates().stream().anyMatch(template -> template.isCompatible(this.camelVersion));
        if (!hasCompatibleTemplate) {
            for (CategoryItem subCat : category.getSubCategories()) {
                if (!this.hasCompatibleChildren(subCat)) continue;
                return true;
            }
        }
        return hasCompatibleTemplate;
    }

    public void setCamelVersion(String camelVersion) {
        this.camelVersion = camelVersion;
    }
}

